/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class BulletHandler {
    public static ItemStack emptyCasing = ItemStack.EMPTY;
    public static ItemStack emptyShell = ItemStack.EMPTY;
    public static ItemStack basicCartridge = ItemStack.EMPTY;
    public static List<String> homingCartridges = new ArrayList<String>();
    public static HashMap<String, IBullet> registry = new LinkedHashMap<String, IBullet>();

    public static void registerBullet(String name, IBullet bullet) {
        registry.put(name, bullet);
    }

    public static IBullet getBullet(String name) {
        name = BulletHandler.handleLeagcyNames(name);
        return registry.get(name);
    }

    public static String findRegistryName(IBullet bullet) {
        if (bullet != null) {
            for (Map.Entry<String, IBullet> entry : registry.entrySet()) {
                if (!bullet.equals(entry.getValue())) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public static ItemStack getBulletStack(String key) {
        key = BulletHandler.handleLeagcyNames(key);
        ItemStack stack = basicCartridge.copy();
        stack.setTagCompound(new NBTTagCompound());
        stack.getTagCompound().setString("bullet", key);
        return stack;
    }

    public static String handleLeagcyNames(String key) {
        if (key.equals("armorPiercing")) {
            return "armor_piercing";
        }
        if (key.equals("HE")) {
            return "he";
        }
        return key;
    }

    public static class DamagingBullet
    implements IBullet {
        final Function<Entity[], DamageSource> damageSourceGetter;
        final float damage;
        boolean resetHurt = false;
        boolean setFire = false;
        ItemStack casing;
        ResourceLocation[] textures;

        public DamagingBullet(Function<Entity[], DamageSource> damageSourceGetter, float damage, ItemStack casing, ResourceLocation ... textures) {
            this(damageSourceGetter, damage, false, false, casing, textures);
        }

        public DamagingBullet(Function<Entity[], DamageSource> damageSourceGetter, float damage, boolean resetHurt, boolean setFire, ItemStack casing, ResourceLocation ... textures) {
            this.damageSourceGetter = damageSourceGetter;
            this.damage = damage;
            this.resetHurt = resetHurt;
            this.setFire = setFire;
            this.casing = casing;
            this.textures = textures;
        }

        float getDamage(boolean headshot) {
            return this.damage * (headshot ? 1.5f : 1.0f);
        }

        @Override
        public void onHitTarget(World world, RayTraceResult target, @Nullable EntityLivingBase shooter, Entity projectile, boolean headshot) {
            if (!world.isRemote && target.entityHit != null && this.damageSourceGetter != null && target.entityHit.attackEntityFrom(this.damageSourceGetter.apply(new Entity[]{projectile, shooter, target.entityHit}), this.getDamage(headshot))) {
                if (this.resetHurt) {
                    target.entityHit.hurtResistantTime = 0;
                }
                if (this.setFire) {
                    target.entityHit.setFire(3);
                }
            }
        }

        @Override
        public ItemStack getCasing(ItemStack stack) {
            return this.casing;
        }

        @Override
        public ResourceLocation[] getTextures() {
            return this.textures;
        }

        @Override
        public int getColour(ItemStack stack, int layer) {
            return -1;
        }

        @Override
        public boolean isValidForTurret() {
            return true;
        }
    }

    public static interface IBullet {
        default public boolean isProperCartridge() {
            return true;
        }

        default public String getUnlocalizedName(ItemStack cartridge, String baseName) {
            return baseName;
        }

        default public void addTooltip(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        }

        default public int getProjectileCount(@Nullable EntityPlayer shooter) {
            return 1;
        }

        default public Entity getProjectile(@Nullable EntityPlayer shooter, ItemStack cartridge, Entity projectile, boolean charged) {
            return projectile;
        }

        public void onHitTarget(World var1, RayTraceResult var2, @Nullable EntityLivingBase var3, Entity var4, boolean var5);

        public ItemStack getCasing(ItemStack var1);

        public ResourceLocation[] getTextures();

        public int getColour(ItemStack var1, int var2);

        default public boolean isValidForTurret() {
            return false;
        }

        default public SoundEvent getSound() {
            return null;
        }
    }
}

