/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChorusPlant;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockStem;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class BelljarHandler {
    private static HashSet<IPlantHandler> plantHandlers = new HashSet();
    private static HashMap<ComparableItemStack, ResourceLocation> soilTextureMap = new HashMap();
    private static HashSet<FluidFertilizerHandler> fluidFertilizers = new HashSet();
    private static HashSet<ItemFertilizerHandler> itemFertilizers = new HashSet();
    private static HashMap<ComparableItemStack, IngredientStack> seedSoilMap = new HashMap();
    private static HashMap<ComparableItemStack, ItemStack[]> seedOutputMap = new HashMap();
    private static HashMap<ComparableItemStack, IBlockState[]> seedRenderMap = new HashMap();
    public static DefaultPlantHandler cropHandler = new DefaultPlantHandler(){
        private HashSet<ComparableItemStack> validSeeds = new HashSet();

        @Override
        protected HashSet<ComparableItemStack> getSeedSet() {
            return this.validSeeds;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public IBlockState[] getRenderedPlant(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
            IBlockState[] states = (IBlockState[])seedRenderMap.get(new ComparableItemStack(seed, false));
            if (states != null) {
                IBlockState[] ret = new IBlockState[states.length];
                for (int i = 0; i < states.length; ++i) {
                    if (states[i] == null) continue;
                    if (states[i].getBlock() instanceof BlockCrops) {
                        int max = ((BlockCrops)states[i].getBlock()).getMaxAge();
                        ret[i] = ((BlockCrops)states[i].getBlock()).withAge(Math.min(max, Math.round((float)max * growth)));
                        continue;
                    }
                    for (IProperty prop : states[i].getPropertyKeys()) {
                        if (!"age".equals(prop.getName()) || !(prop instanceof PropertyInteger)) continue;
                        int max = 0;
                        for (Integer allowed : ((PropertyInteger)prop).getAllowedValues()) {
                            if (allowed == null || allowed <= max) continue;
                            max = allowed;
                        }
                        ret[i] = states[i].withProperty(prop, (Comparable)Integer.valueOf(Math.min(max, Math.round((float)max * growth))));
                    }
                    if (ret[i] != null) continue;
                    ret[i] = states[i];
                }
                return ret;
            }
            return null;
        }
    };
    public static DefaultPlantHandler stemHandler = new DefaultPlantHandler(){
        private HashSet<ComparableItemStack> validSeeds = new HashSet();

        @Override
        protected HashSet<ComparableItemStack> getSeedSet() {
            return this.validSeeds;
        }

        @Override
        public float getGrowthStep(ItemStack seed, ItemStack soil, float growth, TileEntity tile, float fertilizer, boolean render) {
            return ((double)growth < 0.5 ? 0.00625f : 0.0015625f) * fertilizer;
        }

        @Override
        public float resetGrowth(ItemStack seed, ItemStack soil, float growth, TileEntity tile, boolean render) {
            return 0.5f;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public IBlockState[] getRenderedPlant(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
            return new IBlockState[0];
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public float getRenderSize(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
            return 1.0f;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean overrideRender(ItemStack seed, ItemStack soil, float growth, TileEntity tile, BlockRendererDispatcher blockRenderer) {
            ComparableItemStack comp = new ComparableItemStack(seed, false);
            IBlockState[] renderStates = (IBlockState[])seedRenderMap.get(comp);
            if (renderStates.length > 0 && renderStates[0] != null && renderStates[0].getBlock() instanceof BlockStem) {
                Block fruitBlock;
                ItemStack[] fruit;
                GlStateManager.rotate((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                BlockStem stem = (BlockStem)renderStates[0].getBlock();
                IBlockState state = stem.getDefaultState().withProperty((IProperty)BlockStem.AGE, (Comparable)Integer.valueOf((int)((double)growth >= 0.5 ? 7.0f : 2.0f * growth * 7.0f)));
                if ((double)growth >= 0.5) {
                    state = state.withProperty((IProperty)BlockStem.FACING, (Comparable)EnumFacing.NORTH);
                }
                IBakedModel model = blockRenderer.getModelForState(state);
                GlStateManager.translate((float)0.25f, (float)0.0625f, (float)0.0f);
                GlStateManager.pushMatrix();
                blockRenderer.getBlockModelRenderer().renderModelBrightness(model, state, 1.0f, true);
                GlStateManager.popMatrix();
                if ((double)growth >= 0.5 && (fruit = (ItemStack[])seedOutputMap.get(new ComparableItemStack(seed, false))) != null && fruit.length > 0 && !fruit[0].isEmpty() && (fruitBlock = Block.getBlockFromItem((Item)fruit[0].getItem())) != null) {
                    state = fruitBlock.getDefaultState();
                    model = blockRenderer.getModelForState(state);
                    GlStateManager.pushMatrix();
                    float scale = (growth - 0.5f) * 0.5f;
                    GlStateManager.translate((double)(-scale / 2.0f), (double)(0.5 - (double)scale), (double)(-0.5 + (double)(scale / 2.0f)));
                    GlStateManager.scale((float)scale, (float)scale, (float)scale);
                    blockRenderer.getBlockModelRenderer().renderModelBrightness(model, state, 1.0f, true);
                    GlStateManager.popMatrix();
                }
            }
            return true;
        }
    };
    public static DefaultPlantHandler stackingHandler = new DefaultPlantHandler(){
        private HashSet<ComparableItemStack> validSeeds = new HashSet();

        @Override
        protected HashSet<ComparableItemStack> getSeedSet() {
            return this.validSeeds;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public IBlockState[] getRenderedPlant(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
            IBlockState[] states = (IBlockState[])seedRenderMap.get(new ComparableItemStack(seed, false));
            if (states != null) {
                return states;
            }
            return null;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public float getRenderSize(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
            IBlockState[] states = (IBlockState[])seedRenderMap.get(new ComparableItemStack(seed, false));
            if (states != null && states.length > 2) {
                return 0.6875f - (float)states.length * 0.0625f;
            }
            return 0.6875f;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean overrideRender(ItemStack seed, ItemStack soil, float growth, TileEntity tile, BlockRendererDispatcher blockRenderer) {
            IBlockState[] states = (IBlockState[])seedRenderMap.get(new ComparableItemStack(seed, false));
            if (states != null) {
                GlStateManager.translate((float)0.0f, (float)((-1.0f + growth) * (float)(states.length - 1)), (float)0.0f);
            }
            return false;
        }
    };

    public static void registerHandler(IPlantHandler handler) {
        plantHandlers.add(handler);
    }

    public static IPlantHandler getHandler(ItemStack seed) {
        if (seed.isEmpty()) {
            return null;
        }
        for (IPlantHandler handler : plantHandlers) {
            if (!handler.isValid(seed)) continue;
            return handler;
        }
        return null;
    }

    public static void registerFluidFertilizer(FluidFertilizerHandler handler) {
        fluidFertilizers.add(handler);
    }

    public static FluidFertilizerHandler getFluidFertilizerHandler(FluidStack fluid) {
        if (fluid == null) {
            return null;
        }
        for (FluidFertilizerHandler handler : fluidFertilizers) {
            if (!handler.isValid(fluid)) continue;
            return handler;
        }
        return null;
    }

    public static void registerItemFertilizer(ItemFertilizerHandler handler) {
        itemFertilizers.add(handler);
    }

    public static ItemFertilizerHandler getItemFertilizerHandler(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return null;
        }
        for (ItemFertilizerHandler handler : itemFertilizers) {
            if (!handler.isValid(itemStack)) continue;
            return handler;
        }
        return null;
    }

    public static void registerBasicItemFertilizer(final ItemStack stack, final float growthMultiplier) {
        BelljarHandler.registerItemFertilizer(new ItemFertilizerHandler(){

            @Override
            public boolean isValid(@Nullable ItemStack fertilizer) {
                return OreDictionary.itemMatches((ItemStack)stack, (ItemStack)fertilizer, (boolean)false);
            }

            @Override
            public float getGrowthMultiplier(ItemStack fertilizer, ItemStack seed, ItemStack soil, TileEntity tile) {
                return growthMultiplier;
            }
        });
    }

    public static ResourceLocation getSoilTexture(ItemStack soil) {
        return soilTextureMap.get(new ComparableItemStack(soil, false));
    }

    static {
        soilTextureMap.put(new ComparableItemStack(new ItemStack(Blocks.DIRT), false), new ResourceLocation("minecraft:blocks/farmland_wet"));
        BelljarHandler.registerHandler(cropHandler);
        BelljarHandler.registerHandler(stemHandler);
        BelljarHandler.registerHandler(stackingHandler);
        cropHandler.register(new ItemStack(Items.WHEAT_SEEDS), new ItemStack[]{new ItemStack(Items.WHEAT, 2), new ItemStack(Items.WHEAT_SEEDS, 1)}, new ItemStack(Blocks.DIRT), Blocks.WHEAT.getDefaultState());
        cropHandler.register(new ItemStack(Items.POTATO), new ItemStack[]{new ItemStack(Items.POTATO, 2)}, new ItemStack(Blocks.DIRT), Blocks.POTATOES.getDefaultState());
        cropHandler.register(new ItemStack(Items.CARROT), new ItemStack[]{new ItemStack(Items.CARROT, 2)}, new ItemStack(Blocks.DIRT), Blocks.CARROTS.getDefaultState());
        cropHandler.register(new ItemStack(Items.BEETROOT_SEEDS), new ItemStack[]{new ItemStack(Items.BEETROOT, 2), new ItemStack(Items.BEETROOT_SEEDS, 1)}, new ItemStack(Blocks.DIRT), Blocks.BEETROOTS.getDefaultState());
        cropHandler.register(new ItemStack(Items.NETHER_WART), new ItemStack[]{new ItemStack(Items.NETHER_WART, 2)}, new ItemStack(Blocks.SOUL_SAND), Blocks.NETHER_WART.getDefaultState());
        stemHandler.register(new ItemStack(Items.PUMPKIN_SEEDS), new ItemStack[]{new ItemStack(Blocks.PUMPKIN)}, new ItemStack(Blocks.DIRT), Blocks.PUMPKIN_STEM.getDefaultState());
        stemHandler.register(new ItemStack(Items.MELON_SEEDS), new ItemStack[]{new ItemStack(Blocks.MELON_BLOCK)}, new ItemStack(Blocks.DIRT), Blocks.MELON_STEM.getDefaultState());
        stackingHandler.register(new ItemStack(Items.REEDS), new ItemStack[]{new ItemStack(Items.REEDS, 2)}, "sand", Blocks.REEDS.getDefaultState(), Blocks.REEDS.getDefaultState());
        stackingHandler.register(new ItemStack((Block)Blocks.CACTUS), new ItemStack[]{new ItemStack((Block)Blocks.CACTUS, 2)}, "sand", Blocks.CACTUS.getDefaultState(), Blocks.CACTUS.getDefaultState());
        stackingHandler.register(new ItemStack(Blocks.CHORUS_FLOWER), new ItemStack[]{new ItemStack(Items.CHORUS_FRUIT, 1)}, new ItemStack(Blocks.END_STONE), Blocks.CHORUS_PLANT.getDefaultState().withProperty((IProperty)BlockChorusPlant.DOWN, (Comparable)Boolean.valueOf(true)).withProperty((IProperty)BlockChorusPlant.UP, (Comparable)Boolean.valueOf(true)), Blocks.CHORUS_PLANT.getDefaultState().withProperty((IProperty)BlockChorusPlant.DOWN, (Comparable)Boolean.valueOf(true)).withProperty((IProperty)BlockChorusPlant.UP, (Comparable)Boolean.valueOf(true)), Blocks.CHORUS_FLOWER.getDefaultState());
        IngredientStack shroomSoil = new IngredientStack((List<ItemStack>)ImmutableList.of((Object)new ItemStack((Block)Blocks.MYCELIUM), (Object)new ItemStack(Blocks.DIRT, 1, 2)));
        cropHandler.register(new ItemStack((Block)Blocks.RED_MUSHROOM), new ItemStack[]{new ItemStack((Block)Blocks.RED_MUSHROOM, 2)}, shroomSoil, Blocks.RED_MUSHROOM.getDefaultState());
        cropHandler.register(new ItemStack((Block)Blocks.BROWN_MUSHROOM), new ItemStack[]{new ItemStack((Block)Blocks.BROWN_MUSHROOM, 2)}, shroomSoil, Blocks.BROWN_MUSHROOM.getDefaultState());
        BelljarHandler.registerFluidFertilizer(new FluidFertilizerHandler(){

            @Override
            public boolean isValid(@Nullable FluidStack fertilizer) {
                return fertilizer != null && fertilizer.getFluid() == FluidRegistry.WATER;
            }

            @Override
            public float getGrowthMultiplier(FluidStack fertilizer, ItemStack seed, ItemStack soil, TileEntity tile) {
                return 1.0f;
            }
        });
        BelljarHandler.registerItemFertilizer(new ItemFertilizerHandler(){
            final ItemStack bonemeal = new ItemStack(Items.DYE, 1, 15);

            @Override
            public boolean isValid(ItemStack fertilizer) {
                return !fertilizer.isEmpty() && OreDictionary.itemMatches((ItemStack)this.bonemeal, (ItemStack)fertilizer, (boolean)true);
            }

            @Override
            public float getGrowthMultiplier(ItemStack fertilizer, ItemStack seed, ItemStack soil, TileEntity tile) {
                return 1.25f;
            }
        });
    }

    public static abstract class DefaultPlantHandler
    implements IPlantHandler {
        protected abstract HashSet<ComparableItemStack> getSeedSet();

        @Override
        public boolean isValid(ItemStack seed) {
            return seed != null && this.getSeedSet().contains(new ComparableItemStack(seed, false));
        }

        @Override
        public boolean isCorrectSoil(ItemStack seed, ItemStack soil) {
            IngredientStack reqSoil = (IngredientStack)seedSoilMap.get(new ComparableItemStack(seed, false));
            return reqSoil.matchesItemStack(soil);
        }

        @Override
        public float getGrowthStep(ItemStack seed, ItemStack soil, float growth, TileEntity tile, float fertilizer, boolean render) {
            return 0.003125f * fertilizer;
        }

        @Override
        public ItemStack[] getOutput(ItemStack seed, ItemStack soil, TileEntity tile) {
            return (ItemStack[])seedOutputMap.get(new ComparableItemStack(seed, false));
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public IBlockState[] getRenderedPlant(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
            IBlockState[] states = (IBlockState[])seedRenderMap.get(new ComparableItemStack(seed, false));
            if (states != null) {
                return states;
            }
            return null;
        }

        public void register(ItemStack seed, ItemStack[] output, Object soil, IBlockState ... render) {
            this.register(seed, output, ApiUtils.createIngredientStack(soil), render);
        }

        public void register(ItemStack seed, ItemStack[] output, IngredientStack soil, IBlockState ... render) {
            ComparableItemStack comp = new ComparableItemStack(seed, false);
            this.getSeedSet().add(comp);
            seedSoilMap.put(comp, soil);
            seedOutputMap.put(comp, output);
            seedRenderMap.put(comp, render);
        }
    }

    public static interface ItemFertilizerHandler {
        public boolean isValid(ItemStack var1);

        public float getGrowthMultiplier(ItemStack var1, ItemStack var2, ItemStack var3, TileEntity var4);
    }

    public static interface FluidFertilizerHandler {
        public boolean isValid(@Nullable FluidStack var1);

        public float getGrowthMultiplier(FluidStack var1, ItemStack var2, ItemStack var3, TileEntity var4);
    }

    public static interface IPlantRenderer {
        public boolean isValid(ItemStack var1);

        @SideOnly(value=Side.CLIENT)
        public IBlockState[] getRenderedPlant(ItemStack var1, ItemStack var2, float var3, TileEntity var4);

        @SideOnly(value=Side.CLIENT)
        default public boolean overrideRender(ItemStack seed, ItemStack soil, float growth, TileEntity tile, BlockRendererDispatcher blockRenderer) {
            return false;
        }

        @SideOnly(value=Side.CLIENT)
        default public float getRenderSize(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
            return 0.875f;
        }
    }

    public static interface IPlantHandler
    extends IPlantRenderer {
        public boolean isCorrectSoil(ItemStack var1, ItemStack var2);

        public float getGrowthStep(ItemStack var1, ItemStack var2, float var3, TileEntity var4, float var5, boolean var6);

        public ItemStack[] getOutput(ItemStack var1, ItemStack var2, TileEntity var3);

        default public float resetGrowth(ItemStack seed, ItemStack soil, float growth, TileEntity tile, boolean render) {
            return 0.0f;
        }

        default public ResourceLocation getSoilTexture(ItemStack seed, ItemStack soil, TileEntity tile) {
            return null;
        }
    }
}

