/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class AssemblerHandler {
    private static final HashMap<Class<? extends IRecipe>, IRecipeAdapter> registry = new LinkedHashMap<Class<? extends IRecipe>, IRecipeAdapter>();
    private static final List<Function<Object, RecipeQuery>> specialQueryConverters = new ArrayList<Function<Object, RecipeQuery>>();

    public static void registerRecipeAdapter(Class<? extends IRecipe> recipeClass, IRecipeAdapter adapter) {
        registry.put(recipeClass, adapter);
    }

    public static IRecipeAdapter findAdapterForClass(Class<? extends IRecipe> recipeClass) {
        IRecipeAdapter adapter = registry.get(recipeClass);
        if (adapter == null && recipeClass != IRecipe.class && recipeClass.getSuperclass() != Object.class) {
            adapter = AssemblerHandler.findAdapterForClass(recipeClass.getSuperclass());
            registry.put(recipeClass, adapter);
        }
        return adapter;
    }

    public static IRecipeAdapter findAdapter(IRecipe recipe) {
        return AssemblerHandler.findAdapterForClass(recipe.getClass());
    }

    public static void registerSpecialQueryConverters(Function<Object, RecipeQuery> func) {
        specialQueryConverters.add(func);
    }

    public static RecipeQuery createQuery(Object o) {
        if (o == null) {
            return null;
        }
        for (Function<Object, RecipeQuery> func : specialQueryConverters) {
            RecipeQuery q = func.apply(o);
            if (q == null) continue;
            return q;
        }
        if (o instanceof ItemStack) {
            ItemStack stack = (ItemStack)o;
            if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && FluidUtil.getFluidContained((ItemStack)stack) != null) {
                return new RecipeQuery(FluidUtil.getFluidContained((ItemStack)stack), stack.getCount());
            }
            return new RecipeQuery(stack, stack.getCount());
        }
        if (o instanceof Ingredient) {
            ItemStack[] stacks = ((Ingredient)o).getMatchingStacks();
            if (stacks.length <= 0) {
                return null;
            }
            return new RecipeQuery(stacks, 1);
        }
        if (o instanceof IngredientStack) {
            return new RecipeQuery(o, ((IngredientStack)o).inputSize);
        }
        return new RecipeQuery(o, 1);
    }

    public static class RecipeQuery {
        public Object query;
        public int querySize;

        public RecipeQuery(Object query, int querySize) {
            this.query = query;
            this.querySize = querySize;
        }
    }

    public static interface IRecipeAdapter<R extends IRecipe> {
        public RecipeQuery[] getQueriedInputs(R var1);

        default public RecipeQuery[] getQueriedInputs(R recipe, NonNullList<ItemStack> input) {
            return this.getQueriedInputs(recipe);
        }
    }
}

