/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.shader;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.util.INBTSerializable;

public class CapabilityShader {
    @CapabilityInject(value=ShaderWrapper.class)
    public static Capability<ShaderWrapper> SHADER_CAPABILITY = null;
    public static IUnlistedProperty<ShaderWrapper> BLOCKSTATE_PROPERTY = new IUnlistedProperty<ShaderWrapper>(){

        public String getName() {
            return "shaderwrapper";
        }

        public boolean isValid(ShaderWrapper value) {
            return true;
        }

        public Class<ShaderWrapper> getType() {
            return ShaderWrapper.class;
        }

        public String valueToString(ShaderWrapper value) {
            return value.toString();
        }
    };

    public static void register() {
        CapabilityManager.INSTANCE.register(ShaderWrapper.class, (Capability.IStorage)new Capability.IStorage<ShaderWrapper>(){

            public NBTBase writeNBT(Capability<ShaderWrapper> capability, ShaderWrapper instance, EnumFacing side) {
                NBTTagCompound nbt = new NBTTagCompound();
                ItemStack shader = instance.getShaderItem();
                if (!shader.isEmpty()) {
                    shader.writeToNBT(nbt);
                } else {
                    nbt.setString("IE:NoShader", "");
                }
                nbt.setString("IE:ShaderType", instance.getShaderType());
                return nbt;
            }

            public void readNBT(Capability<ShaderWrapper> capability, ShaderWrapper instance, EnumFacing side, NBTBase nbt) {
                NBTTagCompound tags = (NBTTagCompound)nbt;
                instance.setShaderType(tags.getString("IE:ShaderType"));
                if (!tags.hasKey("IE:NoShader")) {
                    instance.setShaderItem(new ItemStack(tags));
                }
            }
        }, (Callable)new Callable<ShaderWrapper>(){

            @Override
            public ShaderWrapper call() throws Exception {
                return new ShaderWrapper_Direct("");
            }
        });
    }

    public static class ShaderWrapper_Direct
    extends ShaderWrapper
    implements ICapabilityProvider,
    INBTSerializable<NBTTagCompound> {
        @Nonnull
        protected ItemStack shader = ItemStack.EMPTY;

        public ShaderWrapper_Direct(String type) {
            super(type);
        }

        @Override
        public void setShaderItem(@Nonnull ItemStack shader) {
            this.shader = shader;
        }

        @Override
        @Nonnull
        public ItemStack getShaderItem() {
            return this.shader;
        }

        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == SHADER_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == SHADER_CAPABILITY) {
                return (T)this;
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            ItemStack shader = this.getShaderItem();
            if (!shader.isEmpty()) {
                shader.writeToNBT(nbt);
            } else {
                nbt.setString("IE:NoShader", "");
            }
            nbt.setString("IE:ShaderType", this.getShaderType());
            return nbt;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            NBTTagCompound tags = nbt;
            this.setShaderType(tags.getString("IE:ShaderType"));
            if (!tags.hasKey("IE:NoShader")) {
                this.setShaderItem(new ItemStack(tags));
            }
        }
    }

    public static class ShaderWrapper_Item
    extends ShaderWrapper {
        public static final String SHADER_NBT_KEY = "IE:Shader";
        protected final ItemStack container;

        public ShaderWrapper_Item(String type, ItemStack container) {
            super(type);
            this.container = container;
        }

        @Override
        public void setShaderItem(ItemStack shader) {
            if (!this.container.hasTagCompound()) {
                this.container.setTagCompound(new NBTTagCompound());
            }
            if (!shader.isEmpty()) {
                NBTTagCompound shaderTag = shader.writeToNBT(new NBTTagCompound());
                this.container.getTagCompound().setTag(SHADER_NBT_KEY, (NBTBase)shaderTag);
            } else {
                this.container.getTagCompound().removeTag(SHADER_NBT_KEY);
            }
        }

        @Override
        @Nullable
        public ItemStack getShaderItem() {
            NBTTagCompound tagCompound = this.container.getTagCompound();
            if (tagCompound == null || !tagCompound.hasKey(SHADER_NBT_KEY)) {
                return ItemStack.EMPTY;
            }
            return new ItemStack(tagCompound.getCompoundTag(SHADER_NBT_KEY));
        }
    }

    public static abstract class ShaderWrapper {
        protected String shaderType;

        public ShaderWrapper(String type) {
            this.shaderType = type;
        }

        public void setShaderType(String shaderType) {
            this.shaderType = shaderType;
        }

        public String getShaderType() {
            return this.shaderType;
        }

        public abstract void setShaderItem(@Nonnull ItemStack var1);

        @Nonnull
        public abstract ItemStack getShaderItem();
    }
}

