/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy.wires;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.DimensionBlockPos;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IICProxy;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.IESaveData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class ImmersiveNetHandler {
    public static final ImmersiveNetHandler INSTANCE = new ImmersiveNetHandler();
    public Map<Integer, ConcurrentHashMap<BlockPos, Set<Connection>>> directConnections = new ConcurrentHashMap<Integer, ConcurrentHashMap<BlockPos, Set<Connection>>>();
    public Map<BlockPos, Set<AbstractConnection>> indirectConnections = new ConcurrentHashMap<BlockPos, Set<AbstractConnection>>();
    public Map<Integer, HashMap<Connection, Integer>> transferPerTick = new HashMap<Integer, HashMap<Connection, Integer>>();
    public Map<DimensionBlockPos, IICProxy> proxies = new ConcurrentHashMap<DimensionBlockPos, IICProxy>();

    private ConcurrentHashMap<BlockPos, Set<Connection>> getMultimap(int dimension) {
        if (this.directConnections.get(dimension) == null) {
            ConcurrentHashMap mm = new ConcurrentHashMap();
            this.directConnections.put(dimension, mm);
        }
        return this.directConnections.get(dimension);
    }

    public HashMap<Connection, Integer> getTransferedRates(int dimension) {
        if (!this.transferPerTick.containsKey(dimension)) {
            this.transferPerTick.put(dimension, new HashMap());
        }
        return this.transferPerTick.get(dimension);
    }

    public void addConnection(World world, BlockPos node, BlockPos connection, int distance, WireType cableType) {
        if (!this.getMultimap(world.provider.getDimension()).containsKey(node)) {
            this.getMultimap(world.provider.getDimension()).put(node, Collections.newSetFromMap(new ConcurrentHashMap()));
        }
        this.getMultimap(world.provider.getDimension()).get(node).add(new Connection(node, connection, cableType, distance));
        if (!this.getMultimap(world.provider.getDimension()).containsKey(connection)) {
            this.getMultimap(world.provider.getDimension()).put(connection, Collections.newSetFromMap(new ConcurrentHashMap()));
        }
        this.getMultimap(world.provider.getDimension()).get(connection).add(new Connection(connection, node, cableType, distance));
        this.resetCachedIndirectConnections();
        if (world.isBlockLoaded(node)) {
            world.addBlockEvent(node, world.getBlockState(node).getBlock(), -1, 0);
        }
        if (world.isBlockLoaded(connection)) {
            world.addBlockEvent(connection, world.getBlockState(connection).getBlock(), -1, 0);
        }
        IESaveData.setDirty(world.provider.getDimension());
    }

    public void addConnection(World world, BlockPos node, Connection con) {
        if (!this.getMultimap(world.provider.getDimension()).containsKey(node)) {
            this.getMultimap(world.provider.getDimension()).put(node, Collections.newSetFromMap(new ConcurrentHashMap()));
        }
        this.getMultimap(world.provider.getDimension()).get(node).add(con);
        this.resetCachedIndirectConnections();
        IESaveData.setDirty(world.provider.getDimension());
    }

    public void addConnection(int world, BlockPos node, Connection con) {
        if (!this.getMultimap(world).containsKey(node)) {
            this.getMultimap(world).put(node, Collections.newSetFromMap(new ConcurrentHashMap()));
        }
        this.getMultimap(world).get(node).add(con);
        this.resetCachedIndirectConnections();
        IESaveData.setDirty(world);
    }

    public void removeConnection(World world, Connection con) {
        if (con == null || world == null) {
            return;
        }
        for (Set<Connection> conl : this.getMultimap(world.provider.getDimension()).values()) {
            Iterator<Connection> it = conl.iterator();
            while (it.hasNext()) {
                Connection itCon = it.next();
                if (!con.hasSameConnectors(itCon)) continue;
                it.remove();
                IImmersiveConnectable iic = ApiUtils.toIIC(itCon.end, world);
                if (iic != null) {
                    iic.removeCable(itCon);
                }
                if ((iic = ApiUtils.toIIC(itCon.start, world)) != null) {
                    iic.removeCable(itCon);
                }
                if (world.isBlockLoaded(itCon.start)) {
                    world.addBlockEvent(itCon.start, world.getBlockState(itCon.start).getBlock(), -1, 0);
                }
                if (!world.isBlockLoaded(itCon.end)) continue;
                world.addBlockEvent(itCon.end, world.getBlockState(itCon.end).getBlock(), -1, 0);
            }
        }
        this.resetCachedIndirectConnections();
        IESaveData.setDirty(world.provider.getDimension());
    }

    public Set<Integer> getRelevantDimensions() {
        return this.directConnections.keySet();
    }

    public Collection<Connection> getAllConnections(int dimensionId) {
        Set<Connection> ret = Collections.newSetFromMap(new ConcurrentHashMap());
        for (Set<Connection> conlist : this.getMultimap(dimensionId).values()) {
            ret.addAll(conlist);
        }
        return ret;
    }

    public Collection<Connection> getAllConnections(World world) {
        return this.getAllConnections(world.provider.getDimension());
    }

    public synchronized Set<Connection> getConnections(World world, BlockPos node) {
        if (world != null && world.provider != null) {
            ConcurrentHashMap<BlockPos, Set<Connection>> map = this.getMultimap(world.provider.getDimension());
            return map.get(node);
        }
        return null;
    }

    public void clearAllConnections(World world) {
        this.getMultimap(world.provider.getDimension()).clear();
    }

    public void clearAllConnections(int world) {
        this.getMultimap(world).clear();
    }

    public void clearConnectionsOriginatingFrom(BlockPos node, World world) {
        if (this.getMultimap(world.provider.getDimension()).containsKey(node)) {
            this.getMultimap(world.provider.getDimension()).get(node).clear();
        }
        this.resetCachedIndirectConnections();
    }

    public void resetCachedIndirectConnections() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.indirectConnections.clear();
        } else {
            ImmersiveEngineering.proxy.clearConnectionModelCache();
        }
    }

    public void clearAllConnectionsFor(BlockPos node, World world, boolean doDrops) {
        IImmersiveConnectable iic;
        if (this.getMultimap(world.provider.getDimension()).containsKey(node)) {
            this.getMultimap(world.provider.getDimension()).get(node).clear();
        }
        if ((iic = ApiUtils.toIIC(node, world)) != null) {
            iic.removeCable(null);
        }
        for (Set<Connection> conl : this.getMultimap(world.provider.getDimension()).values()) {
            Iterator<Connection> it = conl.iterator();
            while (it.hasNext()) {
                Connection con = it.next();
                if (!node.equals((Object)con.start) && !node.equals((Object)con.end)) continue;
                it.remove();
                IImmersiveConnectable other = node.equals((Object)con.start) ? ApiUtils.toIIC(con.end, world) : ApiUtils.toIIC(con.start, world);
                if (iic != null) {
                    iic.removeCable(con);
                }
                if (other != null) {
                    other.removeCable(con);
                }
                if (node.equals((Object)con.end)) {
                    double dx = (double)node.getX() + 0.5 + (double)Math.signum(con.start.getX() - con.end.getX());
                    double dy = (double)node.getY() + 0.5 + (double)Math.signum(con.start.getY() - con.end.getY());
                    double dz = (double)node.getZ() + 0.5 + (double)Math.signum(con.start.getZ() - con.end.getZ());
                    if (doDrops && world.getGameRules().getBoolean("doTileDrops")) {
                        world.spawnEntity((Entity)new EntityItem(world, dx, dy, dz, con.cableType.getWireCoil(con)));
                    }
                    if (!world.isBlockLoaded(con.start)) continue;
                    world.addBlockEvent(con.start, world.getBlockState(con.start).getBlock(), -1, 0);
                    continue;
                }
                if (!world.isBlockLoaded(con.end)) continue;
                world.addBlockEvent(con.end, world.getBlockState(con.end).getBlock(), -1, 0);
            }
        }
        if (world.isBlockLoaded(node)) {
            world.addBlockEvent(node, world.getBlockState(node).getBlock(), -1, 0);
        }
        IESaveData.setDirty(world.provider.getDimension());
        this.resetCachedIndirectConnections();
    }

    public void setProxy(DimensionBlockPos pos, IICProxy p) {
        if (p == null) {
            this.proxies.remove((Object)pos);
        } else {
            this.proxies.put(pos, p);
        }
    }

    public void addProxy(IICProxy p) {
        if (p == null) {
            return;
        }
        this.setProxy(new DimensionBlockPos(p.getPos(), p.getDimension()), p);
    }

    public boolean clearAllConnectionsFor(BlockPos node, World world, TargetingInfo target) {
        WireType type;
        IImmersiveConnectable iic = ApiUtils.toIIC(node, world);
        WireType wireType = type = target == null ? null : iic.getCableLimiter(target);
        if (type == null) {
            return false;
        }
        boolean ret = false;
        for (Set<Connection> conl : this.getMultimap(world.provider.getDimension()).values()) {
            Iterator<Connection> it = conl.iterator();
            while (it.hasNext()) {
                Connection con = it.next();
                if (con.cableType != type || !node.equals((Object)con.start) && !node.equals((Object)con.end)) continue;
                it.remove();
                IImmersiveConnectable other = node.equals((Object)con.start) ? ApiUtils.toIIC(con.end, world) : ApiUtils.toIIC(con.start, world);
                if (iic != null) {
                    iic.removeCable(con);
                }
                if (other != null) {
                    other.removeCable(con);
                }
                if (node.equals((Object)con.end)) {
                    double dx = (double)node.getX() + 0.5 + (double)Math.signum(con.start.getX() - con.end.getX());
                    double dy = (double)node.getY() + 0.5 + (double)Math.signum(con.start.getY() - con.end.getY());
                    double dz = (double)node.getZ() + 0.5 + (double)Math.signum(con.start.getZ() - con.end.getZ());
                    if (world.getGameRules().getBoolean("doTileDrops")) {
                        world.spawnEntity((Entity)new EntityItem(world, dx, dy, dz, con.cableType.getWireCoil(con)));
                    }
                    if (world.isBlockLoaded(con.start)) {
                        world.addBlockEvent(con.start, world.getBlockState(con.start).getBlock(), -1, 0);
                    }
                } else if (world.isBlockLoaded(con.end)) {
                    world.addBlockEvent(con.end, world.getBlockState(con.end).getBlock(), -1, 0);
                }
                ret = true;
            }
        }
        if (world.isBlockLoaded(node)) {
            world.addBlockEvent(node, world.getBlockState(node).getBlock(), -1, 0);
        }
        IESaveData.setDirty(world.provider.getDimension());
        this.resetCachedIndirectConnections();
        return ret;
    }

    public Set<AbstractConnection> getIndirectEnergyConnections(BlockPos node, World world) {
        return this.getIndirectEnergyConnections(node, world, false);
    }

    public Set<AbstractConnection> getIndirectEnergyConnections(BlockPos node, World world, boolean ignoreIsEnergyOutput) {
        if (!ignoreIsEnergyOutput && this.indirectConnections.containsKey(node)) {
            return this.indirectConnections.get(node);
        }
        ArrayList<IImmersiveConnectable> openList = new ArrayList<IImmersiveConnectable>();
        Set<AbstractConnection> closedList = Collections.newSetFromMap(new ConcurrentHashMap());
        ArrayList<BlockPos> checked = new ArrayList<BlockPos>();
        HashMap<BlockPos, BlockPos> backtracker = new HashMap<BlockPos, BlockPos>();
        checked.add(node);
        Set<Connection> conL = this.getConnections(world, node);
        if (conL != null) {
            for (Connection con : conL) {
                IImmersiveConnectable end = ApiUtils.toIIC(con.end, world);
                if (end == null) continue;
                openList.add(end);
                backtracker.put(con.end, node);
            }
        }
        IImmersiveConnectable next = null;
        int closedListMax = 1200;
        while (closedList.size() < 1200 && !openList.isEmpty()) {
            next = (IImmersiveConnectable)openList.get(0);
            if (!checked.contains(ApiUtils.toBlockPos(next))) {
                Set<Connection> conLN;
                if (ignoreIsEnergyOutput || next.isEnergyOutput()) {
                    BlockPos last = ApiUtils.toBlockPos(next);
                    WireType averageType = null;
                    int distance = 0;
                    ArrayList<Connection> connectionParts = new ArrayList<Connection>();
                    block2: while (last != null) {
                        Set<Connection> conLB;
                        BlockPos prev = last;
                        if ((last = (BlockPos)backtracker.get(last)) == null || (conLB = this.getConnections(world, last)) == null) continue;
                        for (Connection conB : conLB) {
                            if (!conB.end.equals((Object)prev)) continue;
                            connectionParts.add(0, conB);
                            distance += conB.length;
                            if (averageType != null && conB.cableType.getTransferRate() >= averageType.getTransferRate()) continue block2;
                            averageType = conB.cableType;
                            continue block2;
                        }
                    }
                    closedList.add(new AbstractConnection(ApiUtils.toBlockPos(node), ApiUtils.toBlockPos(next), averageType, distance, connectionParts.toArray(new Connection[connectionParts.size()])));
                }
                if ((conLN = this.getConnections(world, ApiUtils.toBlockPos(next))) != null) {
                    for (Connection con : conLN) {
                        IImmersiveConnectable end;
                        if (!next.allowEnergyToPass(con) || (end = ApiUtils.toIIC(con.end, world)) == null || checked.contains(con.end) || openList.contains(end)) continue;
                        openList.add(end);
                        backtracker.put(con.end, ApiUtils.toBlockPos(next));
                    }
                }
                checked.add(ApiUtils.toBlockPos(next));
            }
            openList.remove(0);
        }
        if (!ignoreIsEnergyOutput && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            if (!this.indirectConnections.containsKey(node)) {
                this.indirectConnections.put(node, Collections.newSetFromMap(new ConcurrentHashMap()));
            }
            this.indirectConnections.get(node).addAll(closedList);
        }
        return closedList;
    }

    public static class AbstractConnection
    extends Connection {
        public Connection[] subConnections;

        public AbstractConnection(BlockPos start, BlockPos end, WireType cableType, int length, Connection ... subConnections) {
            super(start, end, cableType, length);
            this.subConnections = subConnections;
        }

        public float getPreciseLossRate(int energyInput, int connectorMaxInput) {
            float f = 0.0f;
            for (Connection c : this.subConnections) {
                float length = (float)c.length / (float)c.cableType.getMaxLength();
                float baseLoss = (float)c.cableType.getLossRatio();
                float mod = (float)(connectorMaxInput - energyInput) / (float)connectorMaxInput / 0.25f * 0.1f;
                f += length * (baseLoss + baseLoss * mod);
            }
            return Math.min(f, 1.0f);
        }

        public float getAverageLossRate() {
            float f = 0.0f;
            for (Connection c : this.subConnections) {
                float length = (float)c.length / (float)c.cableType.getMaxLength();
                float baseLoss = (float)c.cableType.getLossRatio();
                f += length * baseLoss;
            }
            return Math.min(f, 1.0f);
        }
    }

    public static class Connection
    implements Comparable<Connection> {
        public BlockPos start;
        public BlockPos end;
        public WireType cableType;
        public int length;
        public Vec3d[] catenaryVertices;
        public static final int vertices = 17;

        public Connection(BlockPos start, BlockPos end, WireType cableType, int length) {
            this.start = start;
            this.end = end;
            this.cableType = cableType;
            this.length = length;
        }

        public boolean hasSameConnectors(Connection o) {
            if (!(o instanceof Connection)) {
                return false;
            }
            Connection con = o;
            boolean n0 = this.start.equals((Object)con.start) && this.end.equals((Object)con.end);
            boolean n1 = this.start.equals((Object)con.end) && this.end.equals((Object)con.start);
            return n0 || n1;
        }

        public Vec3d[] getSubVertices(World world) {
            if (this.catenaryVertices == null) {
                Vec3d vStart = new Vec3d((double)this.start.getX(), (double)this.start.getY(), (double)this.start.getZ());
                Vec3d vEnd = new Vec3d((double)this.end.getX(), (double)this.end.getY(), (double)this.end.getZ());
                IImmersiveConnectable iicStart = ApiUtils.toIIC(this.start, world);
                IImmersiveConnectable iicEnd = ApiUtils.toIIC(this.end, world);
                if (iicStart != null) {
                    vStart = ApiUtils.addVectors(vStart, iicStart.getConnectionOffset(this));
                }
                if (iicEnd != null) {
                    vEnd = ApiUtils.addVectors(vEnd, iicEnd.getConnectionOffset(this));
                }
                this.catenaryVertices = ApiUtils.getConnectionCatenary(this, vStart, vEnd);
            }
            return this.catenaryVertices;
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            if (this.start != null) {
                tag.setIntArray("start", new int[]{this.start.getX(), this.start.getY(), this.start.getZ()});
            }
            if (this.end != null) {
                tag.setIntArray("end", new int[]{this.end.getX(), this.end.getY(), this.end.getZ()});
            }
            tag.setString("cableType", this.cableType.getUniqueName());
            tag.setInteger("length", this.length);
            return tag;
        }

        public static Connection readFromNBT(NBTTagCompound tag) {
            if (tag == null) {
                return null;
            }
            int[] iStart = tag.getIntArray("start");
            BlockPos start = new BlockPos(iStart[0], iStart[1], iStart[2]);
            int[] iEnd = tag.getIntArray("end");
            BlockPos end = new BlockPos(iEnd[0], iEnd[1], iEnd[2]);
            WireType type = ApiUtils.getWireTypeFromNBT(tag, "cableType");
            if (start != null && end != null && type != null) {
                return new Connection(start, end, type, tag.getInteger("length"));
            }
            return null;
        }

        @Override
        public int compareTo(Connection o) {
            if (this == o) {
                return 0;
            }
            int distComp = Integer.compare(this.length, o.length);
            int cableComp = -1 * Integer.compare(this.cableType.getTransferRate(), o.cableType.getTransferRate());
            if (cableComp != 0) {
                return cableComp;
            }
            if (distComp != 0) {
                return distComp;
            }
            if (this.start.getX() != o.start.getX()) {
                return this.start.getX() > o.start.getX() ? 1 : -1;
            }
            if (this.start.getY() != o.start.getY()) {
                return this.start.getY() > o.start.getY() ? 1 : -1;
            }
            if (this.start.getZ() != o.start.getZ()) {
                return this.start.getZ() > o.start.getZ() ? 1 : -1;
            }
            if (this.end.getX() != o.end.getX()) {
                return this.end.getX() > o.end.getX() ? 1 : -1;
            }
            if (this.end.getY() != o.end.getY()) {
                return this.end.getY() > o.end.getY() ? 1 : -1;
            }
            if (this.end.getZ() != o.end.getZ()) {
                return this.end.getZ() > o.end.getZ() ? 1 : -1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Connection)) {
                return false;
            }
            return this.compareTo((Connection)obj) == 0;
        }
    }
}

