/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class RefineryRecipe
extends MultiblockRecipe {
    public static float energyModifier = 1.0f;
    public static float timeModifier = 1.0f;
    public final FluidStack output;
    public final FluidStack input0;
    public final FluidStack input1;
    public static ArrayList<RefineryRecipe> recipeList = new ArrayList();

    public RefineryRecipe(FluidStack output, FluidStack input0, FluidStack input1, int energy) {
        this.output = output;
        this.input0 = input0;
        this.input1 = input1;
        this.totalProcessEnergy = (int)Math.floor((float)energy * energyModifier);
        this.totalProcessTime = (int)Math.floor(1.0f * timeModifier);
        this.fluidInputList = Lists.newArrayList((Object[])new FluidStack[]{this.input0, this.input1});
        this.fluidOutputList = Lists.newArrayList((Object[])new FluidStack[]{this.output});
    }

    public static RefineryRecipe addRecipe(FluidStack output, FluidStack input0, FluidStack input1, int energy) {
        RefineryRecipe r = new RefineryRecipe(output, input0, input1, energy);
        recipeList.add(r);
        return r;
    }

    public static RefineryRecipe findRecipe(FluidStack input0, FluidStack input1) {
        for (RefineryRecipe recipe : recipeList) {
            if (input0 != null) {
                if (recipe.input0 != null && input0.containsFluid(recipe.input0) && (recipe.input1 == null && input1 == null || recipe.input1 != null && input1 != null && input1.containsFluid(recipe.input1))) {
                    return recipe;
                }
                if (recipe.input1 == null || !input0.containsFluid(recipe.input1) || (recipe.input0 != null || input1 != null) && (recipe.input0 == null || input1 == null || !input1.containsFluid(recipe.input0))) continue;
                return recipe;
            }
            if (input1 == null) continue;
            if (recipe.input0 != null && input1.containsFluid(recipe.input0) && recipe.input1 == null) {
                return recipe;
            }
            if (recipe.input1 == null || !input1.containsFluid(recipe.input1) || recipe.input0 != null) continue;
            return recipe;
        }
        return null;
    }

    public static List<RefineryRecipe> findIncompleteRefineryRecipe(FluidStack input0, FluidStack input1) {
        if (input0 == null && input1 == null) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        for (RefineryRecipe recipe : recipeList) {
            if (input0 != null && input1 == null) {
                if (!input0.isFluidEqual(recipe.input0) && !input0.isFluidEqual(recipe.input1)) continue;
                list.add(recipe);
                break;
            }
            if (input0 == null && input1 != null) {
                if (!input1.isFluidEqual(recipe.input0) && !input1.isFluidEqual(recipe.input1)) continue;
                list.add(recipe);
                break;
            }
            if ((!input0.isFluidEqual(recipe.input0) || !input1.isFluidEqual(recipe.input1)) && (!input0.isFluidEqual(recipe.input1) || !input1.isFluidEqual(recipe.input0))) continue;
            list.add(recipe);
            break;
        }
        return list;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.setTag("input0", (NBTBase)this.input0.writeToNBT(new NBTTagCompound()));
        nbt.setTag("input1", (NBTBase)this.input1.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public static RefineryRecipe loadFromNBT(NBTTagCompound nbt) {
        FluidStack input0 = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.getCompoundTag("input0"));
        FluidStack input1 = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.getCompoundTag("input1"));
        return RefineryRecipe.findRecipe(input0, input1);
    }
}

