/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IJEIRecipe;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public abstract class MultiblockRecipe
implements IMultiblockRecipe,
IJEIRecipe {
    protected List<IngredientStack> inputList;
    protected NonNullList<ItemStack> outputList;
    protected List<FluidStack> fluidInputList;
    protected List<FluidStack> fluidOutputList;
    int totalProcessTime;
    int totalProcessEnergy;
    public List<ItemStack>[] jeiItemInputList;
    protected List<ItemStack> jeiTotalItemInputList;
    public List<ItemStack>[] jeiItemOutputList;
    protected List<ItemStack> jeiTotalItemOutputList;
    protected List<FluidStack> jeiFluidInputList;
    protected List<FluidStack> jeiFluidOutputList;

    @Override
    public List<IngredientStack> getItemInputs() {
        return this.inputList;
    }

    @Override
    public NonNullList<ItemStack> getItemOutputs() {
        return this.outputList;
    }

    @Override
    public List<FluidStack> getFluidInputs() {
        return this.fluidInputList;
    }

    @Override
    public List<FluidStack> getFluidOutputs() {
        return this.fluidOutputList;
    }

    @Override
    public int getTotalProcessTime() {
        return this.totalProcessTime;
    }

    @Override
    public int getTotalProcessEnergy() {
        return this.totalProcessEnergy;
    }

    public void setupJEI() {
        FluidStack fs;
        ArrayList list;
        int i;
        if (this.inputList != null) {
            this.jeiItemInputList = new ArrayList[this.inputList.size()];
            this.jeiTotalItemInputList = new ArrayList<ItemStack>();
            for (i = 0; i < this.inputList.size(); ++i) {
                IngredientStack ingr = this.inputList.get(i);
                list = new ArrayList();
                if (ingr.oreName != null) {
                    for (ItemStack stack : OreDictionary.getOres((String)ingr.oreName)) {
                        list.add(ApiUtils.copyStackWithAmount(stack, ingr.inputSize));
                    }
                } else if (ingr.stackList != null) {
                    for (ItemStack stack : ingr.stackList) {
                        list.add(ApiUtils.copyStackWithAmount(stack, ingr.inputSize));
                    }
                } else {
                    list.add(ApiUtils.copyStackWithAmount(ingr.stack, ingr.inputSize));
                }
                this.jeiItemInputList[i] = list;
                this.jeiTotalItemInputList.addAll(list);
            }
        } else {
            this.jeiTotalItemInputList = Collections.emptyList();
        }
        if (this.outputList != null) {
            this.jeiItemOutputList = new ArrayList[this.outputList.size()];
            this.jeiTotalItemOutputList = new ArrayList<ItemStack>();
            for (i = 0; i < this.outputList.size(); ++i) {
                ItemStack s = (ItemStack)this.outputList.get(i);
                this.jeiItemOutputList[i] = list = Lists.newArrayList((Object[])new ItemStack[]{!s.isEmpty() ? s.copy() : ItemStack.EMPTY});
                this.jeiTotalItemOutputList.addAll(list);
            }
        } else {
            this.jeiTotalItemOutputList = Collections.emptyList();
        }
        if (this.fluidInputList != null) {
            this.jeiFluidInputList = new ArrayList<FluidStack>();
            for (i = 0; i < this.fluidInputList.size(); ++i) {
                fs = this.fluidInputList.get(i);
                if (fs == null) continue;
                this.jeiFluidInputList.add(fs.copy());
            }
        } else {
            this.jeiFluidInputList = Collections.emptyList();
        }
        if (this.fluidOutputList != null) {
            this.jeiFluidOutputList = new ArrayList<FluidStack>();
            for (i = 0; i < this.fluidOutputList.size(); ++i) {
                fs = this.fluidOutputList.get(i);
                if (fs == null) continue;
                this.jeiFluidOutputList.add(fs.copy());
            }
        } else {
            this.jeiFluidOutputList = Collections.emptyList();
        }
    }

    @Override
    public List<ItemStack> getJEITotalItemInputs() {
        return this.jeiTotalItemInputList;
    }

    @Override
    public List<ItemStack> getJEITotalItemOutputs() {
        return this.jeiTotalItemOutputList;
    }

    @Override
    public List<FluidStack> getJEITotalFluidInputs() {
        return this.jeiFluidInputList;
    }

    @Override
    public List<FluidStack> getJEITotalFluidOutputs() {
        return this.jeiFluidOutputList;
    }
}

