/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.common.crafting.IngredientFluidStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;

public class IngredientStack {
    public ItemStack stack = ItemStack.EMPTY;
    public List<ItemStack> stackList;
    public String oreName;
    public FluidStack fluid;
    public int inputSize = 1;
    public boolean useNBT;

    public IngredientStack(ItemStack stack) {
        this.stack = stack;
        this.inputSize = stack.getCount();
    }

    public IngredientStack(String oreName, int inputSize) {
        this.oreName = oreName;
        this.inputSize = inputSize;
    }

    public IngredientStack(String oreName) {
        this(oreName, 1);
    }

    public IngredientStack(List<ItemStack> stackList, int inputSize) {
        this.stackList = stackList;
        this.inputSize = inputSize;
    }

    public IngredientStack(List<ItemStack> stackList) {
        this(stackList, 1);
    }

    public IngredientStack(FluidStack fluid) {
        this.fluid = fluid;
    }

    public IngredientStack(IngredientStack ingr) {
        this.stack = ingr.stack;
        this.stackList = ingr.stackList;
        this.oreName = ingr.oreName;
        this.fluid = ingr.fluid;
        this.inputSize = ingr.inputSize;
        this.useNBT = ingr.useNBT;
    }

    public IngredientStack setUseNBT(boolean useNBT) {
        this.useNBT = useNBT;
        return this;
    }

    public boolean matches(Object input) {
        if (input == null) {
            return false;
        }
        if (input instanceof IngredientStack) {
            return this.equals(input) && this.inputSize <= ((IngredientStack)input).inputSize;
        }
        if (input instanceof ItemStack) {
            return this.matchesItemStack((ItemStack)input);
        }
        if (input instanceof ItemStack[]) {
            for (ItemStack iStack : (ItemStack[])input) {
                if (!this.matchesItemStack(iStack)) continue;
                return true;
            }
        } else if (input instanceof List) {
            for (Object io : (List)input) {
                if (!this.matches(io)) continue;
                return true;
            }
        } else if (input instanceof String) {
            if (this.oreName != null) {
                return this.oreName.equals(input);
            }
            return ApiUtils.compareToOreName(this.stack, (String)input);
        }
        return false;
    }

    public IngredientStack copyWithSize(int size) {
        IngredientStack is = new IngredientStack(this);
        is.inputSize = size;
        return is;
    }

    public IngredientStack copyWithMultipliedSize(double multiplier) {
        return this.copyWithSize((int)Math.floor((double)this.inputSize * multiplier));
    }

    public List<ItemStack> getStackList() {
        if (this.stackList != null) {
            return this.stackList;
        }
        if (this.oreName != null) {
            return OreDictionary.getOres((String)this.oreName);
        }
        if (this.fluid != null && ForgeModContainer.getInstance().universalBucket != null) {
            return Collections.singletonList(UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)this.fluid.getFluid()));
        }
        return Collections.singletonList(this.stack);
    }

    public List<ItemStack> getSizedStackList() {
        List<Object> list;
        if (this.oreName != null) {
            list = new ArrayList();
            for (ItemStack stack : OreDictionary.getOres((String)this.oreName)) {
                list.add(ApiUtils.copyStackWithAmount(stack, this.inputSize));
            }
        } else {
            list = this.fluid != null && ForgeModContainer.getInstance().universalBucket != null ? Collections.singletonList(UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)this.fluid.getFluid())) : (this.stackList != null ? this.stackList : Collections.singletonList(ApiUtils.copyStackWithAmount(this.stack, this.inputSize)));
        }
        return list;
    }

    public ItemStack getRandomizedExampleStack(long rand) {
        NonNullList ores;
        ItemStack ret = this.stack;
        if (ret.isEmpty() && this.stackList != null && this.stackList.size() > 0) {
            ret = this.stackList.get((int)(rand / 20L) % this.stackList.size());
        }
        if (ret.isEmpty() && this.oreName != null && (ores = OreDictionary.getOres((String)this.oreName)) != null && ores.size() > 0) {
            ret = (ItemStack)ores.get((int)(rand / 20L) % ores.size());
        }
        if (ret.isEmpty() && this.fluid != null && ForgeModContainer.getInstance().universalBucket != null) {
            ret = UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)this.fluid.getFluid());
        }
        return ret;
    }

    public ItemStack getExampleStack() {
        NonNullList ores;
        ItemStack ret = this.stack;
        if (ret.isEmpty() && this.stackList != null && this.stackList.size() > 0) {
            ret = this.stackList.get(0);
        }
        if (ret.isEmpty() && this.oreName != null && (ores = OreDictionary.getOres((String)this.oreName)) != null && ores.size() > 0) {
            ret = (ItemStack)ores.get(0);
        }
        if (ret.isEmpty() && this.fluid != null && ForgeModContainer.getInstance().universalBucket != null) {
            ret = UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)this.fluid.getFluid());
        }
        return ret;
    }

    public Ingredient toRecipeIngredient() {
        Ingredient ret;
        Ingredient ingredient = ret = this.stack != null ? Ingredient.fromStacks((ItemStack[])new ItemStack[]{this.stack}) : null;
        if (ret == null && this.stackList != null && this.stackList.size() > 0) {
            ret = ApiUtils.createIngredientFromList(this.stackList);
        }
        if (ret == null && this.oreName != null) {
            ret = new OreIngredient(this.oreName);
        }
        if (ret == null && this.fluid != null && ForgeModContainer.getInstance().universalBucket != null) {
            ret = new IngredientFluidStack(this.fluid);
        }
        return ret;
    }

    public boolean matchesItemStack(ItemStack input) {
        FluidStack fs;
        if (input.isEmpty()) {
            return false;
        }
        if (this.fluid != null && (fs = FluidUtil.getFluidContained((ItemStack)input)) != null && fs.containsFluid(this.fluid)) {
            return true;
        }
        if (this.oreName != null) {
            return ApiUtils.compareToOreName(input, this.oreName) && this.inputSize <= input.getCount();
        }
        if (this.stackList != null) {
            for (ItemStack iStack : this.stackList) {
                if (!OreDictionary.itemMatches((ItemStack)iStack, (ItemStack)input, (boolean)false) || this.inputSize > input.getCount()) continue;
                return true;
            }
        }
        if (!OreDictionary.itemMatches((ItemStack)this.stack, (ItemStack)input, (boolean)false) || this.inputSize > input.getCount()) {
            return false;
        }
        if (this.useNBT) {
            if (this.stack.hasTagCompound() != input.hasTagCompound()) {
                return false;
            }
            if (!this.stack.hasTagCompound() && !input.hasTagCompound()) {
                return true;
            }
            if (!this.stack.getTagCompound().equals((Object)input.getTagCompound())) {
                return false;
            }
        }
        return true;
    }

    public boolean matchesItemStackIgnoringSize(ItemStack input) {
        FluidStack fs;
        if (input.isEmpty()) {
            return false;
        }
        if (this.fluid != null && (fs = FluidUtil.getFluidContained((ItemStack)input)) != null && fs.containsFluid(this.fluid)) {
            return true;
        }
        if (this.oreName != null) {
            return ApiUtils.compareToOreName(input, this.oreName);
        }
        if (this.stackList != null) {
            for (ItemStack iStack : this.stackList) {
                if (!OreDictionary.itemMatches((ItemStack)iStack, (ItemStack)input, (boolean)false)) continue;
                return true;
            }
        }
        if (!OreDictionary.itemMatches((ItemStack)this.stack, (ItemStack)input, (boolean)false)) {
            return false;
        }
        if (this.useNBT) {
            if (this.stack.hasTagCompound() != input.hasTagCompound()) {
                return false;
            }
            if (!this.stack.hasTagCompound() && !input.hasTagCompound()) {
                return true;
            }
            if (!this.stack.getTagCompound().equals((Object)input.getTagCompound())) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IngredientStack)) {
            return false;
        }
        if (this.fluid != null && ((IngredientStack)object).fluid != null) {
            return this.fluid.equals((Object)((IngredientStack)object).fluid);
        }
        if (this.oreName != null && ((IngredientStack)object).oreName != null) {
            return this.oreName.equals(((IngredientStack)object).oreName);
        }
        if (this.stackList != null && ((IngredientStack)object).stackList != null) {
            for (ItemStack iStack : this.stackList) {
                for (ItemStack iStack2 : ((IngredientStack)object).stackList) {
                    if (!OreDictionary.itemMatches((ItemStack)iStack, (ItemStack)iStack2, (boolean)false)) continue;
                    return true;
                }
            }
            return false;
        }
        if (!this.stack.isEmpty() && !((IngredientStack)object).stack.isEmpty()) {
            ItemStack otherStack = ((IngredientStack)object).stack;
            if (!OreDictionary.itemMatches((ItemStack)this.stack, (ItemStack)otherStack, (boolean)false)) {
                return false;
            }
            if (this.useNBT) {
                if (this.stack.hasTagCompound() != otherStack.hasTagCompound()) {
                    return false;
                }
                if (!this.stack.hasTagCompound() && !otherStack.hasTagCompound()) {
                    return true;
                }
                if (!this.stack.getTagCompound().equals((Object)otherStack.getTagCompound())) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.fluid != null) {
            nbt.setString("fluid", FluidRegistry.getFluidName((FluidStack)this.fluid));
            nbt.setInteger("fluidAmount", this.fluid.amount);
            nbt.setInteger("nbtType", 3);
        } else if (this.oreName != null) {
            nbt.setString("oreName", this.oreName);
            nbt.setInteger("nbtType", 2);
        } else if (this.stackList != null) {
            NBTTagList list = new NBTTagList();
            for (ItemStack stack : this.stackList) {
                if (stack.isEmpty()) continue;
                list.appendTag((NBTBase)stack.writeToNBT(new NBTTagCompound()));
            }
            nbt.setTag("stackList", (NBTBase)list);
            nbt.setInteger("nbtType", 1);
        } else {
            nbt.setTag("stack", (NBTBase)this.stack.writeToNBT(new NBTTagCompound()));
            nbt.setInteger("nbtType", 0);
            nbt.setBoolean("useNBT", this.useNBT);
        }
        nbt.setInteger("inputSize", this.inputSize);
        return nbt;
    }

    public static IngredientStack readFromNBT(NBTTagCompound nbt) {
        if (nbt.hasKey("nbtType")) {
            switch (nbt.getInteger("nbtType")) {
                case 0: {
                    ItemStack stack = new ItemStack(nbt.getCompoundTag("stack"));
                    stack.setCount(nbt.getInteger("inputSize"));
                    IngredientStack ingr = new IngredientStack(stack);
                    ingr.useNBT = nbt.getBoolean("useNBT");
                    return ingr;
                }
                case 1: {
                    NBTTagList list = nbt.getTagList("stackList", 10);
                    ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
                    for (int i = 0; i < list.tagCount(); ++i) {
                        stackList.add(new ItemStack(list.getCompoundTagAt(i)));
                    }
                    return new IngredientStack(stackList, nbt.getInteger("inputSize"));
                }
                case 2: {
                    return new IngredientStack(nbt.getString("oreName"), nbt.getInteger("inputSize"));
                }
                case 3: {
                    FluidStack fs = new FluidStack(FluidRegistry.getFluid((String)nbt.getString("fluid")), nbt.getInteger("fluidAmount"));
                    return new IngredientStack(fs);
                }
            }
        }
        return null;
    }
}

