/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MultiblockHandler {
    static ArrayList<IMultiblock> multiblocks = new ArrayList();

    public static void registerMultiblock(IMultiblock multiblock) {
        multiblocks.add(multiblock);
    }

    public static ArrayList<IMultiblock> getMultiblocks() {
        return multiblocks;
    }

    public static MultiblockFormEvent postMultiblockFormationEvent(EntityPlayer player, IMultiblock multiblock, BlockPos clickedBlock, ItemStack hammer) {
        MultiblockFormEvent event = new MultiblockFormEvent(player, multiblock, clickedBlock, hammer);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    @Cancelable
    public static class MultiblockFormEvent
    extends PlayerEvent {
        private final IMultiblock multiblock;
        private final BlockPos clickedBlock;
        private final ItemStack hammer;

        public MultiblockFormEvent(EntityPlayer player, IMultiblock multiblock, BlockPos clickedBlock, ItemStack hammer) {
            super(player);
            this.multiblock = multiblock;
            this.clickedBlock = clickedBlock;
            this.hammer = hammer;
        }

        public IMultiblock getMultiblock() {
            return this.multiblock;
        }

        public BlockPos getClickedBlock() {
            return this.clickedBlock;
        }

        public ItemStack getHammer() {
            return this.hammer;
        }
    }

    public static interface IMultiblock {
        public String getUniqueName();

        public boolean isBlockTrigger(IBlockState var1);

        public boolean createStructure(World var1, BlockPos var2, EnumFacing var3, EntityPlayer var4);

        public ItemStack[][][] getStructureManual();

        default public IBlockState getBlockstateFromStack(int index, ItemStack stack) {
            if (!stack.isEmpty() && stack.getItem() instanceof ItemBlock) {
                return ((ItemBlock)stack.getItem()).getBlock().getStateFromMeta(stack.getItemDamage());
            }
            return null;
        }

        public IngredientStack[] getTotalMaterials();

        @SideOnly(value=Side.CLIENT)
        public boolean overwriteBlockRender(ItemStack var1, int var2);

        public float getManualScale();

        @SideOnly(value=Side.CLIENT)
        public boolean canRenderFormedStructure();

        @SideOnly(value=Side.CLIENT)
        public void renderFormedStructure();
    }
}

