/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualPages;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.gui.GuiButtonManualNavigation;
import blusunrize.lib.manual.gui.GuiManual;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;

public class ManualPageMultiblock
extends ManualPages {
    MultiblockHandler.IMultiblock multiblock;
    boolean canTick = true;
    boolean showCompleted = false;
    int tick = 0;
    float scale = 50.0f;
    float transX = 0.0f;
    float transY = 0.0f;
    float rotX = 0.0f;
    float rotY = 0.0f;
    List<String> componentTooltip;
    MultiblockRenderInfo renderInfo;
    MultiblockBlockAccess blockAccess;

    public ManualPageMultiblock(ManualInstance manual, String text, MultiblockHandler.IMultiblock multiblock) {
        super(manual, text);
        this.multiblock = multiblock;
        if (multiblock.getStructureManual() != null) {
            // empty if block
        }
    }

    @Override
    public void initPage(GuiManual gui, int x, int y, List<GuiButton> pageButtons) {
        IngredientStack[] totalMaterials;
        int yOff = 0;
        if (this.multiblock.getStructureManual() != null) {
            this.renderInfo = new MultiblockRenderInfo(this.multiblock);
            this.blockAccess = new MultiblockBlockAccess(this.renderInfo);
            this.transX = x + 60 + this.renderInfo.structureWidth / 2;
            this.transY = (float)(y + 35) + (float)Math.sqrt(this.renderInfo.structureHeight * this.renderInfo.structureHeight + this.renderInfo.structureWidth * this.renderInfo.structureWidth + this.renderInfo.structureLength * this.renderInfo.structureLength) / 2.0f;
            this.rotX = 25.0f;
            this.rotY = -45.0f;
            this.scale = this.multiblock.getManualScale();
            boolean canRenderFormed = this.multiblock.canRenderFormedStructure();
            yOff = (int)((double)this.transY + (double)this.scale * Math.sqrt(this.renderInfo.structureHeight * this.renderInfo.structureHeight + this.renderInfo.structureWidth * this.renderInfo.structureWidth + this.renderInfo.structureLength * this.renderInfo.structureLength) / 2.0);
            pageButtons.add(new GuiButtonManualNavigation(gui, 100, x + 4, (int)this.transY - (canRenderFormed ? 11 : 5), 10, 10, 4));
            if (canRenderFormed) {
                pageButtons.add(new GuiButtonManualNavigation(gui, 103, x + 4, (int)this.transY + 1, 10, 10, 6));
            }
            if (this.renderInfo.structureHeight > 1) {
                pageButtons.add(new GuiButtonManualNavigation(gui, 101, x + 4, (int)this.transY - (canRenderFormed ? 14 : 8) - 16, 10, 16, 3));
                pageButtons.add(new GuiButtonManualNavigation(gui, 102, x + 4, (int)this.transY + (canRenderFormed ? 14 : 8), 10, 16, 2));
            }
        }
        if ((totalMaterials = this.multiblock.getTotalMaterials()) != null) {
            IngredientStack req;
            int ss;
            this.componentTooltip = new ArrayList<String>();
            this.componentTooltip.add(I18n.format((String)"desc.immersiveengineering.info.reqMaterial", (Object[])new Object[0]));
            int maxOff = 1;
            boolean hasAnyItems = false;
            boolean[] hasItems = new boolean[totalMaterials.length];
            for (ss = 0; ss < totalMaterials.length; ++ss) {
                ItemStack inSlot;
                if (totalMaterials[ss] == null) continue;
                req = totalMaterials[ss];
                int reqSize = req.inputSize;
                for (int slot = 0; slot < ManualUtils.mc().player.inventory.getSizeInventory() && ((inSlot = ManualUtils.mc().player.inventory.getStackInSlot(slot)).isEmpty() || !req.matchesItemStackIgnoringSize(inSlot) || (reqSize -= inSlot.getCount()) > 0); ++slot) {
                }
                if (reqSize <= 0) {
                    hasItems[ss] = true;
                    if (!hasAnyItems) {
                        hasAnyItems = true;
                    }
                }
                maxOff = Math.max(maxOff, ("" + req.inputSize).length());
            }
            for (ss = 0; ss < totalMaterials.length; ++ss) {
                if (totalMaterials[ss] == null) continue;
                req = totalMaterials[ss];
                int indent = maxOff - ("" + req.inputSize).length();
                String sIndent = "";
                if (indent > 0) {
                    for (int ii = 0; ii < indent; ++ii) {
                        sIndent = sIndent + "0";
                    }
                }
                String s = hasItems[ss] ? TextFormatting.GREEN + TextFormatting.BOLD.toString() + "\u2713" + TextFormatting.RESET + " " : (hasAnyItems ? "   " : "");
                s = s + TextFormatting.GRAY + sIndent + req.inputSize + "x " + TextFormatting.RESET;
                ItemStack example = req.getExampleStack();
                s = !example.isEmpty() ? s + example.getRarity().rarityColor + example.getDisplayName() : s + "???";
                this.componentTooltip.add(s);
            }
        }
        super.initPage(gui, x, yOff, pageButtons);
    }

    @Override
    public void renderPage(GuiManual gui, int x, int y, int mx, int my) {
        boolean openBuffer = false;
        try {
            if (this.multiblock.getStructureManual() != null) {
                if (this.canTick && ++this.tick % 20 == 0) {
                    this.renderInfo.step();
                }
                int structureLength = this.renderInfo.structureLength;
                int structureWidth = this.renderInfo.structureWidth;
                int structureHeight = this.renderInfo.structureHeight;
                int yOffTotal = (int)((double)(this.transY - (float)y) + (double)this.scale * Math.sqrt(this.renderInfo.structureHeight * this.renderInfo.structureHeight + this.renderInfo.structureWidth * this.renderInfo.structureWidth + this.renderInfo.structureLength * this.renderInfo.structureLength) / 2.0);
                GlStateManager.enableRescaleNormal();
                GlStateManager.pushMatrix();
                RenderHelper.disableStandardItemLighting();
                boolean i = false;
                ItemStack highlighted = ItemStack.EMPTY;
                BlockRendererDispatcher blockRender = Minecraft.getMinecraft().getBlockRendererDispatcher();
                float f = (float)Math.sqrt(structureHeight * structureHeight + structureWidth * structureWidth + structureLength * structureLength);
                GlStateManager.translate((float)this.transX, (float)this.transY, (float)Math.max(structureHeight, Math.max(structureWidth, structureLength)));
                GlStateManager.scale((float)this.scale, (float)(-this.scale), (float)1.0f);
                GlStateManager.rotate((float)this.rotX, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.rotate((float)(90.0f + this.rotY), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.translate((float)((float)structureLength / -2.0f), (float)((float)structureHeight / -2.0f), (float)((float)structureWidth / -2.0f));
                GlStateManager.disableLighting();
                if (Minecraft.isAmbientOcclusionEnabled()) {
                    GlStateManager.shadeModel((int)7425);
                } else {
                    GlStateManager.shadeModel((int)7424);
                }
                gui.mc.getTextureManager().bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
                int idx = 0;
                if (this.showCompleted && this.multiblock.canRenderFormedStructure()) {
                    this.multiblock.renderFormedStructure();
                } else {
                    for (int h = 0; h < structureHeight; ++h) {
                        for (int l = 0; l < structureLength; ++l) {
                            for (int w = 0; w < structureWidth; ++w) {
                                BlockPos pos = new BlockPos(l, h, w);
                                if (this.blockAccess.isAirBlock(pos)) continue;
                                GlStateManager.translate((float)l, (float)h, (float)w);
                                boolean b = this.multiblock.overwriteBlockRender(this.renderInfo.data[h][l][w], idx++);
                                GlStateManager.translate((float)(-l), (float)(-h), (float)(-w));
                                if (b) continue;
                                IBlockState state = this.blockAccess.getBlockState(pos);
                                Tessellator tessellator = Tessellator.getInstance();
                                BufferBuilder buffer = tessellator.getBuffer();
                                buffer.begin(7, DefaultVertexFormats.BLOCK);
                                openBuffer = true;
                                blockRender.renderBlock(state, pos, (IBlockAccess)this.blockAccess, buffer);
                                tessellator.draw();
                                openBuffer = false;
                            }
                        }
                    }
                }
                GlStateManager.popMatrix();
                RenderHelper.disableStandardItemLighting();
                GlStateManager.disableRescaleNormal();
                GlStateManager.enableBlend();
                RenderHelper.disableStandardItemLighting();
                this.manual.fontRenderer.setUnicodeFlag(true);
                if (this.localizedText != null && !this.localizedText.isEmpty()) {
                    this.manual.fontRenderer.drawSplitString(this.localizedText, x, y + yOffTotal, 120, this.manual.getTextColour());
                }
                this.manual.fontRenderer.setUnicodeFlag(false);
                if (this.componentTooltip != null) {
                    this.manual.fontRenderer.drawString("?", (float)(x + 116), (float)(y + yOffTotal / 2 - 4), this.manual.getTextColour(), false);
                    if (mx >= x + 116 && mx < x + 122 && my >= y + yOffTotal / 2 - 4 && my < y + yOffTotal / 2 + 4) {
                        gui.drawHoveringText(this.componentTooltip, mx, my, this.manual.fontRenderer);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (openBuffer) {
            try {
                Tessellator.getInstance().draw();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void mouseDragged(int x, int y, int clickX, int clickY, int mx, int my, int lastX, int lastY, int button) {
        if (clickX >= 40 && clickX < 144 && mx >= 20 && mx < 164 && clickY >= 30 && clickY < 130 && my >= 30 && my < 180) {
            int dx = mx - lastX;
            int dy = my - lastY;
            this.rotY += (float)dx / 104.0f * 80.0f;
            this.rotX += (float)dy / 100.0f * 80.0f;
        }
    }

    @Override
    public void buttonPressed(GuiManual gui, GuiButton button) {
        if (button.id == 100) {
            this.canTick = !this.canTick;
            ((GuiButtonManualNavigation)button).type = ((GuiButtonManualNavigation)button).type == 4 ? 5 : 4;
        } else if (button.id == 101) {
            this.renderInfo.setShowLayer(Math.min(this.renderInfo.showLayer + 1, this.renderInfo.structureHeight - 1));
        } else if (button.id == 102) {
            this.renderInfo.setShowLayer(Math.max(this.renderInfo.showLayer - 1, -1));
        } else if (button.id == 103) {
            this.showCompleted = !this.showCompleted;
        }
        super.buttonPressed(gui, button);
    }

    @Override
    public boolean listForSearch(String searchTag) {
        return false;
    }

    static class MultiblockRenderInfo {
        public MultiblockHandler.IMultiblock multiblock;
        public ItemStack[][][] data;
        public int blockCount = 0;
        public int[] countPerLevel;
        public int structureHeight = 0;
        public int structureLength = 0;
        public int structureWidth = 0;
        public int showLayer = -1;
        private int blockIndex = -1;
        private int maxBlockIndex;

        public MultiblockRenderInfo(MultiblockHandler.IMultiblock multiblock) {
            this.multiblock = multiblock;
            this.init(multiblock.getStructureManual());
            this.maxBlockIndex = this.blockIndex = this.structureHeight * this.structureLength * this.structureWidth;
        }

        public void init(ItemStack[][][] structure) {
            this.data = structure;
            this.structureHeight = structure.length;
            this.structureWidth = 0;
            this.structureLength = 0;
            this.countPerLevel = new int[this.structureHeight];
            this.blockCount = 0;
            for (int h = 0; h < structure.length; ++h) {
                if (structure[h].length > this.structureLength) {
                    this.structureLength = structure[h].length;
                }
                int perLvl = 0;
                for (int l = 0; l < structure[h].length; ++l) {
                    if (structure[h][l].length > this.structureWidth) {
                        this.structureWidth = structure[h][l].length;
                    }
                    for (ItemStack ss : structure[h][l]) {
                        if (ss == null || ss.isEmpty()) continue;
                        ++perLvl;
                    }
                }
                this.countPerLevel[h] = perLvl;
                this.blockCount += perLvl;
            }
        }

        public void setShowLayer(int layer) {
            this.showLayer = layer;
            if (layer < 0) {
                this.reset();
            } else {
                this.blockIndex = (layer + 1) * (this.structureLength * this.structureWidth) - 1;
            }
        }

        public void reset() {
            this.blockIndex = this.maxBlockIndex;
        }

        public void step() {
            int start = this.blockIndex;
            do {
                if (++this.blockIndex < this.maxBlockIndex) continue;
                this.blockIndex = 0;
            } while (this.isEmpty(this.blockIndex) && this.blockIndex != start);
        }

        private boolean isEmpty(int index) {
            int y = index / (this.structureLength * this.structureWidth);
            int r = index % (this.structureLength * this.structureWidth);
            int x = r / this.structureWidth;
            int z = r % this.structureWidth;
            ItemStack stack = this.data[y][x][z];
            return stack == null || stack.isEmpty();
        }

        public int getLimiter() {
            return this.blockIndex;
        }
    }

    static class MultiblockBlockAccess
    implements IBlockAccess {
        private final MultiblockRenderInfo data;
        private final IBlockState[][][] structure;

        public MultiblockBlockAccess(MultiblockRenderInfo data) {
            this.data = data;
            int[] index = new int[]{0};
            this.structure = (IBlockState[][][])Arrays.stream(data.data).map(layer -> (IBlockState[][])Arrays.stream(layer).map(row -> Arrays.stream(row).map(itemstack -> {
                int n = index[0];
                index[0] = n + 1;
                return this.convert(n, (ItemStack)itemstack);
            }).collect(Collectors.toList()).toArray(new IBlockState[0])).collect(Collectors.toList()).toArray((T[])new IBlockState[0][])).collect(Collectors.toList()).toArray((T[])new IBlockState[0][][]);
        }

        private IBlockState convert(int index, ItemStack itemstack) {
            if (itemstack == null) {
                return Blocks.AIR.getDefaultState();
            }
            IBlockState state = this.data.multiblock.getBlockstateFromStack(index, itemstack);
            if (state != null) {
                return state;
            }
            return Blocks.AIR.getDefaultState();
        }

        @Nullable
        public TileEntity getTileEntity(BlockPos pos) {
            return null;
        }

        public int getCombinedLight(BlockPos pos, int lightValue) {
            return 0xF000F0;
        }

        public IBlockState getBlockState(BlockPos pos) {
            int index;
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            if (y >= 0 && y < this.structure.length && x >= 0 && x < this.structure[y].length && z >= 0 && z < this.structure[y][x].length && (index = y * (this.data.structureLength * this.data.structureWidth) + x * this.data.structureWidth + z) <= this.data.getLimiter()) {
                return this.structure[y][x][z];
            }
            return Blocks.AIR.getDefaultState();
        }

        public boolean isAirBlock(BlockPos pos) {
            return this.getBlockState(pos).getBlock() == Blocks.AIR;
        }

        public Biome getBiome(BlockPos pos) {
            return null;
        }

        public int getStrongPower(BlockPos pos, EnumFacing direction) {
            return 0;
        }

        public WorldType getWorldType() {
            return null;
        }

        public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
            return false;
        }
    }
}

