/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualPages;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.gui.GuiButtonManualNavigation;
import blusunrize.lib.manual.gui.GuiManual;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class ManualPageBlueprint
extends ManualPages {
    ItemStack[] stacks;
    ArrayList<ManualPages.PositionedItemStack[]> recipes = new ArrayList();
    int recipePage;
    int yOff;

    public ManualPageBlueprint(ManualInstance manual, String text, ItemStack ... stacks) {
        super(manual, text);
        this.stacks = stacks;
        this.recalculateCraftingRecipes();
    }

    @Override
    public void recalculateCraftingRecipes() {
        this.recipes.clear();
        ArrayList<String> cmCategories = BlueprintCraftingRecipe.blueprintCategories;
        ArrayListMultimap<String, BlueprintCraftingRecipe> cmRecipes = BlueprintCraftingRecipe.recipeList;
        for (String category : cmCategories) {
            for (BlueprintCraftingRecipe recipe : cmRecipes.get((Object)category)) {
                for (int iStack = 0; iStack < this.stacks.length; ++iStack) {
                    ItemStack output = this.stacks[iStack];
                    if (recipe.output.isEmpty() || !ManualUtils.stackMatchesObject(recipe.output, output) || recipe.inputs == null || recipe.inputs.length <= 0) continue;
                    int h = (int)Math.ceil((float)recipe.inputs.length / 2.0f);
                    ManualPages.PositionedItemStack[] pIngredients = new ManualPages.PositionedItemStack[recipe.inputs.length + 2];
                    for (int i = 0; i < recipe.inputs.length; ++i) {
                        pIngredients[i] = new ManualPages.PositionedItemStack(recipe.inputs[i].getSizedStackList(), 32 + i % 2 * 18, i / 2 * 18);
                    }
                    int middle = (int)((float)h / 2.0f * 18.0f) - 8;
                    pIngredients[pIngredients.length - 2] = new ManualPages.PositionedItemStack(recipe.output, 86, middle);
                    pIngredients[pIngredients.length - 1] = new ManualPages.PositionedItemStack(BlueprintCraftingRecipe.getTypedBlueprint(category), 8, middle);
                    if (iStack < this.recipes.size()) {
                        this.recipes.add(iStack, pIngredients);
                    } else {
                        this.recipes.add(pIngredients);
                    }
                    if (h * 18 <= this.yOff) continue;
                    this.yOff = h * 18;
                }
            }
        }
        if (this.providedItems != null) {
            this.providedItems.clear();
        }
        for (ItemStack stack : this.stacks) {
            this.addProvidedItem(stack);
        }
    }

    @Override
    public void initPage(GuiManual gui, int x, int y, List<GuiButton> pageButtons) {
        if (this.recipes.size() > 1) {
            pageButtons.add(new GuiButtonManualNavigation(gui, 100, x - 2, y + this.yOff / 2 - 3, 8, 10, 0));
            pageButtons.add(new GuiButtonManualNavigation(gui, 101, x + 122 - 16, y + this.yOff / 2 - 3, 8, 10, 1));
        }
        super.initPage(gui, x, y + this.yOff + 2, pageButtons);
    }

    @Override
    public void renderPage(GuiManual gui, int x, int y, int mx, int my) {
        GL11.glEnable((int)32826);
        RenderHelper.enableGUIStandardItemLighting();
        this.highlighted = ItemStack.EMPTY;
        if (!this.recipes.isEmpty() && this.recipePage >= 0 && this.recipePage < this.recipes.size()) {
            int maxX = 0;
            for (ManualPages.PositionedItemStack pstack : this.recipes.get(this.recipePage)) {
                if (pstack == null) continue;
                if (pstack.x > maxX) {
                    maxX = pstack.x;
                }
                gui.drawGradientRect(x + pstack.x, y + pstack.y, x + pstack.x + 16, y + pstack.y + 16, 0x33666666, 0x33666666);
            }
            ManualUtils.bindTexture(this.manual.texture);
            ManualUtils.drawTexturedRect(x + maxX - 17, y + this.yOff / 2 - 5, 16, 10, 0.0, 0.0625, 0.8828125, 0.921875);
        }
        GL11.glTranslated((double)0.0, (double)0.0, (double)300.0);
        boolean uni = this.manual.fontRenderer.getUnicodeFlag();
        this.manual.fontRenderer.setUnicodeFlag(false);
        if (!this.recipes.isEmpty() && this.recipePage >= 0 && this.recipePage < this.recipes.size()) {
            for (ManualPages.PositionedItemStack pstack : this.recipes.get(this.recipePage)) {
                if (pstack == null || pstack.getStack().isEmpty()) continue;
                ManualUtils.renderItem().renderItemAndEffectIntoGUI(pstack.getStack(), x + pstack.x, y + pstack.y);
                ManualUtils.renderItem().renderItemOverlayIntoGUI(this.manual.fontRenderer, pstack.getStack(), x + pstack.x, y + pstack.y, null);
                if (mx < x + pstack.x || mx >= x + pstack.x + 16 || my < y + pstack.y || my >= y + pstack.y + 16) continue;
                this.highlighted = pstack.getStack();
            }
        }
        GL11.glTranslated((double)0.0, (double)0.0, (double)-300.0);
        GL11.glDisable((int)32826);
        GlStateManager.enableBlend();
        RenderHelper.disableStandardItemLighting();
        this.manual.fontRenderer.setUnicodeFlag(uni);
        if (this.localizedText != null && !this.localizedText.isEmpty()) {
            ManualUtils.drawSplitString(this.manual.fontRenderer, this.localizedText, x, y + this.yOff + 2, 120, this.manual.getTextColour());
        }
        this.manual.fontRenderer.setUnicodeFlag(false);
        if (!this.highlighted.isEmpty()) {
            gui.renderToolTip(this.highlighted, mx, my);
        }
        GlStateManager.enableBlend();
        RenderHelper.disableStandardItemLighting();
    }

    @Override
    public void buttonPressed(GuiManual gui, GuiButton button) {
        super.buttonPressed(gui, button);
        this.recipePage = button.id % 100 == 0 ? --this.recipePage : ++this.recipePage;
        if (this.recipePage >= this.recipes.size()) {
            this.recipePage = 0;
        }
        if (this.recipePage < 0) {
            this.recipePage = this.recipes.size() - 1;
        }
    }

    @Override
    public boolean listForSearch(String searchTag) {
        for (ManualPages.PositionedItemStack[] recipe : this.recipes) {
            for (ManualPages.PositionedItemStack stack : recipe) {
                if (stack.stack instanceof ItemStack[]) {
                    for (ItemStack subStack : (ItemStack[])stack.stack) {
                        if (!subStack.getDisplayName().toLowerCase(Locale.ENGLISH).contains(searchTag)) continue;
                        return true;
                    }
                    continue;
                }
                if (stack.stack instanceof List) {
                    for (ItemStack subStack : (List)stack.stack) {
                        if (!subStack.getDisplayName().toLowerCase(Locale.ENGLISH).contains(searchTag)) continue;
                        return true;
                    }
                    continue;
                }
                if (stack.stack instanceof ItemStack) {
                    if (!((ItemStack)stack.stack).getDisplayName().toLowerCase(Locale.ENGLISH).contains(searchTag)) continue;
                    return true;
                }
                if (!(stack.stack instanceof String) || !ManualUtils.isExistingOreName((String)stack.stack)) continue;
                for (ItemStack subStack : OreDictionary.getOres((String)((String)stack.stack))) {
                    if (!subStack.getDisplayName().toLowerCase(Locale.ENGLISH).contains(searchTag)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

