/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;

public class DimensionChunkCoords
extends ChunkPos {
    public int dimension;

    public DimensionChunkCoords(int dimension, int x, int z) {
        super(x, z);
        this.dimension = dimension;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DimensionChunkCoords)) {
            return false;
        }
        DimensionChunkCoords coordPair = (DimensionChunkCoords)((Object)o);
        return this.dimension == coordPair.dimension && this.x == coordPair.x && this.z == coordPair.z;
    }

    public String toString() {
        return "[dim:" + this.dimension + "; " + this.x + ", " + this.z + "]";
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.setInteger("dim", this.dimension);
        tag.setInteger("x", this.x);
        tag.setInteger("z", this.z);
        return tag;
    }

    public static DimensionChunkCoords readFromNBT(NBTTagCompound tag) {
        if (tag.hasKey("dim", 3) && tag.hasKey("x", 3) && tag.hasKey("z", 3)) {
            return new DimensionChunkCoords(tag.getInteger("dim"), tag.getInteger("x"), tag.getInteger("z"));
        }
        return null;
    }
}

