/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DimensionBlockPos
extends BlockPos {
    public int dimension;

    public DimensionBlockPos(int x, int y, int z, int dim) {
        super(x, y, z);
        this.dimension = dim;
    }

    public DimensionBlockPos(int x, int y, int z, World w) {
        this(x, y, z, w.provider.getDimension());
    }

    public DimensionBlockPos(BlockPos pos, World w) {
        this(pos.getX(), pos.getY(), pos.getZ(), w.provider.getDimension());
    }

    public DimensionBlockPos(BlockPos pos, int dim) {
        this(pos.getX(), pos.getY(), pos.getZ(), dim);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dimension;
        result = 31 * result + this.getX();
        result = 31 * result + this.getY();
        result = 31 * result + this.getZ();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DimensionBlockPos other = (DimensionBlockPos)((Object)obj);
        if (this.dimension != other.dimension) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        return this.getZ() == other.getZ();
    }

    public String toString() {
        return "Dimension: " + this.dimension + " Pos: " + super.toString();
    }
}

