/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.api.IEApi;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class ComparableItemStack {
    public ItemStack stack;
    public boolean useNBT;
    public int oreID = -1;

    public ComparableItemStack(ItemStack stack) {
        this(stack, true);
    }

    public ComparableItemStack(ItemStack stack, boolean matchOre) {
        this(stack, matchOre, true);
    }

    public ComparableItemStack(ItemStack stack, boolean matchOre, boolean copy) {
        int[] oids;
        if (stack == null) {
            throw new RuntimeException("You cannot instantiate a ComparableItemStack with null for an Item!");
        }
        this.stack = stack;
        if (copy) {
            this.copy();
        }
        if (matchOre && (oids = OreDictionary.getOreIDs((ItemStack)stack)) != null && oids.length > 0) {
            this.oreID = oids[0];
        }
    }

    public void copy() {
        this.stack = this.stack.copy();
    }

    public ComparableItemStack(String oreName) {
        this(IEApi.getPreferredOreStack(oreName));
        this.oreID = OreDictionary.getOreID((String)oreName);
    }

    public ComparableItemStack setUseNBT(boolean useNBT) {
        this.useNBT = useNBT;
        return this;
    }

    public ComparableItemStack setOreID(int oid) {
        this.oreID = oid;
        return this;
    }

    public String toString() {
        return "ComparableStack: {" + this.stack.toString() + "}; oreID: " + this.oreID + "; checkNBT: " + this.useNBT;
    }

    public int hashCode() {
        if (this.oreID != -1) {
            return this.oreID;
        }
        int hash = (this.stack.getItemDamage() & 0xFFFF) * 31 + this.stack.getItem().hashCode() * 31;
        if (this.useNBT && this.stack.hasTagCompound()) {
            hash += this.stack.getTagCompound().hashCode() * 31;
        }
        return hash;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ComparableItemStack)) {
            return false;
        }
        if (this.oreID != -1 && ((ComparableItemStack)object).oreID != -1) {
            return this.oreID == ((ComparableItemStack)object).oreID;
        }
        ItemStack otherStack = ((ComparableItemStack)object).stack;
        if (!OreDictionary.itemMatches((ItemStack)this.stack, (ItemStack)otherStack, (boolean)false)) {
            return false;
        }
        if (this.useNBT) {
            if (this.stack.hasTagCompound() != otherStack.hasTagCompound()) {
                return false;
            }
            if (!this.stack.hasTagCompound() && !otherStack.hasTagCompound()) {
                return true;
            }
            if (!this.stack.getTagCompound().equals((Object)otherStack.getTagCompound())) {
                return false;
            }
        }
        return true;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.oreID != -1) {
            nbt.setString("oreID", OreDictionary.getOreName((int)this.oreID));
        } else {
            nbt.setTag("stack", (NBTBase)this.stack.writeToNBT(new NBTTagCompound()));
            nbt.setBoolean("useNBT", this.useNBT);
        }
        return nbt;
    }

    public static ComparableItemStack readFromNBT(NBTTagCompound nbt) {
        if (nbt.hasKey("oreID")) {
            return new ComparableItemStack(nbt.getString("oreID"));
        }
        if (nbt.hasKey("stack")) {
            ComparableItemStack comp = new ComparableItemStack(new ItemStack(nbt.getCompoundTag("stack")));
            comp.useNBT = nbt.getBoolean("useNBT");
            return comp;
        }
        return null;
    }
}

