/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.DimensionBlockPos;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.energy.wires.IICProxy;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;

public class ApiUtils {
    public static boolean compareToOreName(ItemStack stack, String oreName) {
        if (!ApiUtils.isExistingOreName(oreName)) {
            return false;
        }
        ItemStack comp = ApiUtils.copyStackWithAmount(stack, 1);
        NonNullList s = OreDictionary.getOres((String)oreName);
        for (ItemStack st : s) {
            if (!OreDictionary.itemMatches((ItemStack)st, (ItemStack)stack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static boolean stackMatchesObject(ItemStack stack, Object o) {
        return ApiUtils.stackMatchesObject(stack, o, false);
    }

    public static boolean stackMatchesObject(ItemStack stack, Object o, boolean checkNBT) {
        if (o instanceof ItemStack) {
            return OreDictionary.itemMatches((ItemStack)((ItemStack)o), (ItemStack)stack, (boolean)false) && (!checkNBT || ((ItemStack)o).getItemDamage() == Short.MAX_VALUE || Utils.compareItemNBT((ItemStack)o, stack));
        }
        if (o instanceof Collection) {
            for (Object io : (Collection)o) {
                if (!(io instanceof ItemStack) || !OreDictionary.itemMatches((ItemStack)((ItemStack)io), (ItemStack)stack, (boolean)false) || checkNBT && ((ItemStack)io).getItemDamage() != Short.MAX_VALUE && !Utils.compareItemNBT((ItemStack)io, stack)) continue;
                return true;
            }
        } else {
            if (o instanceof IngredientStack) {
                return ((IngredientStack)o).matchesItemStack(stack);
            }
            if (o instanceof ItemStack[]) {
                for (ItemStack io : (ItemStack[])o) {
                    if (!OreDictionary.itemMatches((ItemStack)io, (ItemStack)stack, (boolean)false) || checkNBT && io.getItemDamage() != Short.MAX_VALUE && !Utils.compareItemNBT(io, stack)) continue;
                    return true;
                }
            } else {
                if (o instanceof FluidStack) {
                    FluidStack fs = FluidUtil.getFluidContained((ItemStack)stack);
                    return fs != null && fs.containsFluid((FluidStack)o);
                }
                if (o instanceof String) {
                    return ApiUtils.compareToOreName(stack, (String)o);
                }
            }
        }
        return false;
    }

    public static ItemStack copyStackWithAmount(ItemStack stack, int amount) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack s2 = stack.copy();
        s2.setCount(amount);
        return s2;
    }

    public static boolean stacksMatchIngredientList(List<IngredientStack> list, NonNullList<ItemStack> stacks) {
        ArrayList<ItemStack> queryList = new ArrayList<ItemStack>(stacks.size());
        for (ItemStack s : stacks) {
            if (s.isEmpty()) continue;
            queryList.add(s.copy());
        }
        for (IngredientStack ingr : list) {
            if (ingr == null) continue;
            int amount = ingr.inputSize;
            Iterator it = queryList.iterator();
            while (it.hasNext()) {
                ItemStack query = (ItemStack)it.next();
                if (query.isEmpty()) continue;
                if (ingr.matchesItemStackIgnoringSize(query)) {
                    if (query.getCount() > amount) {
                        query.shrink(amount);
                        amount = 0;
                    } else {
                        amount -= query.getCount();
                        query.setCount(0);
                    }
                }
                if (query.getCount() <= 0) {
                    it.remove();
                }
                if (amount > 0) continue;
                break;
            }
            if (amount <= 0) continue;
            return false;
        }
        return true;
    }

    public static Ingredient createIngredientFromList(List<ItemStack> list) {
        return Ingredient.fromStacks((ItemStack[])list.toArray(new ItemStack[list.size()]));
    }

    public static ComparableItemStack createComparableItemStack(ItemStack stack) {
        return ApiUtils.createComparableItemStack(stack, true);
    }

    public static ComparableItemStack createComparableItemStack(ItemStack stack, boolean copy) {
        ComparableItemStack comp = new ComparableItemStack(stack, true, copy);
        if (stack.hasTagCompound() && !stack.getTagCompound().hasNoTags()) {
            comp.setUseNBT(true);
        }
        return comp;
    }

    public static boolean isExistingOreName(String name) {
        if (!OreDictionary.doesOreNameExist((String)name)) {
            return false;
        }
        return !OreDictionary.getOres((String)name).isEmpty();
    }

    public static boolean isMetalComponent(ItemStack stack, String componentType) {
        return ApiUtils.getMetalComponentType(stack, componentType) != null;
    }

    public static String getMetalComponentType(ItemStack stack, String ... componentTypes) {
        ItemStack comp = ApiUtils.copyStackWithAmount(stack, 1);
        for (String oreName : OreDictionary.getOreNames()) {
            for (int iType = 0; iType < componentTypes.length; ++iType) {
                if (!oreName.startsWith(componentTypes[iType])) continue;
                NonNullList s = OreDictionary.getOres((String)oreName);
                for (ItemStack st : s) {
                    if (!ItemStack.areItemStacksEqual((ItemStack)comp, (ItemStack)st)) continue;
                    return componentTypes[iType];
                }
            }
        }
        return null;
    }

    public static String[] getMetalComponentTypeAndMetal(ItemStack stack, String ... componentTypes) {
        ItemStack comp = ApiUtils.copyStackWithAmount(stack, 1);
        for (String oreName : OreDictionary.getOreNames()) {
            for (int iType = 0; iType < componentTypes.length; ++iType) {
                if (!oreName.startsWith(componentTypes[iType])) continue;
                NonNullList s = OreDictionary.getOres((String)oreName);
                for (ItemStack st : s) {
                    if (!ItemStack.areItemStacksEqual((ItemStack)comp, (ItemStack)st)) continue;
                    return new String[]{componentTypes[iType], oreName.substring(componentTypes[iType].length())};
                }
            }
        }
        return null;
    }

    public static boolean isIngot(ItemStack stack) {
        return ApiUtils.isMetalComponent(stack, "ingot");
    }

    public static boolean isPlate(ItemStack stack) {
        return ApiUtils.isMetalComponent(stack, "plate");
    }

    public static int getComponentIngotWorth(ItemStack stack) {
        Integer[] relation;
        String[] keys = IEApi.prefixToIngotMap.keySet().toArray(new String[IEApi.prefixToIngotMap.size()]);
        String key = ApiUtils.getMetalComponentType(stack, keys);
        if (key != null && (relation = IEApi.prefixToIngotMap.get(key)) != null && relation.length > 1) {
            double val = (double)relation[0].intValue() / (double)relation[1].intValue();
            return (int)val;
        }
        return 0;
    }

    public static ItemStack breakStackIntoIngots(ItemStack stack) {
        Integer[] relation;
        String[] keys = IEApi.prefixToIngotMap.keySet().toArray(new String[IEApi.prefixToIngotMap.size()]);
        String[] type = ApiUtils.getMetalComponentTypeAndMetal(stack, keys);
        if (type != null && (relation = IEApi.prefixToIngotMap.get(type[0])) != null && relation.length > 1) {
            double val = (double)relation[0].intValue() / (double)relation[1].intValue();
            return ApiUtils.copyStackWithAmount(IEApi.getPreferredOreStack("ingot" + type[1]), (int)val);
        }
        return ItemStack.EMPTY;
    }

    public static Object[] breakStackIntoPreciseIngots(ItemStack stack) {
        Integer[] relation;
        String[] keys = IEApi.prefixToIngotMap.keySet().toArray(new String[IEApi.prefixToIngotMap.size()]);
        String[] type = ApiUtils.getMetalComponentTypeAndMetal(stack, keys);
        if (type != null && (relation = IEApi.prefixToIngotMap.get(type[0])) != null && relation.length > 1) {
            double val = (double)relation[0].intValue() / (double)relation[1].intValue();
            return new Object[]{IEApi.getPreferredOreStack("ingot" + type[1]), val};
        }
        return null;
    }

    public static boolean canInsertStackIntoInventory(TileEntity inventory, ItemStack stack, EnumFacing side) {
        IItemHandler handler;
        ItemStack temp;
        return !stack.isEmpty() && inventory != null && inventory.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) && ((temp = ItemHandlerHelper.insertItem((IItemHandler)(handler = (IItemHandler)inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)), (ItemStack)stack.copy(), (boolean)true)).isEmpty() || temp.getCount() < stack.getCount());
    }

    public static ItemStack insertStackIntoInventory(TileEntity inventory, ItemStack stack, EnumFacing side) {
        IItemHandler handler;
        ItemStack temp;
        if (!stack.isEmpty() && inventory != null && inventory.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) && ((temp = ItemHandlerHelper.insertItem((IItemHandler)(handler = (IItemHandler)inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)), (ItemStack)stack.copy(), (boolean)true)).isEmpty() || temp.getCount() < stack.getCount())) {
            return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
        }
        return stack;
    }

    public static ItemStack insertStackIntoInventory(TileEntity inventory, ItemStack stack, EnumFacing side, boolean simulate) {
        if (inventory != null && !stack.isEmpty() && inventory.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            IItemHandler handler = (IItemHandler)inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.copy(), (boolean)simulate);
        }
        return stack;
    }

    public static BlockPos toBlockPos(Object object) {
        if (object instanceof BlockPos) {
            return (BlockPos)object;
        }
        if (object instanceof TileEntity) {
            return ((TileEntity)object).getPos();
        }
        if (object instanceof IICProxy) {
            return ((IICProxy)object).getPos();
        }
        return null;
    }

    public static IImmersiveConnectable toIIC(Object object, World world) {
        return ApiUtils.toIIC(object, world, true);
    }

    public static IImmersiveConnectable toIIC(Object object, World world, boolean allowProxies) {
        if (object instanceof IImmersiveConnectable) {
            return (IImmersiveConnectable)object;
        }
        if (object instanceof BlockPos) {
            DimensionBlockPos pos;
            TileEntity te;
            if (world != null && world.isBlockLoaded((BlockPos)object) && (te = world.getTileEntity((BlockPos)object)) instanceof IImmersiveConnectable) {
                return (IImmersiveConnectable)te;
            }
            if (allowProxies && ImmersiveNetHandler.INSTANCE.proxies.containsKey((Object)(pos = new DimensionBlockPos((BlockPos)object, world)))) {
                return ImmersiveNetHandler.INSTANCE.proxies.get((Object)pos);
            }
        }
        return null;
    }

    public static Vec3d addVectors(Vec3d vec0, Vec3d vec1) {
        return vec0.addVector(vec1.x, vec1.y, vec1.z);
    }

    public static Vec3d[] getConnectionCatenary(ImmersiveNetHandler.Connection connection, Vec3d start, Vec3d end) {
        boolean vertical;
        boolean bl = vertical = connection.end.getX() == connection.start.getX() && connection.end.getZ() == connection.start.getZ();
        if (vertical) {
            return new Vec3d[]{new Vec3d(start.x, start.y, start.z), new Vec3d(end.x, end.y, end.z)};
        }
        return ApiUtils.getConnectionCatenary(start, end, connection.cableType.getSlack());
    }

    public static Vec3d[] getConnectionCatenary(Vec3d start, Vec3d end, double slack) {
        double dx = end.x - start.x;
        double dy = end.y - start.y;
        double dz = end.z - start.z;
        double dw = Math.sqrt(dx * dx + dz * dz);
        double k = Math.sqrt(dx * dx + dy * dy + dz * dz) * slack;
        double l = 0.0;
        for (int limiter = 0; limiter < 300; ++limiter) {
            if (!(Math.sinh(l += 0.01) / l >= Math.sqrt(k * k - dy * dy) / dw)) continue;
        }
        double a = dw / 2.0 / l;
        double p = (0.0 + dw - a * Math.log((k + dy) / (k - dy))) * 0.5;
        double q = (dy + 0.0 - k * Math.cosh(l) / Math.sinh(l)) * 0.5;
        Vec3d[] vex = new Vec3d[18];
        vex[0] = new Vec3d(start.x, start.y, start.z);
        for (int i = 1; i < 17; ++i) {
            float n1 = (float)i / 17.0f;
            double x1 = 0.0 + dx * (double)n1;
            double z1 = 0.0 + dz * (double)n1;
            double y1 = a * Math.cosh((Math.sqrt(x1 * x1 + z1 * z1) - p) / a) + q;
            vex[i] = new Vec3d(start.x + x1, start.y + y1, start.z + z1);
        }
        vex[17] = new Vec3d(end.x, end.y, end.z);
        return vex;
    }

    public static WireType getWireTypeFromNBT(NBTTagCompound tag, String key) {
        if (tag.getTag(key) instanceof NBTTagInt) {
            int i = tag.getInteger(key);
            return i == 1 ? WireType.ELECTRUM : (i == 2 ? WireType.STEEL : (i == 3 ? WireType.STRUCTURE_ROPE : (i == 4 ? WireType.STRUCTURE_STEEL : WireType.COPPER)));
        }
        return WireType.getValue(tag.getString(key));
    }

    public static Object convertToValidRecipeInput(Object input) {
        if (input instanceof ItemStack) {
            return input;
        }
        if (input instanceof Item) {
            return new ItemStack((Item)input);
        }
        if (input instanceof Block) {
            return new ItemStack((Block)input);
        }
        if (input instanceof List) {
            return input;
        }
        if (input instanceof String) {
            if (!ApiUtils.isExistingOreName((String)input)) {
                return null;
            }
            NonNullList l = OreDictionary.getOres((String)((String)input));
            if (!l.isEmpty()) {
                return l;
            }
            return null;
        }
        throw new RuntimeException("Recipe Inputs must always be ItemStack, Item, Block or String (OreDictionary name), " + input + " is invalid");
    }

    public static IngredientStack createIngredientStack(Object input, boolean preferWildcard) {
        if (input instanceof IngredientStack) {
            return (IngredientStack)input;
        }
        if (input instanceof ItemStack) {
            return new IngredientStack((ItemStack)input);
        }
        if (input instanceof Item) {
            if (preferWildcard) {
                return new IngredientStack(new ItemStack((Item)input, 1, Short.MAX_VALUE));
            }
            return new IngredientStack(new ItemStack((Item)input));
        }
        if (input instanceof Block) {
            if (preferWildcard) {
                return new IngredientStack(new ItemStack((Block)input, 1, Short.MAX_VALUE));
            }
            return new IngredientStack(new ItemStack((Block)input));
        }
        if (input instanceof List && !((List)input).isEmpty()) {
            if (((List)input).get(0) instanceof ItemStack) {
                return new IngredientStack((List)input);
            }
            if (((List)input).get(0) instanceof String) {
                ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
                for (String s : (List)input) {
                    itemList.addAll((Collection<ItemStack>)OreDictionary.getOres((String)s));
                }
                return new IngredientStack(itemList);
            }
        } else {
            if (input instanceof ItemStack[]) {
                return new IngredientStack(Arrays.asList((ItemStack[])input));
            }
            if (input instanceof String[]) {
                ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
                for (String s : (String[])input) {
                    itemList.addAll((Collection<ItemStack>)OreDictionary.getOres((String)s));
                }
                return new IngredientStack(itemList);
            }
            if (input instanceof String) {
                return new IngredientStack((String)input);
            }
            if (input instanceof FluidStack) {
                return new IngredientStack((FluidStack)input);
            }
        }
        throw new RuntimeException("Recipe Ingredients must always be ItemStack, Item, Block, List<ItemStack>, String (OreDictionary name) or FluidStack; " + input + " is invalid");
    }

    public static IngredientStack createIngredientStack(Object input) {
        return ApiUtils.createIngredientStack(input, false);
    }

    public static ItemStack getItemStackFromObject(Object o) {
        if (o instanceof ItemStack) {
            return (ItemStack)o;
        }
        if (o instanceof Item) {
            return new ItemStack((Item)o);
        }
        if (o instanceof Block) {
            return new ItemStack((Block)o);
        }
        if (o instanceof List) {
            return (ItemStack)((List)o).get(0);
        }
        if (o instanceof String) {
            if (!ApiUtils.isExistingOreName((String)o)) {
                return ItemStack.EMPTY;
            }
            NonNullList l = OreDictionary.getOres((String)((String)o));
            if (!l.isEmpty()) {
                return (ItemStack)l.get(0);
            }
            return ItemStack.EMPTY;
        }
        return ItemStack.EMPTY;
    }

    public static boolean hasPlayerIngredient(EntityPlayer player, IngredientStack ingredient) {
        ItemStack itemstack;
        int amount = ingredient.inputSize;
        for (EnumHand hand : EnumHand.values()) {
            itemstack = player.getHeldItem(hand);
            if (!ingredient.matchesItemStackIgnoringSize(itemstack) || (amount -= itemstack.getCount()) > 0) continue;
            return true;
        }
        for (int i = 0; i < player.inventory.getSizeInventory(); ++i) {
            itemstack = player.inventory.getStackInSlot(i);
            if (!ingredient.matchesItemStackIgnoringSize(itemstack) || (amount -= itemstack.getCount()) > 0) continue;
            return true;
        }
        return amount <= 0;
    }

    public static void consumePlayerIngredient(EntityPlayer player, IngredientStack ingredient) {
        ItemStack itemstack;
        int amount = ingredient.inputSize;
        for (EnumHand hand : EnumHand.values()) {
            itemstack = player.getHeldItem(hand);
            if (!ingredient.matchesItemStackIgnoringSize(itemstack)) continue;
            int taken = Math.min(amount, itemstack.getCount());
            amount -= taken;
            itemstack.shrink(taken);
            if (itemstack.getCount() <= 0) {
                player.setHeldItem(hand, ItemStack.EMPTY);
            }
            if (amount > 0) continue;
            return;
        }
        for (int i = 0; i < player.inventory.getSizeInventory(); ++i) {
            itemstack = player.inventory.getStackInSlot(i);
            if (!ingredient.matchesItemStackIgnoringSize(itemstack)) continue;
            int taken = Math.min(amount, itemstack.getCount());
            amount -= taken;
            itemstack.shrink(taken);
            if (itemstack.getCount() <= 0) {
                player.inventory.setInventorySlotContents(i, ItemStack.EMPTY);
            }
            if (amount > 0) continue;
            return;
        }
    }

    public static Map<String, Integer> sortMap(Map<String, Integer> map, boolean inverse) {
        TreeMap<String, Integer> sortedMap = new TreeMap<String, Integer>(new ValueComparator(map, inverse));
        sortedMap.putAll(map);
        return sortedMap;
    }

    public static <T extends TileEntity> void checkForNeedlessTicking(T te) {
        if (!te.getWorld().isRemote && ((IEBlockInterfaces.IGeneralMultiblock)te).isLogicDummy()) {
            EventHandler.REMOVE_FROM_TICKING.add(te);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite getRegisterSprite(TextureMap map, String path) {
        TextureAtlasSprite sprite = map.getTextureExtry(path);
        if (sprite == null) {
            map.registerSprite(new ResourceLocation(path));
            sprite = map.getTextureExtry(path);
        }
        return sprite;
    }

    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite getRegisterSprite(TextureMap map, ResourceLocation path) {
        TextureAtlasSprite sprite = map.getTextureExtry(path.toString());
        if (sprite == null) {
            map.registerSprite(path);
            sprite = map.getTextureExtry(path.toString());
        }
        return sprite;
    }

    public static class ValueComparator
    implements Comparator<String> {
        Map<String, Integer> base;
        boolean inverse;

        public ValueComparator(Map<String, Integer> base, boolean inverse) {
            this.base = base;
            this.inverse = inverse;
        }

        @Override
        public int compare(String s0, String s1) {
            if (this.inverse) {
                if (this.base.get(s0) <= this.base.get(s1)) {
                    return -1;
                }
                return 1;
            }
            if (this.base.get(s0) >= this.base.get(s1)) {
                return -1;
            }
            return 1;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof ValueComparator)) {
                return false;
            }
            ValueComparator other = (ValueComparator)obj;
            return other.base == this.base && other.inverse == this.inverse;
        }
    }
}

