/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.lib.manual.IManualPage;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.gui.GuiButtonManualLink;
import blusunrize.lib.manual.gui.GuiButtonManualNavigation;
import blusunrize.lib.manual.gui.GuiManual;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.lwjgl.opengl.GL11;

public abstract class ManualPages
implements IManualPage {
    protected ManualInstance manual;
    protected String text;
    protected String localizedText;

    public ManualPages(ManualInstance manual, String text) {
        this.manual = manual;
        this.text = text;
    }

    @Override
    public void initPage(GuiManual gui, int x, int y, List<GuiButton> pageButtons) {
        if (this.text != null && !this.text.isEmpty()) {
            boolean uni = this.manual.fontRenderer.func_82883_a();
            this.manual.fontRenderer.func_78264_a(true);
            this.localizedText = this.manual.formatText(this.text);
            this.localizedText = ManualPages.addLinks(this.manual, gui, this.localizedText, x, y, 120, pageButtons);
            if (this.localizedText == null) {
                this.localizedText = "";
            }
            this.manual.fontRenderer.func_78264_a(uni);
        }
    }

    @Override
    public void buttonPressed(GuiManual gui, GuiButton button) {
        if (button instanceof GuiButtonManualLink && GuiManual.activeManual != null) {
            if (GuiManual.previousSelectedEntry.size() > 0) {
                GuiManual.previousSelectedEntry.add(0, GuiManual.getSelectedEntry());
            } else {
                GuiManual.previousSelectedEntry.add(GuiManual.getSelectedEntry());
            }
            GuiManual.setSelectedEntry(((GuiButtonManualLink)button).key);
            GuiManual.page = ((GuiButtonManualLink)button).pageLinked;
            GuiManual.activeManual.func_73866_w_();
        }
    }

    @Override
    public ManualInstance getManualHelper() {
        return this.manual;
    }

    @Override
    public void mouseDragged(int x, int y, int clickX, int clickY, int mx, int my, int lastX, int lastY, int button) {
    }

    @Override
    public void recalculateCraftingRecipes() {
    }

    public static String addLinks(ManualInstance helper, GuiManual gui, String text, int x, int y, int width, List<GuiButton> pageButtons) {
        int start;
        ArrayList<String[]> repList = new ArrayList<String[]>();
        int overflow = 0;
        while ((start = text.indexOf("<link")) >= 0 && overflow < 50) {
            String[] resultParts;
            ++overflow;
            int end = text.indexOf(">", start);
            String rep = text.substring(start, end + 1);
            String[] segment = rep.substring(0, rep.length() - 1).split(";");
            if (segment.length < 3) break;
            String page = segment.length > 3 ? segment[3] : "0";
            String result = segment[2];
            for (String part : resultParts = result.split(" ")) {
                repList.add(new String[]{part, segment[1], page});
            }
            text = text.replaceFirst(rep, result);
        }
        List list = helper.fontRenderer.func_78271_c(text, width);
        block4: for (String[] rep : repList) {
            for (int yOff = 0; yOff < list.size(); ++yOff) {
                String s = (String)list.get(yOff);
                start = s.indexOf(rep[0]);
                if (start < 0) continue;
                int bx = helper.fontRenderer.func_78256_a(s.substring(0, start));
                int by = yOff * helper.fontRenderer.field_78288_b;
                String bkey = rep[1];
                int bw = helper.fontRenderer.func_78256_a(rep[0]);
                int bpage = 0;
                try {
                    bpage = Integer.parseInt(rep[2]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                pageButtons.add(new GuiButtonManualLink(gui, 900 + overflow, x + bx, y + by, bw, (int)((double)helper.fontRenderer.field_78288_b * 1.5), bkey, rep[0], bpage));
                continue block4;
            }
        }
        return text;
    }

    public static class PositionedItemStack {
        public Object stack;
        public int x;
        public int y;
        public ArrayList<ItemStack> displayList;

        public PositionedItemStack(Object stack, int x, int y) {
            this.stack = stack;
            this.x = x;
            this.y = y;
        }

        public ItemStack getStack() {
            if (this.displayList == null) {
                this.displayList = new ArrayList();
                if (this.stack instanceof ItemStack) {
                    if (((ItemStack)this.stack).func_77952_i() == Short.MAX_VALUE) {
                        ItemStack[] list = NonNullList.func_191196_a();
                        ((ItemStack)this.stack).func_77973_b().func_150895_a(((ItemStack)this.stack).func_77973_b().func_77640_w(), (NonNullList)list);
                        if (list.size() > 0) {
                            this.displayList.addAll((Collection<ItemStack>)list);
                        }
                    } else {
                        this.displayList.add((ItemStack)this.stack);
                    }
                } else if (this.stack instanceof Ingredient) {
                    for (ItemStack subStack : ((Ingredient)this.stack).func_193365_a()) {
                        if (subStack.func_77952_i() == Short.MAX_VALUE) {
                            NonNullList list = NonNullList.func_191196_a();
                            subStack.func_77973_b().func_150895_a(subStack.func_77973_b().func_77640_w(), list);
                            if (list.size() <= 0) continue;
                            this.displayList.addAll((Collection<ItemStack>)list);
                            continue;
                        }
                        this.displayList.add(subStack);
                    }
                } else if (this.stack instanceof List && !((List)this.stack).isEmpty()) {
                    for (ItemStack subStack : (List)this.stack) {
                        if (subStack.func_77952_i() == Short.MAX_VALUE) {
                            NonNullList list = NonNullList.func_191196_a();
                            subStack.func_77973_b().func_150895_a(subStack.func_77973_b().func_77640_w(), list);
                            if (list.size() <= 0) continue;
                            this.displayList.addAll((Collection<ItemStack>)list);
                            continue;
                        }
                        this.displayList.add(subStack);
                    }
                }
            }
            if (this.displayList == null || this.displayList.isEmpty()) {
                return ItemStack.field_190927_a;
            }
            int perm = (int)(System.nanoTime() / 1000000000L % (long)this.displayList.size());
            return this.displayList.get(perm);
        }
    }

    public static class CraftingMulti
    extends ManualPages {
        Object[] stacks;
        ArrayList<PositionedItemStack[]> recipes = new ArrayList();
        int recipePage;
        int yOff;

        public CraftingMulti(ManualInstance manual, String text, Object ... stacks) {
            super(manual, text);
            this.stacks = stacks;
            this.recalculateCraftingRecipes();
        }

        @Override
        public void recalculateCraftingRecipes() {
            this.recipes.clear();
            if (this.stacks != null && this.stacks.length > 0 && this.stacks[0] instanceof PositionedItemStack[]) {
                PositionedItemStack[][] positionedItemStackArray = (PositionedItemStack[][])this.stacks;
                int n = positionedItemStackArray.length;
                for (int i = 0; i < n; ++i) {
                    PositionedItemStack[] pisA;
                    for (PositionedItemStack pis : pisA = positionedItemStackArray[i]) {
                        if (pis == null || pis.y + 18 <= this.yOff) continue;
                        this.yOff = pis.y + 18;
                    }
                    this.recipes.add(pisA);
                }
            } else {
                for (IRecipe recipe : CraftingManager.field_193380_a) {
                    for (int iStack = 0; iStack < this.stacks.length; ++iStack) {
                        int h;
                        int w;
                        Object stack = this.stacks[iStack];
                        if (recipe.func_77571_b().func_190926_b() || !ManualUtils.stackMatchesObject(recipe.func_77571_b(), stack)) continue;
                        NonNullList ingredientsPre = recipe.func_192400_c();
                        if (recipe instanceof ShapelessRecipes || recipe instanceof ShapelessOreRecipe) {
                            int n = ingredientsPre.size() > 6 ? 3 : (w = ingredientsPre.size() > 1 ? 2 : 1);
                            h = ingredientsPre.size() > 4 ? 3 : (ingredientsPre.size() > 2 ? 2 : 1);
                        } else if (recipe instanceof ShapedOreRecipe) {
                            w = ((ShapedOreRecipe)recipe).getWidth();
                            h = ((ShapedOreRecipe)recipe).getHeight();
                        } else {
                            if (!(recipe instanceof ShapedRecipes)) continue;
                            w = ((ShapedRecipes)recipe).func_192403_f();
                            h = ((ShapedRecipes)recipe).func_192404_g();
                        }
                        PositionedItemStack[] pIngredients = new PositionedItemStack[ingredientsPre.size() + 1];
                        int xBase = (120 - (w + 2) * 18) / 2;
                        for (int hh = 0; hh < h; ++hh) {
                            for (int ww = 0; ww < w; ++ww) {
                                if (hh * w + ww >= ingredientsPre.size()) continue;
                                pIngredients[hh * w + ww] = new PositionedItemStack(ingredientsPre.get(hh * w + ww), xBase + ww * 18, hh * 18);
                            }
                        }
                        pIngredients[pIngredients.length - 1] = new PositionedItemStack(recipe.func_77571_b(), xBase + w * 18 + 18, (int)((float)h / 2.0f * 18.0f) - 8);
                        if (iStack < this.recipes.size()) {
                            this.recipes.add(iStack, pIngredients);
                        } else {
                            this.recipes.add(pIngredients);
                        }
                        if (h * 18 <= this.yOff) continue;
                        this.yOff = h * 18;
                    }
                }
            }
        }

        @Override
        public void initPage(GuiManual gui, int x, int y, List<GuiButton> pageButtons) {
            if (this.recipes.size() > 1) {
                pageButtons.add(new GuiButtonManualNavigation(gui, 100, x - 2, y + this.yOff / 2 - 3, 8, 10, 0));
                pageButtons.add(new GuiButtonManualNavigation(gui, 101, x + 122 - 16, y + this.yOff / 2 - 3, 8, 10, 1));
            }
            super.initPage(gui, x, y + this.yOff + 2, pageButtons);
        }

        @Override
        public void renderPage(GuiManual gui, int x, int y, int mx, int my) {
            GL11.glEnable((int)32826);
            RenderHelper.func_74520_c();
            ItemStack highlighted = ItemStack.field_190927_a;
            if (!this.recipes.isEmpty() && this.recipePage >= 0 && this.recipePage < this.recipes.size()) {
                int maxX = 0;
                for (PositionedItemStack pstack : this.recipes.get(this.recipePage)) {
                    if (pstack == null) continue;
                    if (pstack.x > maxX) {
                        maxX = pstack.x;
                    }
                    gui.func_73733_a(x + pstack.x, y + pstack.y, x + pstack.x + 16, y + pstack.y + 16, 0x33666666, 0x33666666);
                }
                ManualUtils.bindTexture(this.manual.texture);
                ManualUtils.drawTexturedRect(x + maxX - 17, y + this.yOff / 2 - 5, 16, 10, 0.0, 0.0625, 0.8828125, 0.921875);
            }
            GL11.glTranslated((double)0.0, (double)0.0, (double)300.0);
            boolean uni = this.manual.fontRenderer.func_82883_a();
            this.manual.fontRenderer.func_78264_a(false);
            if (!this.recipes.isEmpty() && this.recipePage >= 0 && this.recipePage < this.recipes.size()) {
                for (PositionedItemStack pstack : this.recipes.get(this.recipePage)) {
                    if (pstack == null || pstack.getStack().func_190926_b()) continue;
                    ManualUtils.renderItem().func_180450_b(pstack.getStack(), x + pstack.x, y + pstack.y);
                    ManualUtils.renderItem().func_180453_a(this.manual.fontRenderer, pstack.getStack(), x + pstack.x, y + pstack.y, null);
                    if (mx < x + pstack.x || mx >= x + pstack.x + 16 || my < y + pstack.y || my >= y + pstack.y + 16) continue;
                    highlighted = pstack.getStack();
                }
            }
            GL11.glTranslated((double)0.0, (double)0.0, (double)-300.0);
            GL11.glDisable((int)32826);
            GlStateManager.func_179147_l();
            RenderHelper.func_74518_a();
            this.manual.fontRenderer.func_78264_a(uni);
            if (this.localizedText != null && !this.localizedText.isEmpty()) {
                ManualUtils.drawSplitString(this.manual.fontRenderer, this.localizedText, x, y + this.yOff + 2, 120, this.manual.getTextColour());
            }
            this.manual.fontRenderer.func_78264_a(false);
            if (!highlighted.func_190926_b()) {
                gui.func_146285_a(highlighted, mx, my);
            }
            GlStateManager.func_179147_l();
            RenderHelper.func_74518_a();
        }

        @Override
        public void buttonPressed(GuiManual gui, GuiButton button) {
            super.buttonPressed(gui, button);
            this.recipePage = button.field_146127_k % 100 == 0 ? --this.recipePage : ++this.recipePage;
            if (this.recipePage >= this.recipes.size()) {
                this.recipePage = 0;
            }
            if (this.recipePage < 0) {
                this.recipePage = this.recipes.size() - 1;
            }
        }

        @Override
        public boolean listForSearch(String searchTag) {
            for (PositionedItemStack[] recipe : this.recipes) {
                for (PositionedItemStack stack : recipe) {
                    if (stack.stack instanceof ItemStack[]) {
                        for (ItemStack subStack : (ItemStack[])stack.stack) {
                            if (!subStack.func_82833_r().toLowerCase(Locale.ENGLISH).contains(searchTag)) continue;
                            return true;
                        }
                        continue;
                    }
                    if (stack.stack instanceof List) {
                        for (ItemStack subStack : (List)stack.stack) {
                            if (!subStack.func_82833_r().toLowerCase(Locale.ENGLISH).contains(searchTag)) continue;
                            return true;
                        }
                        continue;
                    }
                    if (stack.stack instanceof ItemStack) {
                        if (!((ItemStack)stack.stack).func_82833_r().toLowerCase(Locale.ENGLISH).contains(searchTag)) continue;
                        return true;
                    }
                    if (!(stack.stack instanceof String) || !ManualUtils.isExistingOreName((String)stack.stack)) continue;
                    for (ItemStack subStack : OreDictionary.getOres((String)((String)stack.stack))) {
                        if (!subStack.func_82833_r().toLowerCase(Locale.ENGLISH).contains(searchTag)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    public static class Crafting
    extends ManualPages {
        Object[] stacks;
        ArrayListMultimap<Object, PositionedItemStack[]> recipes = ArrayListMultimap.create();
        int[] recipePage;
        int[] yOff;

        public Crafting(ManualInstance manual, String text, Object ... stacks) {
            super(manual, text);
            this.stacks = stacks;
            this.recipePage = new int[stacks.length];
            this.yOff = new int[stacks.length];
            this.recalculateCraftingRecipes();
        }

        @Override
        public void recalculateCraftingRecipes() {
            this.recipes.clear();
            for (IRecipe recipe : CraftingManager.field_193380_a) {
                for (int iStack = 0; iStack < this.stacks.length; ++iStack) {
                    Object stack = this.stacks[iStack];
                    if (stack instanceof ItemStack[]) {
                        for (ItemStack subStack : (ItemStack[])stack) {
                            this.checkRecipe(recipe, stack, subStack, iStack);
                        }
                        continue;
                    }
                    this.checkRecipe(recipe, stack, stack, iStack);
                }
            }
        }

        void checkRecipe(IRecipe rec, Object key, Object stack, int iStack) {
            if (!rec.func_77571_b().func_190926_b() && ManualUtils.stackMatchesObject(rec.func_77571_b(), stack)) {
                int h;
                int w;
                NonNullList ingredientsPre = rec.func_192400_c();
                if (rec instanceof ShapelessRecipes || rec instanceof ShapelessOreRecipe) {
                    int n = ingredientsPre.size() > 6 ? 3 : (w = ingredientsPre.size() > 1 ? 2 : 1);
                    h = ingredientsPre.size() > 4 ? 3 : (ingredientsPre.size() > 2 ? 2 : 1);
                } else if (rec instanceof ShapedOreRecipe) {
                    w = ((ShapedOreRecipe)rec).getWidth();
                    h = ((ShapedOreRecipe)rec).getHeight();
                } else if (rec instanceof ShapedRecipes) {
                    w = ((ShapedRecipes)rec).field_77576_b;
                    h = ((ShapedRecipes)rec).field_77577_c;
                } else {
                    return;
                }
                PositionedItemStack[] pIngredients = new PositionedItemStack[ingredientsPre.size() + 1];
                int xBase = (120 - (w + 2) * 18) / 2;
                for (int hh = 0; hh < h; ++hh) {
                    for (int ww = 0; ww < w; ++ww) {
                        if (hh * w + ww >= ingredientsPre.size()) continue;
                        pIngredients[hh * w + ww] = new PositionedItemStack(ingredientsPre.get(hh * w + ww), xBase + ww * 18, hh * 18);
                    }
                }
                pIngredients[pIngredients.length - 1] = new PositionedItemStack(rec.func_77571_b(), xBase + w * 18 + 18, (int)((float)h / 2.0f * 18.0f) - 8);
                this.recipes.put(key, (Object)pIngredients);
                if (h * 18 > this.yOff[iStack]) {
                    this.yOff[iStack] = h * 18;
                }
            }
        }

        @Override
        public void initPage(GuiManual gui, int x, int y, List<GuiButton> pageButtons) {
            int i = 1;
            int yyOff = 0;
            for (Object stack : this.stacks) {
                if (this.recipes.get(stack).size() > 1) {
                    pageButtons.add(new GuiButtonManualNavigation(gui, 100 * i + 0, x - 2, y + yyOff + this.yOff[i - 1] / 2 - 3, 8, 10, 0));
                    pageButtons.add(new GuiButtonManualNavigation(gui, 100 * i + 1, x + 122 - 16, y + yyOff + this.yOff[i - 1] / 2 - 3, 8, 10, 1));
                }
                if (this.recipes.get(stack).size() > 0) {
                    yyOff += this.yOff[i - 1] + 8;
                }
                ++i;
            }
            super.initPage(gui, x, y + yyOff - 2, pageButtons);
        }

        @Override
        public void renderPage(GuiManual gui, int x, int y, int mx, int my) {
            GL11.glEnable((int)32826);
            RenderHelper.func_74520_c();
            int totalYOff = 0;
            ItemStack highlighted = ItemStack.field_190927_a;
            for (int i = 0; i < this.stacks.length; ++i) {
                Object stack = this.stacks[i];
                List rList = this.recipes.get(stack);
                if (rList.isEmpty() || this.recipePage[i] < 0 || this.recipePage[i] >= this.recipes.size()) continue;
                int maxX = 0;
                for (PositionedItemStack pstack : (PositionedItemStack[])rList.get(this.recipePage[i])) {
                    if (pstack == null) continue;
                    if (pstack.x > maxX) {
                        maxX = pstack.x;
                    }
                    gui.func_73733_a(x + pstack.x, y + totalYOff + pstack.y, x + pstack.x + 16, y + totalYOff + pstack.y + 16, 0x33666666, 0x33666666);
                }
                ManualUtils.bindTexture(this.manual.texture);
                ManualUtils.drawTexturedRect(x + maxX - 17, y + totalYOff + this.yOff[i] / 2 - 5, 16, 10, 0.0, 0.0625, 0.8828125, 0.921875);
                totalYOff += this.yOff[i] + 8;
            }
            totalYOff = 0;
            GL11.glTranslated((double)0.0, (double)0.0, (double)300.0);
            boolean uni = this.manual.fontRenderer.func_82883_a();
            this.manual.fontRenderer.func_78264_a(false);
            for (int i = 0; i < this.stacks.length; ++i) {
                Object stack = this.stacks[i];
                List rList = this.recipes.get(stack);
                if (rList.isEmpty() || this.recipePage[i] < 0 || this.recipePage[i] >= this.recipes.size()) continue;
                for (PositionedItemStack pstack : (PositionedItemStack[])rList.get(this.recipePage[i])) {
                    if (pstack == null || pstack.getStack().func_190926_b()) continue;
                    ManualUtils.renderItem().func_180450_b(pstack.getStack(), x + pstack.x, y + totalYOff + pstack.y);
                    ManualUtils.renderItem().func_180453_a(this.manual.fontRenderer, pstack.getStack(), x + pstack.x, y + totalYOff + pstack.y, null);
                    if (mx < x + pstack.x || mx >= x + pstack.x + 16 || my < y + totalYOff + pstack.y || my >= y + totalYOff + pstack.y + 16) continue;
                    highlighted = pstack.getStack();
                }
                totalYOff += this.yOff[i] + 8;
            }
            GL11.glTranslated((double)0.0, (double)0.0, (double)-300.0);
            GL11.glDisable((int)32826);
            GlStateManager.func_179147_l();
            RenderHelper.func_74518_a();
            this.manual.fontRenderer.func_78264_a(uni);
            if (this.localizedText != null && !this.localizedText.isEmpty()) {
                ManualUtils.drawSplitString(this.manual.fontRenderer, this.localizedText, x, y + totalYOff - 2, 120, this.manual.getTextColour());
            }
            this.manual.fontRenderer.func_78264_a(false);
            if (!highlighted.func_190926_b()) {
                gui.func_146285_a(highlighted, mx, my);
            }
            GlStateManager.func_179147_l();
            RenderHelper.func_74518_a();
        }

        @Override
        public void buttonPressed(GuiManual gui, GuiButton button) {
            super.buttonPressed(gui, button);
            int r = button.field_146127_k / 100 - 1;
            if (r >= 0 && r < this.stacks.length) {
                if (button.field_146127_k % 100 == 0) {
                    int n = r;
                    this.recipePage[n] = this.recipePage[n] - 1;
                } else {
                    int n = r;
                    this.recipePage[n] = this.recipePage[n] + 1;
                }
                if (this.recipePage[r] >= this.recipes.get(this.stacks[r]).size()) {
                    this.recipePage[r] = 0;
                }
                if (this.recipePage[r] < 0) {
                    this.recipePage[r] = this.recipes.get(this.stacks[r]).size() - 1;
                }
            }
        }

        @Override
        public boolean listForSearch(String searchTag) {
            for (Object stack : this.stacks) {
                if (stack instanceof ItemStack[]) {
                    for (ItemStack subStack : (ItemStack[])stack) {
                        if (!subStack.func_82833_r().toLowerCase(Locale.ENGLISH).contains(searchTag)) continue;
                        return true;
                    }
                    continue;
                }
                if (stack instanceof ItemStack) {
                    if (!((ItemStack)stack).func_82833_r().toLowerCase(Locale.ENGLISH).contains(searchTag)) continue;
                    return true;
                }
                if (!(stack instanceof String) || !ManualUtils.isExistingOreName((String)stack)) continue;
                for (ItemStack subStack : OreDictionary.getOres((String)((String)stack))) {
                    if (!subStack.func_82833_r().toLowerCase(Locale.ENGLISH).contains(searchTag)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class ItemDisplay
    extends ManualPages {
        NonNullList<ItemStack> stacks;

        static NonNullList<ItemStack> parseArray(ItemStack ... stacks) {
            NonNullList list = NonNullList.func_191197_a((int)stacks.length, (Object)ItemStack.field_190927_a);
            for (int i = 0; i < stacks.length; ++i) {
                list.set(i, (Object)stacks[i]);
            }
            return list;
        }

        public ItemDisplay(ManualInstance manual, String text, ItemStack ... stacks) {
            this(manual, text, ItemDisplay.parseArray(stacks));
        }

        public ItemDisplay(ManualInstance manual, String text, NonNullList<ItemStack> stacks) {
            super(manual, text);
            this.stacks = stacks;
        }

        @Override
        public void initPage(GuiManual gui, int x, int y, List<GuiButton> pageButtons) {
            int length = this.stacks.size();
            int yOffset = 0;
            if (length > 0) {
                float scale = length > 7 ? 1.0f : (length > 4 ? 1.5f : 2.0f);
                int line0 = (int)(8.0f / scale);
                int line1 = line0 - 1;
                int lineSum = line0 + line1;
                int lines = length / lineSum * 2 + length % lineSum / line0 + (length % lineSum % line0 > 0 ? 1 : 0);
                float equalPerLine = (float)length / (float)lines;
                line1 = (int)Math.floor(equalPerLine);
                line0 = (int)Math.ceil(equalPerLine);
                lineSum = line0 + line1;
                yOffset = lines * (int)(18.0f * scale);
            }
            super.initPage(gui, x, y + yOffset, pageButtons);
        }

        @Override
        public void renderPage(GuiManual gui, int x, int y, int mx, int my) {
            GL11.glEnable((int)32826);
            RenderHelper.func_74520_c();
            ItemStack highlighted = ItemStack.field_190927_a;
            int yOffset = 0;
            int length = this.stacks.size();
            if (length > 0) {
                float scale = length > 8 ? 1.0f : (length > 3 ? 1.5f : 2.0f);
                int line0 = (int)(7.5 / (double)scale);
                int line1 = line0 - 1;
                int lineSum = line0 + line1;
                int lines = length / lineSum * 2 + length % lineSum / line0 + (length % lineSum % line0 > 0 ? 1 : 0);
                float equalPerLine = (float)length / (float)lines;
                line1 = (int)Math.floor(equalPerLine);
                line0 = (int)Math.ceil(equalPerLine);
                lineSum = line0 + line1;
                int lastLines = length % lineSum;
                int lastLine = lastLines == line0 ? line0 : (lastLines == 0 ? line1 : lastLines % line0);
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                yOffset = lines * (int)(18.0f * scale);
                for (int line = 0; line < lines; ++line) {
                    int item;
                    int perLine;
                    int n = line == lines - 1 ? lastLine : (perLine = line % 2 == 0 ? line0 : line1);
                    if (line == 0 && perLine > length) {
                        perLine = length;
                    }
                    int w2 = perLine * (int)(18.0f * scale) / 2;
                    for (int i = 0; i < perLine && (item = line / 2 * lineSum + line % 2 * line0 + i) < length; ++i) {
                        int xx = x + 60 - w2 + (int)((float)(i * 18) * scale);
                        int yy = y + (lines < 2 ? 4 : 0) + line * (int)(18.0f * scale);
                        ManualUtils.renderItem().func_180450_b((ItemStack)this.stacks.get(item), (int)((float)xx / scale), (int)((float)yy / scale));
                        if (mx < xx || !((float)mx < (float)xx + 16.0f * scale) || my < yy || !((float)my < (float)yy + 16.0f * scale)) continue;
                        highlighted = (ItemStack)this.stacks.get(item);
                    }
                }
                GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
            }
            RenderHelper.func_74518_a();
            GL11.glDisable((int)32826);
            GlStateManager.func_179147_l();
            if (this.localizedText != null && !this.localizedText.isEmpty()) {
                ManualUtils.drawSplitString(this.manual.fontRenderer, this.localizedText, x, y + yOffset, 120, this.manual.getTextColour());
            }
            this.manual.fontRenderer.func_78264_a(false);
            if (!highlighted.func_190926_b()) {
                gui.func_146285_a(highlighted, mx, my);
            }
            RenderHelper.func_74518_a();
        }

        @Override
        public boolean listForSearch(String searchTag) {
            for (ItemStack stack : this.stacks) {
                if (!stack.func_82833_r().toLowerCase(Locale.ENGLISH).contains(searchTag)) continue;
                return true;
            }
            return false;
        }
    }

    public static class Table
    extends ManualPages {
        String[][] table;
        String[][] localizedTable;
        int textHeight;
        int[] bars;
        boolean horizontalBars = false;

        public Table(ManualInstance manual, String text, String[][] table, boolean horizontalBars) {
            super(manual, text);
            this.table = table;
            this.horizontalBars = horizontalBars;
        }

        @Override
        public void initPage(GuiManual gui, int x, int y, List<GuiButton> pageButtons) {
            super.initPage(gui, x, y, pageButtons);
            this.manual.fontRenderer.func_78264_a(true);
            int l = this.localizedText != null ? this.manual.fontRenderer.func_78271_c(this.localizedText, 120).size() : 0;
            this.textHeight = l * this.manual.fontRenderer.field_78288_b + 6;
            try {
                if (this.table != null) {
                    this.localizedTable = new String[this.table.length][];
                    this.bars = new int[1];
                    for (int i = 0; i < this.table.length; ++i) {
                        int j;
                        this.localizedTable[i] = new String[this.table[i].length];
                        for (j = 0; j < this.table[i].length; ++j) {
                            if (this.table[i][j] == null) continue;
                            this.localizedTable[i][j] = I18n.func_135052_a((String)this.table[i][j], (Object[])new Object[0]);
                        }
                        if (this.table[i].length - 1 > this.bars.length) {
                            int[] newBars = new int[this.table[i].length - 1];
                            System.arraycopy(this.bars, 0, newBars, 0, this.bars.length);
                            this.bars = newBars;
                        }
                        for (j = 0; j < this.table[i].length - 1; ++j) {
                            int fl = this.manual.fontRenderer.func_78256_a(this.localizedTable[i][j]);
                            if (fl <= this.bars[j]) continue;
                            this.bars[j] = fl;
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.manual.fontRenderer.func_78264_a(false);
        }

        @Override
        public void renderPage(GuiManual gui, int x, int y, int mx, int my) {
            if (this.localizedText != null && !this.localizedText.isEmpty()) {
                ManualUtils.drawSplitString(this.manual.fontRenderer, this.localizedText, x, y, 120, this.manual.getTextColour());
            }
            if (this.localizedTable != null) {
                int i;
                int col = this.manual.getHighlightColour() | 0xFF000000;
                gui.func_73733_a(x, y + this.textHeight - 2, x + 120, y + this.textHeight - 1, col, col);
                int[] textOff = new int[this.bars != null ? this.bars.length : 0];
                if (this.bars != null) {
                    int xx = x;
                    for (i = 0; i < this.bars.length; ++i) {
                        xx += this.bars[i] + 4;
                        textOff[i] = xx += 4;
                    }
                }
                int yOff = 0;
                for (i = 0; i < this.localizedTable.length; ++i) {
                    if (this.localizedTable[i] == null) continue;
                    for (int j = 0; j < this.localizedTable[i].length; ++j) {
                        if (this.localizedTable[i][j] == null) continue;
                        int xx = textOff.length > 0 && j > 0 ? textOff[j - 1] : x;
                        int w = Math.max(10, 120 - (j > 0 ? textOff[j - 1] - x : 0));
                        ManualUtils.drawSplitString(this.manual.fontRenderer, this.localizedTable[i][j], xx, y + this.textHeight + yOff, w, this.manual.getTextColour());
                        if (j == 0) continue;
                        int l = this.manual.fontRenderer.func_78271_c(this.localizedTable[i][j], w).size();
                        if (this.horizontalBars) {
                            float scale = 0.5f;
                            GL11.glScalef((float)1.0f, (float)scale, (float)1.0f);
                            gui.func_73733_a(x, (int)((float)(y + this.textHeight + yOff + l * this.manual.fontRenderer.field_78288_b) / scale), x + 120, (int)((float)(y + this.textHeight + yOff + l * this.manual.fontRenderer.field_78288_b) / scale + 1.0f), this.manual.getTextColour() | 0xFF000000, this.manual.getTextColour() | 0xFF000000);
                            GL11.glScalef((float)1.0f, (float)(1.0f / scale), (float)1.0f);
                        }
                        yOff += l * (this.manual.fontRenderer.field_78288_b + 1);
                    }
                }
                if (this.bars != null) {
                    for (i = 0; i < this.bars.length; ++i) {
                        gui.func_73733_a(textOff[i] - 4, y + this.textHeight - 4, textOff[i] - 3, y + this.textHeight + yOff, col, col);
                    }
                }
            }
        }

        @Override
        public boolean listForSearch(String searchTag) {
            return false;
        }
    }

    public static class Image
    extends ManualPages {
        String[] resources;
        int[][] sizing;

        public Image(ManualInstance helper, String text, String ... images) {
            super(helper, text);
            this.resources = new String[images.length];
            this.sizing = new int[images.length][4];
            for (int i = 0; i < images.length; ++i) {
                String[] split = images[i].split(";");
                if (split.length < 5) continue;
                this.resources[i] = split[0];
                try {
                    this.sizing[i][0] = Integer.parseInt(split[1]);
                    this.sizing[i][1] = Integer.parseInt(split[2]);
                    this.sizing[i][2] = Integer.parseInt(split[3]);
                    this.sizing[i][3] = Integer.parseInt(split[4]);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void initPage(GuiManual gui, int x, int y, List<GuiButton> pageButtons) {
            int yOff = 0;
            for (int i = 0; i < this.resources.length; ++i) {
                if (this.resources[i] == null || this.resources[i].isEmpty()) continue;
                yOff += this.sizing[i][3] + 5;
            }
            super.initPage(gui, x, y + yOff, pageButtons);
        }

        @Override
        public void renderPage(GuiManual gui, int x, int y, int mx, int my) {
            int yOff = 0;
            for (int i = 0; i < this.resources.length; ++i) {
                if (this.resources[i] == null || this.resources[i].isEmpty()) continue;
                int xOff = 60 - this.sizing[i][2] / 2;
                gui.func_73733_a(x + xOff - 2, y + yOff - 2, x + xOff + this.sizing[i][2] + 2, y + yOff + this.sizing[i][3] + 2, -1398964, -610215);
                gui.func_73733_a(x + xOff - 1, y + yOff - 1, x + xOff + this.sizing[i][2] + 1, y + yOff + this.sizing[i][3] + 1, -3764666, -4290492);
                yOff += this.sizing[i][3] + 5;
            }
            String lastResource = "";
            yOff = 0;
            for (int i = 0; i < this.resources.length; ++i) {
                if (this.resources[i] == null || this.resources[i].isEmpty()) continue;
                if (this.resources[i] != lastResource) {
                    ManualUtils.bindTexture(this.resources[i]);
                }
                int xOff = 60 - this.sizing[i][2] / 2;
                ManualUtils.drawTexturedRect(x + xOff, y + yOff, this.sizing[i][2], this.sizing[i][3], (float)this.sizing[i][0] / 256.0f, (float)(this.sizing[i][0] + this.sizing[i][2]) / 256.0f, (float)this.sizing[i][1] / 256.0f, (float)(this.sizing[i][1] + this.sizing[i][3]) / 256.0f);
                yOff += this.sizing[i][3] + 5;
                lastResource = this.resources[i];
            }
            if (this.localizedText != null && !this.localizedText.isEmpty()) {
                ManualUtils.drawSplitString(this.manual.fontRenderer, this.localizedText, x, y + yOff, 120, this.manual.getTextColour());
            }
        }

        @Override
        public boolean listForSearch(String searchTag) {
            return false;
        }
    }

    public static class Text
    extends ManualPages {
        public Text(ManualInstance manual, String text) {
            super(manual, text);
        }

        @Override
        public void renderPage(GuiManual gui, int x, int y, int mx, int my) {
            if (this.localizedText != null && !this.localizedText.isEmpty()) {
                ManualUtils.drawSplitString(this.manual.fontRenderer, this.localizedText, x, y, 120, this.manual.getTextColour());
            }
            GlStateManager.func_179147_l();
        }

        @Override
        public boolean listForSearch(String searchTag) {
            return false;
        }
    }
}

