/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.IUpgrade;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemToolUpgrade
extends ItemIEBase
implements IUpgrade {
    public ItemToolUpgrade() {
        super("toolupgrade", 1, ToolUpgrades.parse());
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (stack.func_77952_i() < this.getSubNames().length) {
            String[] flavour;
            for (String s : flavour = ImmersiveEngineering.proxy.splitStringOnWidth(I18n.func_135052_a((String)("desc.immersiveengineering.flavour.toolupgrade." + this.getSubNames()[stack.func_77952_i()]), (Object[])new Object[0]), 200)) {
                list.add(s);
            }
        }
    }

    public int getItemStackLimit(ItemStack stack) {
        return ToolUpgrades.get(stack.func_77960_j()).stackSize;
    }

    @Override
    public Set<String> getUpgradeTypes(ItemStack upgrade) {
        return ToolUpgrades.get(upgrade.func_77960_j()).toolset;
    }

    @Override
    public boolean canApplyUpgrades(ItemStack target, ItemStack upgrade) {
        BiPredicate check = ToolUpgrades.get(upgrade.func_77960_j()).applyCheck;
        if (check != null && target.func_77973_b() instanceof IUpgradeableTool) {
            return check.test(target, upgrade);
        }
        return true;
    }

    @Override
    public void applyUpgrades(ItemStack target, ItemStack upgrade, NBTTagCompound modifications) {
        ToolUpgrades.get(upgrade.func_77960_j()).function.accept(upgrade, modifications);
    }

    public static enum ToolUpgrades {
        DRILL_WATERPROOF((ImmutableSet<String>)ImmutableSet.of((Object)"DRILL"), (upgrade, modifications) -> modifications.func_74757_a("waterproof", true)),
        DRILL_LUBE((ImmutableSet<String>)ImmutableSet.of((Object)"DRILL"), (upgrade, modifications) -> modifications.func_74757_a("oiled", true)),
        DRILL_DAMAGE((ImmutableSet<String>)ImmutableSet.of((Object)"DRILL"), 3, (upgrade, modifications) -> {
            ItemNBTHelper.modifyFloat(modifications, "speed", (float)upgrade.func_190916_E() * 2.0f);
            ItemNBTHelper.modifyInt(modifications, "damage", upgrade.func_190916_E());
        }),
        DRILL_CAPACITY((ImmutableSet<String>)ImmutableSet.of((Object)"DRILL", (Object)"CHEMTHROWER"), (upgrade, modifications) -> ItemNBTHelper.modifyInt(modifications, "capacity", 2000)),
        REVOLVER_BAYONET((ImmutableSet<String>)ImmutableSet.of((Object)"REVOLVER"), (upgrade, modifications) -> ItemNBTHelper.modifyFloat(modifications, "melee", 6.0f)),
        REVOLVER_MAGAZINE((ImmutableSet<String>)ImmutableSet.of((Object)"REVOLVER"), 1, (target, upgrade) -> !((IUpgradeableTool)target.func_77973_b()).getUpgrades((ItemStack)target).func_74764_b("bullets"), (upgrade, modifications) -> ItemNBTHelper.modifyInt(modifications, "bullets", 6)),
        REVOLVER_ELECTRO((ImmutableSet<String>)ImmutableSet.of((Object)"REVOLVER"), (upgrade, modifications) -> modifications.func_74757_a("electro", true)),
        CHEMTHROWER_FOCUS((ImmutableSet<String>)ImmutableSet.of((Object)"CHEMTHROWER"), (upgrade, modifications) -> modifications.func_74757_a("focus", true)),
        RAILGUN_SCOPE((ImmutableSet<String>)ImmutableSet.of((Object)"RAILGUN"), (upgrade, modifications) -> modifications.func_74757_a("scope", true)),
        RAILGUN_CAPACITORS((ImmutableSet<String>)ImmutableSet.of((Object)"RAILGUN"), (upgrade, modifications) -> modifications.func_74776_a("speed", 1.0f)),
        SHIELD_FLASH((ImmutableSet<String>)ImmutableSet.of((Object)"SHIELD"), (upgrade, modifications) -> modifications.func_74757_a("flash", true)),
        SHIELD_SHOCK((ImmutableSet<String>)ImmutableSet.of((Object)"SHIELD"), (upgrade, modifications) -> modifications.func_74757_a("shock", true)),
        SHIELD_MAGNET((ImmutableSet<String>)ImmutableSet.of((Object)"SHIELD"), (upgrade, modifications) -> modifications.func_74757_a("magnet", true));

        private ImmutableSet<String> toolset;
        private int stackSize = 1;
        private BiPredicate<ItemStack, ItemStack> applyCheck;
        private BiConsumer<ItemStack, NBTTagCompound> function;

        private ToolUpgrades(ImmutableSet<String> toolset, BiConsumer<ItemStack, NBTTagCompound> function) {
            this(toolset, 1, function);
        }

        private ToolUpgrades(ImmutableSet<String> toolset, int stackSize, BiConsumer<ItemStack, NBTTagCompound> function) {
            this(toolset, stackSize, null, function);
        }

        private ToolUpgrades(ImmutableSet<String> toolset, int stackSize, BiPredicate<ItemStack, ItemStack> applyCheck, BiConsumer<ItemStack, NBTTagCompound> function) {
            this.toolset = toolset;
            this.stackSize = stackSize;
            this.applyCheck = applyCheck;
            this.function = function;
        }

        static String[] parse() {
            String[] ret = new String[ToolUpgrades.values().length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = ToolUpgrades.values()[i].toString().toLowerCase(Locale.US);
            }
            return ret;
        }

        static ToolUpgrades get(int meta) {
            if (meta >= 0 && meta < ToolUpgrades.values().length) {
                return ToolUpgrades.values()[meta];
            }
            return DRILL_WATERPROOF;
        }
    }
}

