/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxProvider;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxReceiver;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.common.CommonProxy;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.RotationUtil;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.advancements.IEAdvancements;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerTryUseItemOnBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemIETool
extends ItemIEBase
implements ITool,
IEItemInterfaces.IGuiItem {
    static int hammerMaxDamage;
    static int cutterMaxDamage;

    public ItemIETool() {
        super("tool", 1, "hammer", "wirecutter", "voltmeter", "manual");
        hammerMaxDamage = Config.IEConfig.Tools.hammerDurabiliy;
        cutterMaxDamage = Config.IEConfig.Tools.cutterDurabiliy;
    }

    @Override
    public int getGuiID(ItemStack stack) {
        return stack.func_77952_i() == 3 ? 64 : -1;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        int[] link;
        if (ItemNBTHelper.hasKey(stack, "linkingPos") && (link = ItemNBTHelper.getIntArray(stack, "linkingPos")) != null && link.length > 3) {
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.attachedToDim", (Object[])new Object[]{link[1], link[2], link[3], link[0]}));
        }
        if (stack.func_77952_i() == 0) {
            int i;
            String s;
            NBTTagList tagList;
            if (ItemNBTHelper.hasKey(stack, "multiblockPermission")) {
                tagList = stack.func_77978_p().func_150295_c("multiblockPermission", 8);
                s = I18n.func_135052_a((String)"desc.immersiveengineering.info.multiblocksAllowed", (Object[])new Object[0]);
                if (!GuiScreen.func_146272_n()) {
                    list.add(s + " " + I18n.func_135052_a((String)"desc.immersiveengineering.info.holdShift", (Object[])new Object[0]));
                } else {
                    list.add(s);
                    for (i = 0; i < tagList.func_74745_c(); ++i) {
                        list.add(TextFormatting.DARK_GRAY + " " + I18n.func_135052_a((String)("desc.immersiveengineering.info.multiblock." + tagList.func_150307_f(i)), (Object[])new Object[0]));
                    }
                }
            }
            if (ItemNBTHelper.hasKey(stack, "multiblockInterdiction")) {
                tagList = stack.func_77978_p().func_150295_c("multiblockInterdiction", 8);
                s = I18n.func_135052_a((String)"desc.immersiveengineering.info.multiblockForbidden", (Object[])new Object[0]);
                if (!GuiScreen.func_146272_n()) {
                    list.add(s + " " + I18n.func_135052_a((String)"desc.immersiveengineering.info.holdShift", (Object[])new Object[0]));
                } else {
                    list.add(s);
                    for (i = 0; i < tagList.func_74745_c(); ++i) {
                        list.add(TextFormatting.DARK_GRAY + " " + I18n.func_135052_a((String)("desc.immersiveengineering.info.multiblock." + tagList.func_150307_f(i)), (Object[])new Object[0]));
                    }
                }
            }
        }
        if (flag.func_194127_a() && stack.func_77952_i() < 2) {
            int nbtDamage = ItemNBTHelper.getInt(stack, stack.func_77952_i() == 0 ? "hammerDmg" : "cutterDmg");
            int maxDamage = stack.func_77952_i() == 0 ? hammerMaxDamage : cutterMaxDamage;
            list.add("Durability: " + (maxDamage - nbtDamage) + " / " + maxDamage);
        }
    }

    public boolean hasContainerItem(ItemStack stack) {
        return stack.func_77952_i() < 2;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        int nbtDamage;
        if (stack.func_77952_i() == 0) {
            int nbtDamage2 = ItemNBTHelper.getInt(stack, "hammerDmg") + 1;
            if (nbtDamage2 < hammerMaxDamage) {
                ItemStack container = stack.func_77946_l();
                ItemNBTHelper.setInt(container, "hammerDmg", nbtDamage2);
                return container;
            }
        } else if (stack.func_77952_i() == 1 && (nbtDamage = ItemNBTHelper.getInt(stack, "cutterDmg") + 1) < cutterMaxDamage) {
            ItemStack container = stack.func_77946_l();
            ItemNBTHelper.setInt(container, "cutterDmg", nbtDamage);
            return container;
        }
        return ItemStack.field_190927_a;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        EnumActionResult ret = this.tryFormMB(player, world, pos, side, hand);
        if (world.field_72995_K && ret != EnumActionResult.PASS) {
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new CPacketPlayerTryUseItemOnBlock(pos, side, hand, hitX, hitY, hitZ));
        }
        return ret;
    }

    private EnumActionResult tryFormMB(EntityPlayer player, World world, BlockPos pos, EnumFacing side, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77960_j() == 0) {
            int i;
            NBTTagList list;
            String[] permittedMultiblocks = null;
            String[] interdictedMultiblocks = null;
            if (ItemNBTHelper.hasKey(stack, "multiblockPermission")) {
                list = stack.func_77978_p().func_150295_c("multiblockPermission", 8);
                permittedMultiblocks = new String[list.func_74745_c()];
                for (i = 0; i < permittedMultiblocks.length; ++i) {
                    permittedMultiblocks[i] = list.func_150307_f(i);
                }
            }
            if (ItemNBTHelper.hasKey(stack, "multiblockInterdiction")) {
                list = stack.func_77978_p().func_150295_c("multiblockInterdiction", 8);
                interdictedMultiblocks = new String[list.func_74745_c()];
                for (i = 0; i < interdictedMultiblocks.length; ++i) {
                    interdictedMultiblocks[i] = list.func_150307_f(i);
                }
            }
            for (MultiblockHandler.IMultiblock mb : MultiblockHandler.getMultiblocks()) {
                boolean b;
                if (!mb.isBlockTrigger(world.func_180495_p(pos))) continue;
                boolean bl = b = permittedMultiblocks == null;
                if (permittedMultiblocks != null) {
                    for (String s : permittedMultiblocks) {
                        if (!mb.getUniqueName().equalsIgnoreCase(s)) continue;
                        b = true;
                    }
                }
                if (!b) break;
                if (interdictedMultiblocks != null) {
                    for (String s : interdictedMultiblocks) {
                        if (!mb.getUniqueName().equalsIgnoreCase(s)) continue;
                        b = false;
                    }
                }
                if (!b) break;
                if (MultiblockHandler.postMultiblockFormationEvent(player, mb, pos, stack).isCanceled() || !mb.createStructure(world, pos, side, player)) continue;
                if (player instanceof EntityPlayerMP) {
                    IEAdvancements.TRIGGER_MULTIBLOCK.trigger((EntityPlayerMP)player, mb, stack);
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (stack.func_77952_i() == 0) {
            if (!(tileEntity instanceof IEBlockInterfaces.IDirectionalTile || tileEntity instanceof IEBlockInterfaces.IHammerInteraction || tileEntity instanceof IEBlockInterfaces.IConfigurableSides)) {
                return RotationUtil.rotateBlock(world, pos, side) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
            }
        } else {
            if (stack.func_77952_i() == 1 && tileEntity instanceof IImmersiveConnectable) {
                TargetingInfo target = new TargetingInfo(side, hitX, hitY, hitZ);
                BlockPos masterPos = ((IImmersiveConnectable)tileEntity).getConnectionMaster(null, target);
                if (!((tileEntity = world.func_175625_s(masterPos)) instanceof IImmersiveConnectable)) {
                    return EnumActionResult.PASS;
                }
                if (!world.field_72995_K) {
                    IImmersiveConnectable nodeHere = (IImmersiveConnectable)tileEntity;
                    boolean cut = ImmersiveNetHandler.INSTANCE.clearAllConnectionsFor(Utils.toCC(nodeHere), world, target);
                    IESaveData.setDirty(world.field_73011_w.getDimension());
                    if (cut) {
                        int nbtDamage = ItemNBTHelper.getInt(stack, "cutterDmg") + 1;
                        if (nbtDamage < cutterMaxDamage) {
                            ItemNBTHelper.setInt(stack, "cutterDmg", nbtDamage);
                        } else {
                            player.func_70669_a(stack);
                            player.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                        }
                    }
                }
                return EnumActionResult.SUCCESS;
            }
            if (stack.func_77952_i() == 2 && !world.field_72995_K) {
                if (!player.func_70093_af() && (tileEntity instanceof IFluxReceiver || tileEntity instanceof IFluxProvider)) {
                    int max = 0;
                    int stored = 0;
                    if (tileEntity instanceof IFluxReceiver) {
                        max = ((IFluxReceiver)tileEntity).getMaxEnergyStored(side);
                        stored = ((IFluxReceiver)tileEntity).getEnergyStored(side);
                    } else {
                        max = ((IFluxProvider)tileEntity).getMaxEnergyStored(side);
                        stored = ((IFluxProvider)tileEntity).getEnergyStored(side);
                    }
                    if (max > 0) {
                        ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.energyStorage", new Object[]{stored, max})});
                    }
                    return EnumActionResult.SUCCESS;
                }
                if (player.func_70093_af() && tileEntity instanceof IImmersiveConnectable) {
                    if (!ItemNBTHelper.hasKey(stack, "linkingPos")) {
                        ItemNBTHelper.setIntArray(stack, "linkingPos", new int[]{world.field_73011_w.getDimension(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
                    } else {
                        int[] array = ItemNBTHelper.getIntArray(stack, "linkingPos");
                        BlockPos linkPos = new BlockPos(array[1], array[2], array[3]);
                        TileEntity tileEntityLinkingPos = world.func_175625_s(linkPos);
                        if (array[0] == world.field_73011_w.getDimension()) {
                            IImmersiveConnectable nodeHere = (IImmersiveConnectable)tileEntity;
                            IImmersiveConnectable nodeLink = (IImmersiveConnectable)tileEntityLinkingPos;
                            if (nodeLink != null) {
                                Set<ImmersiveNetHandler.AbstractConnection> connections = ImmersiveNetHandler.INSTANCE.getIndirectEnergyConnections(Utils.toCC(nodeLink), world, true);
                                for (ImmersiveNetHandler.AbstractConnection con : connections) {
                                    if (!Utils.toCC(nodeHere).equals((Object)con.end)) continue;
                                    player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.info.averageLoss", new Object[]{Utils.formatDouble(con.getAverageLossRate() * 100.0f, "###.000")}));
                                }
                            }
                        }
                        ItemNBTHelper.remove(stack, "linkingPos");
                    }
                    return EnumActionResult.SUCCESS;
                }
            }
        }
        return EnumActionResult.PASS;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        return !player.field_70170_p.field_72995_K && stack.func_77952_i() == 0 && RotationUtil.rotateEntity((Entity)entity, player);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return stack.func_77952_i() == 0;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77952_i() == 3) {
            if (world.field_72995_K) {
                CommonProxy.openGuiForItem(player, hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        if (this.getToolClasses(stack).contains(toolClass)) {
            return 2;
        }
        return -1;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        if (stack.func_77952_i() == 0) {
            return ItemNBTHelper.getInt(stack, "hammerDmg") > 0;
        }
        if (stack.func_77952_i() == 1) {
            return ItemNBTHelper.getInt(stack, "cutterDmg") > 0;
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77952_i() == 0) {
            return (double)ItemNBTHelper.getInt(stack, "hammerDmg") / (double)hammerMaxDamage;
        }
        if (stack.func_77952_i() == 1) {
            return (double)ItemNBTHelper.getInt(stack, "cutterDmg") / (double)cutterMaxDamage;
        }
        return 0.0;
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        int meta = stack.func_77952_i();
        return meta == 0 ? ImmutableSet.of((Object)"IE_HAMMER") : (meta == 1 ? ImmutableSet.of((Object)"IE_WIRECUTTER") : new HashSet());
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        for (String type : this.getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(type, state)) continue;
            return 6.0f;
        }
        return super.func_150893_a(stack, state);
    }

    @Override
    public boolean isTool(ItemStack item) {
        return item.func_77952_i() != 3;
    }
}

