/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.crafting.IngredientFluidStack;
import blusunrize.immersiveengineering.common.crafting.IngredientIngrStack;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.regex.Pattern;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class RecipeShapedIngredient
extends ShapedOreRecipe {
    NonNullList<Ingredient> ingredientsQuarterTurn;
    NonNullList<Ingredient> ingredientsEighthTurn;
    int[] nbtCopyTargetSlot = null;
    Pattern nbtCopyPredicate = null;
    int lastMatch = 0;
    static int[] eighthTurnMap = new int[]{3, -1, -1, 3, 0, -3, 1, 1, -3};

    public RecipeShapedIngredient(ResourceLocation group, ItemStack result, Object ... recipe) {
        super(group, result, RecipeShapedIngredient.wrapIngredients(recipe));
    }

    public RecipeShapedIngredient(ResourceLocation group, ItemStack result, CraftingHelper.ShapedPrimer primer) {
        super(group, result, primer);
    }

    private static Object[] wrapIngredients(Object ... recipe) {
        Object[] out = new Object[recipe.length];
        for (int i = 0; i < recipe.length; ++i) {
            out[i] = recipe[i] instanceof IngredientStack ? new IngredientIngrStack((IngredientStack)recipe[i]) : recipe[i];
        }
        return out;
    }

    public RecipeShapedIngredient allowQuarterTurn() {
        this.ingredientsQuarterTurn = NonNullList.func_191197_a((int)this.func_192400_c().size(), (Object)Ingredient.field_193370_a);
        int maxH = this.height - 1;
        for (int h = 0; h < this.height; ++h) {
            for (int w = 0; w < this.width; ++w) {
                this.ingredientsQuarterTurn.set(w * this.height + (maxH - h), this.func_192400_c().get(h * this.width + w));
            }
        }
        return this;
    }

    public RecipeShapedIngredient allowEighthTurn() {
        if (this.width != 3 || this.height != 3) {
            return this;
        }
        this.ingredientsEighthTurn = NonNullList.func_191197_a((int)this.func_192400_c().size(), (Object)Ingredient.field_193370_a);
        int maxH = this.height - 1;
        for (int h = 0; h < this.height; ++h) {
            for (int w = 0; w < this.width; ++w) {
                int i = h * this.width + w;
                this.ingredientsEighthTurn.set(i + eighthTurnMap[i], this.func_192400_c().get(i));
            }
        }
        return this;
    }

    public RecipeShapedIngredient setNBTCopyTargetRecipe(int ... slot) {
        this.nbtCopyTargetSlot = slot;
        return this;
    }

    public RecipeShapedIngredient setNBTCopyPredicate(String pattern) {
        this.nbtCopyPredicate = Pattern.compile(pattern);
        return this;
    }

    public ItemStack func_77572_b(InventoryCrafting matrix) {
        if (this.nbtCopyTargetSlot != null) {
            ItemStack out = this.output.func_77946_l();
            NBTTagCompound tag = out.func_77942_o() ? out.func_77978_p() : new NBTTagCompound();
            for (int targetSlot : this.nbtCopyTargetSlot) {
                ItemStack s = matrix.func_70301_a(targetSlot);
                if (s.func_190926_b() || !s.func_77942_o()) continue;
                tag = ItemNBTHelper.combineTags(tag, s.func_77978_p(), this.nbtCopyPredicate);
            }
            if (!tag.func_82582_d()) {
                out.func_77982_d(tag);
            }
            return out;
        }
        return super.func_77572_b(matrix);
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList remains = ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
        for (int i = 0; i < this.height * this.width; ++i) {
            IFluidHandlerItem handler;
            NonNullList matchedIngr;
            ItemStack s = inv.func_70301_a(i);
            Object object = this.lastMatch == 1 ? this.ingredientsQuarterTurn : (matchedIngr = this.lastMatch == 2 ? this.ingredientsEighthTurn : this.input);
            if (((ItemStack)remains.get(i)).func_190926_b() && s.func_190926_b() || !(matchedIngr.get(i) instanceof IngredientFluidStack)) continue;
            if (((ItemStack)remains.get(i)).func_190926_b() && !s.func_190926_b()) {
                remains.set(i, (Object)Utils.copyStackWithAmount(s, 1));
            }
            if ((handler = FluidUtil.getFluidHandler((ItemStack)((ItemStack)remains.get(i)))) == null) continue;
            FluidStack fluid = ((IngredientFluidStack)((Object)matchedIngr.get(i))).getFluid();
            handler.drain(fluid.amount, true);
        }
        return remains;
    }

    protected boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        if (this.checkMatchDo(inv, (NonNullList<Ingredient>)this.func_192400_c(), startX, startY, mirror, false)) {
            this.lastMatch = 0;
            return true;
        }
        if (this.ingredientsQuarterTurn != null && this.checkMatchDo(inv, this.ingredientsQuarterTurn, startX, startY, mirror, true)) {
            this.lastMatch = 1;
            return true;
        }
        if (this.ingredientsEighthTurn != null && this.checkMatchDo(inv, this.ingredientsEighthTurn, startX, startY, mirror, false)) {
            this.lastMatch = 2;
            return true;
        }
        return false;
    }

    protected boolean checkMatchDo(InventoryCrafting inv, NonNullList<Ingredient> ingredients, int startX, int startY, boolean mirror, boolean rotate) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack slot;
                int subX = x - startX;
                int subY = y - startY;
                Ingredient target = null;
                if (!rotate) {
                    if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                        target = mirror ? (Ingredient)ingredients.get(this.width - subX - 1 + subY * this.width) : (Ingredient)ingredients.get(subX + subY * this.width);
                    }
                } else if (subX >= 0 && subY >= 0 && subX < this.height && subY < this.width) {
                    target = mirror ? (Ingredient)ingredients.get(this.height - subX - 1 + subY * this.width) : (Ingredient)ingredients.get(subY + subX * this.height);
                }
                if (target.apply(slot = inv.func_70463_b(x, y))) continue;
                return false;
            }
        }
        return true;
    }
}

