/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.items.ItemInternalStorage;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class TileEntityToolbox
extends TileEntityIEBase
implements IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IBlockBounds,
IIEInventory,
IEBlockInterfaces.IGuiTile,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IPlayerInteraction {
    NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    public String name;
    private EnumFacing facing = EnumFacing.NORTH;
    private NBTTagList enchantments;
    private static final float[] boundsZ = new float[]{0.125f, 0.0f, 0.25f, 0.875f, 0.625f, 0.75f};
    private static final float[] boundsX = new float[]{0.25f, 0.0f, 0.125f, 0.75f, 0.625f, 0.875f};

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        if (nbt.func_74764_b("name")) {
            this.name = nbt.func_74779_i("name");
        }
        if (nbt.func_74764_b("enchantments")) {
            this.enchantments = nbt.func_150295_c("enchantments", 10);
        }
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 27);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74768_a("facing", this.facing.ordinal());
        if (this.name != null) {
            nbt.func_74778_a("name", this.name);
        }
        if (this.enchantments != null) {
            nbt.func_74782_a("enchantments", (NBTBase)this.enchantments);
        }
        if (!descPacket) {
            nbt.func_74782_a("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
    }

    @Override
    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            if (!this.func_145831_w().field_72995_K) {
                EntityItem entityitem = new EntityItem(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, this.getTileDrop(player, this.func_145831_w().func_180495_p(this.func_174877_v())));
                entityitem.func_174869_p();
                this.func_145831_w().func_175698_g(this.func_174877_v());
                this.func_145831_w().func_72838_d((Entity)entityitem);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        return this.name != null ? new TextComponentString(this.name) : new TextComponentTranslation("item.immersiveengineering.toolbox.name", new Object[0]);
    }

    @Override
    public boolean canOpenGui() {
        return true;
    }

    @Override
    public int getGuiID() {
        return 16;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return IEApi.isAllowedInCrate(stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
    }

    @Override
    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack((Item)IEContent.itemToolbox);
        ((ItemInternalStorage)IEContent.itemToolbox).setContainedItems(stack, this.inventory);
        if (this.name != null) {
            stack.func_151001_c(this.name);
        }
        if (this.enchantments != null) {
            ItemNBTHelper.getTag(stack).func_74782_a("ench", (NBTBase)this.enchantments);
        }
        return stack;
    }

    @Override
    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemInternalStorage) {
            this.inventory = ((ItemInternalStorage)stack.func_77973_b()).getContainedItems(stack);
            if (stack.func_82837_s()) {
                this.name = stack.func_82833_r();
            }
            this.enchantments = stack.func_77986_q();
        }
    }

    @Override
    public boolean preventInventoryDrop() {
        return true;
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 2;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return true;
    }

    @Override
    public float[] getBlockBounds() {
        return this.facing.func_176740_k() == EnumFacing.Axis.Z ? boundsZ : boundsX;
    }
}

