/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.ThermoelectricHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;

public class TileEntityThermoelectricGen
extends TileEntityIEBase
implements ITickable,
EnergyHelper.IIEInternalFluxConnector {
    EnergyHelper.IEForgeEnergyWrapper wrapper = new EnergyHelper.IEForgeEnergyWrapper(this, null);

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int energy = 0;
            for (EnumFacing fd : new EnumFacing[]{EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.WEST}) {
                if (this.field_145850_b.func_175623_d(this.func_174877_v().func_177972_a(fd)) || this.field_145850_b.func_175623_d(this.func_174877_v().func_177972_a(fd.func_176734_d()))) continue;
                int temp0 = this.getTemperature(this.func_174877_v().func_177972_a(fd));
                int temp1 = this.getTemperature(this.func_174877_v().func_177972_a(fd.func_176734_d()));
                if (temp0 <= -1 || temp1 <= -1) continue;
                int diff = Math.abs(temp0 - temp1);
                energy += (int)(Math.sqrt(diff) / 2.0 * Config.IEConfig.Machines.thermoelectric_output);
            }
            this.outputEnergy(energy);
        }
    }

    public void outputEnergy(int amount) {
        for (EnumFacing fd : EnumFacing.field_82609_l) {
            TileEntity te = Utils.getExistingTileEntity(this.field_145850_b, this.func_174877_v().func_177972_a(fd));
            amount -= EnergyHelper.insertFlux(te, fd.func_176734_d(), amount, false);
        }
    }

    int getTemperature(BlockPos pos) {
        Fluid f = this.getFluid(pos);
        if (f != null) {
            return f.getTemperature(this.field_145850_b, pos);
        }
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        return ThermoelectricHandler.getTemperature(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
    }

    Fluid getFluid(BlockPos pos) {
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        Block b = state.func_177230_c();
        Fluid f = FluidRegistry.lookupFluidForBlock((Block)b);
        if (f == null && b instanceof BlockDynamicLiquid && b.func_176201_c(state) == 0) {
            if (state.func_185904_a().equals(Material.field_151586_h)) {
                f = FluidRegistry.WATER;
            } else if (state.func_185904_a().equals(Material.field_151587_i)) {
                f = FluidRegistry.LAVA;
            }
        }
        if (b instanceof IFluidBlock && !((IFluidBlock)b).canDrain(this.field_145850_b, pos)) {
            return null;
        }
        if (b instanceof BlockStaticLiquid && b.func_176201_c(state) != 0) {
            return null;
        }
        if (f == null) {
            return null;
        }
        return f;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
    }

    @Override
    @Nonnull
    public IEEnums.SideConfig getEnergySideConfig(@Nullable EnumFacing facing) {
        return IEEnums.SideConfig.OUTPUT;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(EnumFacing facing) {
        return this.wrapper;
    }
}

