/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityRazorWire
extends TileEntityImmersiveConnectable
implements IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IAdvancedCollisionBounds,
IOBJModelCallback<IBlockState> {
    public EnumFacing facing = EnumFacing.NORTH;

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("facing", this.facing.ordinal());
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 2;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return true;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return true;
    }

    @Override
    public void onEntityCollision(World world, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            entity.field_70159_w *= 0.2;
            entity.field_70179_y *= 0.2;
            int protection = (!((EntityLivingBase)entity).func_184582_a(EntityEquipmentSlot.FEET).func_190926_b() ? 1 : 0) + (!((EntityLivingBase)entity).func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b() ? 1 : 0);
            float dmg = protection == 2 ? 0.5f : (protection == 1 ? 1.0f : 1.5f);
            entity.func_70097_a(IEDamageSources.razorWire, dmg);
        }
    }

    @Override
    public float[] getBlockBounds() {
        return null;
    }

    @Override
    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        boolean wallL = this.renderWall(true);
        boolean wallR = this.renderWall(false);
        if (!this.isOnGround() || !wallL && !wallR) {
            return Collections.singletonList(null);
        }
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>(wallL && wallR ? 2 : 1);
        if (wallL) {
            list.add(new AxisAlignedBB(this.facing == EnumFacing.SOUTH ? 0.8125 : 0.0, 0.0, this.facing == EnumFacing.WEST ? 0.8125 : 0.0, this.facing == EnumFacing.NORTH ? 0.1875 : 1.0, 1.0, this.facing == EnumFacing.EAST ? 0.1875 : 1.0).func_186670_a(this.func_174877_v()));
        }
        if (wallR) {
            list.add(new AxisAlignedBB(this.facing == EnumFacing.NORTH ? 0.8125 : 0.0, 0.0, this.facing == EnumFacing.EAST ? 0.8125 : 0.0, this.facing == EnumFacing.SOUTH ? 0.1875 : 1.0, 1.0, this.facing == EnumFacing.WEST ? 0.1875 : 1.0).func_186670_a(this.func_174877_v()));
        }
        return list;
    }

    private boolean renderWall(boolean left) {
        EnumFacing dir = left ? this.facing.func_176746_e() : this.facing.func_176735_f();
        BlockPos neighbourPos = this.func_174877_v().func_177967_a(dir, -1);
        if (!this.field_145850_b.func_175667_e(neighbourPos)) {
            return true;
        }
        if (this.field_145850_b.func_175625_s(neighbourPos) instanceof TileEntityRazorWire) {
            return false;
        }
        IBlockState neighbour = this.field_145850_b.func_180495_p(neighbourPos);
        return !neighbour.isSideSolid((IBlockAccess)this.field_145850_b, neighbourPos, dir);
    }

    private boolean isOnGround() {
        BlockPos down = this.func_174877_v().func_177977_b();
        return this.field_145850_b.func_180495_p(down).isSideSolid((IBlockAccess)this.field_145850_b, down, EnumFacing.UP);
    }

    private boolean isStacked() {
        BlockPos down = this.func_174877_v().func_177977_b();
        TileEntity te = this.field_145850_b.func_175625_s(down);
        if (te instanceof TileEntityRazorWire) {
            return ((TileEntityRazorWire)te).isOnGround();
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureReplacement(IBlockState object, String material) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderGroup(IBlockState object, String group) {
        if (group == null) {
            return false;
        }
        boolean stack = this.isStacked();
        if (!stack && !this.isOnGround()) {
            return !group.startsWith("wood");
        }
        if (group.startsWith("wood") && group.endsWith("inverted") != stack) {
            return false;
        }
        if (group.startsWith("wood_left")) {
            return this.renderWall(true);
        }
        if ("wire_left".equals(group) || "barbs_left".equals(group)) {
            return !this.renderWall(true);
        }
        if (group.startsWith("wood_right")) {
            return this.renderWall(false);
        }
        if ("wire_right".equals(group) || "barbs_right".equals(group)) {
            return !this.renderWall(false);
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getCacheKey(IBlockState object) {
        boolean stack = this.isStacked();
        if (!stack && !this.isOnGround()) {
            return "default";
        }
        return (this.renderWall(true) ? "L" : " ") + (this.renderWall(false) ? "R" : " ") + (stack ? "_stack" : "");
    }

    @Override
    protected boolean canTakeLV() {
        return true;
    }

    @Override
    public boolean isEnergyOutput() {
        return true;
    }

    @Override
    public int outputEnergy(int amount, boolean simulate, int energyType) {
        if (amount > 0) {
            if (!simulate) {
                int maxReach = amount / 8;
                int widthP = 0;
                boolean connectP = true;
                int widthN = 0;
                boolean connectN = true;
                EnumFacing dir = this.facing.func_176746_e();
                if (dir.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
                    dir = dir.func_176734_d();
                }
                for (int i = 1; i <= maxReach; ++i) {
                    BlockPos posP = this.func_174877_v().func_177967_a(dir, i);
                    if (connectP && this.field_145850_b.func_175667_e(posP) && this.field_145850_b.func_175625_s(posP) instanceof TileEntityRazorWire) {
                        ++widthP;
                    } else {
                        connectP = false;
                    }
                    BlockPos posN = this.func_174877_v().func_177967_a(dir, -i);
                    if (connectN && this.field_145850_b.func_175667_e(posN) && this.field_145850_b.func_175625_s(posN) instanceof TileEntityRazorWire) {
                        ++widthN;
                        continue;
                    }
                    connectN = false;
                }
                AxisAlignedBB aabb = new AxisAlignedBB(this.func_174877_v().func_177982_a(this.facing.func_176740_k() == EnumFacing.Axis.Z ? -widthN : 0, 0, this.facing.func_176740_k() == EnumFacing.Axis.X ? -widthN : 0), this.func_174877_v().func_177982_a(this.facing.func_176740_k() == EnumFacing.Axis.Z ? 1 + widthP : 1, 1, this.facing.func_176740_k() == EnumFacing.Axis.X ? 1 + widthP : 1));
                List entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, aabb);
                for (EntityLivingBase ent : entities) {
                    ent.func_70097_a(IEDamageSources.razorShock, 2.0f);
                }
            }
            return 64;
        }
        return 0;
    }

    @Override
    public Vec3d getRaytraceOffset(IImmersiveConnectable link) {
        return new Vec3d(0.5, 1.0625, 0.5);
    }

    @Override
    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        boolean wallN;
        int yDif;
        int xDif;
        int n = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)Utils.toCC(this)) && con.end != null ? con.end.func_177958_n() - this.func_174877_v().func_177958_n() : (xDif = con.end.equals((Object)Utils.toCC(this)) && con.start != null ? con.start.func_177958_n() - this.func_174877_v().func_177958_n() : 0));
        int n2 = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)Utils.toCC(this)) && con.end != null ? con.end.func_177956_o() - this.func_174877_v().func_177956_o() : (yDif = con.end.equals((Object)Utils.toCC(this)) && con.start != null ? con.start.func_177956_o() - this.func_174877_v().func_177956_o() : 0));
        int zDif = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)Utils.toCC(this)) && con.end != null ? con.end.func_177952_p() - this.func_174877_v().func_177952_p() : (con.end.equals((Object)Utils.toCC(this)) && con.start != null ? con.start.func_177952_p() - this.func_174877_v().func_177952_p() : 0));
        boolean wallL = this.renderWall(true);
        boolean wallR = this.renderWall(false);
        if (!this.isOnGround() || !wallL && !wallR) {
            if (yDif > 0) {
                return new Vec3d(this.facing.func_82601_c() != 0 ? 0.5 : (xDif < 0 ? 0.40625 : 0.59375), 0.9375, this.facing.func_82599_e() != 0 ? 0.5 : (zDif < 0 ? 0.40625 : 0.59375));
            }
            boolean right = (float)this.facing.func_176746_e().func_176743_c().func_179524_a() == Math.copySign(1.0f, this.facing.func_82601_c() != 0 ? (float)zDif : (float)xDif);
            int faceX = this.facing.func_82601_c();
            int faceZ = this.facing.func_82599_e();
            return new Vec3d(faceX != 0 ? 0.5 + (right ? 0.0 : (double)faceX * 0.1875) : (double)(xDif >= 0 ? 1 : 0), 0.046875, faceZ != 0 ? 0.5 + (right ? 0.0 : (double)faceZ * 0.1875) : (double)(zDif >= 0 ? 1 : 0));
        }
        boolean bl = wallN = this.facing == EnumFacing.NORTH || this.facing == EnumFacing.EAST ? wallL : wallR;
        return new Vec3d(this.facing.func_82601_c() != 0 ? 0.5 : (xDif < 0 && wallN ? 0.125 : 0.875), 0.9375, this.facing.func_82599_e() != 0 ? 0.5 : (zDif < 0 && wallN ? 0.125 : 0.875));
    }
}

