/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockFermenter;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityFermenter
extends TileEntityMultiblockMetal<TileEntityFermenter, FermenterRecipe>
implements IEBlockInterfaces.IAdvancedSelectionBounds,
IEBlockInterfaces.IAdvancedCollisionBounds,
IEBlockInterfaces.IGuiTile {
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(24000)};
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)11, (Object)ItemStack.field_190927_a);
    IItemHandler insertionHandler = new IEInventoryHandler(8, (IIEInventory)this, 0, new boolean[]{true, true, true, true, true, true, true, true}, new boolean[8]);
    IItemHandler extractionHandler = new IEInventoryHandler(1, (IIEInventory)this, 8, new boolean[1], new boolean[]{true});

    public TileEntityFermenter() {
        super(MultiblockFermenter.instance, new int[]{3, 3, 3}, 16000, true);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank"));
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 11);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        NBTTagCompound tankTag = this.tanks[0].writeToNBT(new NBTTagCompound());
        nbt.func_74782_a("tank", (NBTBase)tankTag);
        if (!descPacket) {
            nbt.func_74782_a("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isDummy() || this.isRSDisabled()) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            BlockPos outputPos;
            TileEntity outputTile;
            EnumFacing fw;
            boolean update = false;
            if (this.energyStorage.getEnergyStored() > 0 && this.processQueue.size() < this.getProcessQueueMaxLength()) {
                int n;
                Integer[] process2;
                final int[] usedInvSlots = new int[8];
                for (Integer[] process2 : this.processQueue) {
                    if (!(process2 instanceof TileEntityMultiblockMetal.MultiblockProcessInMachine)) continue;
                    int[] nArray = ((TileEntityMultiblockMetal.MultiblockProcessInMachine)process2).inputSlots;
                    n = nArray.length;
                    for (int i = 0; i < n; ++i) {
                        int i2;
                        int n2 = i2 = nArray[i];
                        usedInvSlots[n2] = usedInvSlots[n2] + 1;
                    }
                }
                Integer[] preferredSlots = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7};
                Arrays.sort(preferredSlots, 0, 8, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer arg0, Integer arg1) {
                        return Integer.compare(usedInvSlots[arg0], usedInvSlots[arg1]);
                    }
                });
                process2 = preferredSlots;
                int n3 = process2.length;
                for (n = 0; n < n3; ++n) {
                    TileEntityMultiblockMetal.MultiblockProcessInMachine<FermenterRecipe> process3;
                    FermenterRecipe recipe;
                    int slot = process2[n];
                    ItemStack stack = (ItemStack)this.getInventory().get(slot);
                    if (!stack.func_190926_b()) {
                        stack = stack.func_77946_l();
                        stack.func_190918_g(usedInvSlots[slot]);
                    }
                    if (stack.func_190926_b() || stack.func_190916_E() <= 0 || (recipe = this.findRecipeForInsertion(stack)) == null || !this.addProcessToQueue(process3 = new TileEntityMultiblockMetal.MultiblockProcessInMachine<FermenterRecipe>(recipe, slot), true)) continue;
                    this.addProcessToQueue(process3, false);
                    update = true;
                }
            }
            EnumFacing enumFacing = fw = this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e();
            if (this.tanks[0].getFluidAmount() > 0) {
                ItemStack full;
                ItemStack empty;
                int accepted;
                FluidStack out = Utils.copyFluidStackWithAmount(this.tanks[0].getFluid(), Math.min(this.tanks[0].getFluidAmount(), 80), false);
                BlockPos outputPos2 = this.func_174877_v().func_177982_a(0, -1, 0).func_177967_a(fw, 2);
                IFluidHandler output = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)outputPos2, (EnumFacing)fw.func_176734_d());
                if (output != null && (accepted = output.fill(out, false)) > 0) {
                    int drained = output.fill(Utils.copyFluidStackWithAmount(out, Math.min(out.amount, accepted), false), true);
                    this.tanks[0].drain(drained, true);
                    update = true;
                }
                if (!(empty = (ItemStack)this.getInventory().get(9)).func_190926_b() && this.tanks[0].getFluidAmount() > 0 && !(full = Utils.fillFluidContainer((IFluidHandler)this.tanks[0], empty, (ItemStack)this.getInventory().get(10), null)).func_190926_b()) {
                    if (!((ItemStack)this.getInventory().get(10)).func_190926_b() && OreDictionary.itemMatches((ItemStack)full, (ItemStack)((ItemStack)this.getInventory().get(10)), (boolean)true)) {
                        ((ItemStack)this.getInventory().get(10)).func_190917_f(full.func_190916_E());
                    } else {
                        this.getInventory().set(10, (Object)full);
                    }
                    ((ItemStack)this.inventory.get(9)).func_190918_g(1);
                    if (((ItemStack)this.inventory.get(9)).func_190916_E() <= 0) {
                        this.inventory.set(9, (Object)ItemStack.field_190927_a);
                    }
                }
            }
            if (!((ItemStack)this.inventory.get(8)).func_190926_b() && this.field_145850_b.func_82737_E() % 8L == 0L && (outputTile = Utils.getExistingTileEntity(this.field_145850_b, outputPos = this.func_174877_v().func_177972_a(fw))) != null) {
                ItemStack stack = Utils.copyStackWithAmount((ItemStack)this.inventory.get(8), 1);
                if ((stack = Utils.insertStackIntoInventory(outputTile, stack, fw.func_176734_d())).func_190926_b()) {
                    ((ItemStack)this.inventory.get(8)).func_190918_g(1);
                    if (((ItemStack)this.inventory.get(8)).func_190916_E() <= 0) {
                        this.inventory.set(8, (Object)ItemStack.field_190927_a);
                    }
                }
            }
            if (update) {
                this.func_70296_d();
                this.markContainingBlockForUpdate(null);
            }
        }
    }

    @Override
    public float[] getBlockBounds() {
        if (this.field_174879_c > 0 && this.field_174879_c < 9 && this.field_174879_c != 5) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f};
        }
        if (this.field_174879_c == 11) {
            return new float[]{this.facing == EnumFacing.WEST ? 0.5f : 0.0f, 0.0f, this.facing == EnumFacing.NORTH ? 0.5f : 0.0f, this.facing == EnumFacing.EAST ? 0.5f : 1.0f, 1.0f, this.facing == EnumFacing.SOUTH ? 0.5f : 1.0f};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        EnumFacing fl = this.facing;
        EnumFacing fw = this.facing.func_176746_e();
        if (this.mirrored) {
            fw = fw.func_176734_d();
        }
        if (this.field_174879_c == 2) {
            float minZ;
            float maxX;
            float minX;
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            float f = fl == EnumFacing.WEST ? 0.625f : (minX = fl == EnumFacing.EAST ? 0.125f : 0.125f);
            float f2 = fl == EnumFacing.EAST ? 0.375f : (maxX = fl == EnumFacing.WEST ? 0.875f : 0.25f);
            float f3 = fl == EnumFacing.NORTH ? 0.625f : (minZ = fl == EnumFacing.SOUTH ? 0.125f : 0.125f);
            float maxZ = fl == EnumFacing.SOUTH ? 0.375f : (fl == EnumFacing.NORTH ? 0.875f : 0.25f);
            list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            float f4 = fl == EnumFacing.WEST ? 0.625f : (minX = fl == EnumFacing.EAST ? 0.125f : 0.75f);
            float f5 = fl == EnumFacing.EAST ? 0.375f : (maxX = fl == EnumFacing.WEST ? 0.875f : 0.875f);
            float f6 = fl == EnumFacing.NORTH ? 0.625f : (minZ = fl == EnumFacing.SOUTH ? 0.125f : 0.75f);
            maxZ = fl == EnumFacing.SOUTH ? 0.375f : (fl == EnumFacing.NORTH ? 0.875f : 0.875f);
            list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        if (this.field_174879_c == 3 || this.field_174879_c == 4 || this.field_174879_c == 6 || this.field_174879_c == 7) {
            float minZ;
            float maxX;
            float minX;
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            if (this.field_174879_c > 5) {
                fl = fl.func_176734_d();
            }
            if (this.field_174879_c % 3 == 1) {
                fw = fw.func_176734_d();
            }
            float f = fl == EnumFacing.WEST ? 0.6875f : (fl == EnumFacing.EAST ? 0.0625f : (minX = fw == EnumFacing.EAST ? 0.0625f : 0.6875f));
            float f7 = fl == EnumFacing.EAST ? 0.3125f : (fl == EnumFacing.WEST ? 0.9375f : (maxX = fw == EnumFacing.EAST ? 0.3125f : 0.9375f));
            float f8 = fl == EnumFacing.NORTH ? 0.6875f : (fl == EnumFacing.SOUTH ? 0.0625f : (minZ = fw == EnumFacing.SOUTH ? 0.0625f : 0.6875f));
            float maxZ = fl == EnumFacing.SOUTH ? 0.3125f : (fl == EnumFacing.NORTH ? 0.9375f : (fw == EnumFacing.SOUTH ? 0.3125f : 0.9375f));
            list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 1.1875, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            if (this.field_174879_c == 4) {
                float f9 = fl == EnumFacing.WEST ? 0.375f : (fl == EnumFacing.EAST ? 0.625f : (minX = fw == EnumFacing.WEST ? -0.125f : 0.0f));
                float f10 = fl == EnumFacing.EAST ? 0.375f : (fl == EnumFacing.WEST ? 0.625f : (maxX = fw == EnumFacing.EAST ? 1.125f : 1.0f));
                float f11 = fl == EnumFacing.NORTH ? 0.375f : (fl == EnumFacing.SOUTH ? 0.625f : (minZ = fw == EnumFacing.NORTH ? -0.125f : 0.0f));
                maxZ = fl == EnumFacing.SOUTH ? 0.375f : (fl == EnumFacing.NORTH ? 0.625f : (fw == EnumFacing.SOUTH ? 1.125f : 1.0f));
                list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 0.75, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                float f12 = fl == EnumFacing.WEST ? -0.125f : (fl == EnumFacing.EAST ? 0.625f : (minX = fw == EnumFacing.WEST ? -0.125f : 0.875f));
                float f13 = fl == EnumFacing.EAST ? 1.125f : (fl == EnumFacing.WEST ? 0.375f : (maxX = fw == EnumFacing.EAST ? 1.125f : 0.125f));
                float f14 = fl == EnumFacing.NORTH ? -0.125f : (fl == EnumFacing.SOUTH ? 0.625f : (minZ = fw == EnumFacing.NORTH ? -0.125f : 0.875f));
                maxZ = fl == EnumFacing.SOUTH ? 1.25f : (fl == EnumFacing.NORTH ? 0.375f : (fw == EnumFacing.SOUTH ? 1.125f : 0.125f));
                list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 0.75, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                float f15 = fl == EnumFacing.WEST ? -0.125f : (fl == EnumFacing.EAST ? 0.875f : (minX = fw == EnumFacing.WEST ? -0.125f : 0.875f));
                float f16 = fl == EnumFacing.EAST ? 1.125f : (fl == EnumFacing.WEST ? 0.125f : (maxX = fw == EnumFacing.EAST ? 1.125f : 0.125f));
                float f17 = fl == EnumFacing.NORTH ? -0.125f : (fl == EnumFacing.SOUTH ? 0.875f : (minZ = fw == EnumFacing.NORTH ? -0.125f : 0.875f));
                maxZ = fl == EnumFacing.SOUTH ? 1.25f : (fl == EnumFacing.NORTH ? 0.125f : (fw == EnumFacing.SOUTH ? 1.125f : 0.125f));
                list.add(new AxisAlignedBB((double)minX, 0.75, (double)minZ, (double)maxX, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            }
            return list;
        }
        if (this.field_174879_c == 12 || this.field_174879_c == 13 || this.field_174879_c == 15 || this.field_174879_c == 16 || this.field_174879_c == 21 || this.field_174879_c == 22 || this.field_174879_c == 24 || this.field_174879_c == 25) {
            float minZ;
            float maxX;
            float minX;
            float maxY;
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>(2);
            if (this.field_174879_c % 9 > 5) {
                fl = fl.func_176734_d();
            }
            if (this.field_174879_c % 3 == 1) {
                fw = fw.func_176734_d();
            }
            float minY = this.field_174879_c < 18 ? 0.1875f : -0.8125f;
            float f = maxY = this.field_174879_c < 18 ? 2.0f : 1.0f;
            float f18 = fl == EnumFacing.WEST ? 0.0f : (fl == EnumFacing.EAST ? 0.0625f : (minX = fw == EnumFacing.EAST ? 0.0625f : 0.0f));
            float f19 = fl == EnumFacing.EAST ? 1.0f : (fl == EnumFacing.WEST ? 0.9375f : (maxX = fw == EnumFacing.EAST ? 1.0f : 0.9375f));
            float f20 = fl == EnumFacing.NORTH ? 0.0f : (fl == EnumFacing.SOUTH ? 0.0625f : (minZ = fw == EnumFacing.SOUTH ? 0.0625f : 0.0f));
            float maxZ = fl == EnumFacing.SOUTH ? 1.0f : (fl == EnumFacing.NORTH ? 0.9375f : (fw == EnumFacing.SOUTH ? 1.0f : 0.9375f));
            list.add(new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        return null;
    }

    @Override
    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list) {
        return false;
    }

    @Override
    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        return this.getAdvancedSelectionBounds();
    }

    @Override
    public int[] getEnergyPos() {
        return new int[]{9};
    }

    @Override
    public int[] getRedstonePos() {
        return new int[]{11};
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Override
    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<FermenterRecipe> process) {
        return true;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        BlockPos pos = this.func_174877_v().func_177967_a(this.facing, 2);
        TileEntity inventoryTile = this.field_145850_b.func_175625_s(pos);
        if (inventoryTile != null) {
            output = Utils.insertStackIntoInventory(inventoryTile, output, this.facing.func_176734_d());
        }
        if (!output.func_190926_b()) {
            Utils.dropStackAtPos(this.field_145850_b, pos, output, this.facing);
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<FermenterRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 8;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 8;
    }

    @Override
    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<FermenterRecipe> process) {
        return 0.0f;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{8};
    }

    @Override
    public int[] getOutputTanks() {
        return new int[]{0};
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        TileEntityFermenter master = (TileEntityFermenter)this.master();
        if (master != null && this.field_174879_c == 5 && (side == null || side == (this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e()))) {
            return master.tanks;
        }
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resources) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return true;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if ((this.field_174879_c == 15 || this.field_174879_c == 13) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if ((this.field_174879_c == 15 || this.field_174879_c == 13) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntityFermenter master = (TileEntityFermenter)this.master();
            if (master == null) {
                return null;
            }
            if (this.field_174879_c == 15) {
                return (T)master.insertionHandler;
            }
            if (this.field_174879_c == 13) {
                return (T)master.extractionHandler;
            }
            return null;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public FermenterRecipe findRecipeForInsertion(ItemStack inserting) {
        return FermenterRecipe.findRecipe(inserting);
    }

    @Override
    protected FermenterRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return FermenterRecipe.loadFromNBT(tag);
    }

    @Override
    public boolean canOpenGui() {
        return this.formed;
    }

    @Override
    public int getGuiID() {
        return 8;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this.master();
    }
}

