/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorRedstone;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityConnectorProbe
extends TileEntityConnectorRedstone {
    private int redstoneChannelSending = 0;
    private int lastOutput = 0;

    @Override
    public void func_73660_a() {
        int out;
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 8L != (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 8) && (out = this.getComparatorSignal()) != this.lastOutput) {
            this.lastOutput = out;
            this.rsDirty = true;
        }
        super.func_73660_a();
    }

    @Override
    public boolean isRSInput() {
        return true;
    }

    @Override
    public boolean isRSOutput() {
        return true;
    }

    private int getComparatorSignal() {
        BlockPos pos = this.func_174877_v().func_177972_a(this.facing);
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        if (state.func_185912_n()) {
            return state.func_185888_a(this.field_145850_b, pos);
        }
        if (state.func_185915_l()) {
            EntityItemFrame entityitemframe;
            state = this.field_145850_b.func_180495_p(pos = pos.func_177972_a(this.facing));
            if (state.func_185912_n()) {
                return state.func_185888_a(this.field_145850_b, pos);
            }
            if (state.func_185904_a() == Material.field_151579_a && (entityitemframe = this.findItemFrame(this.field_145850_b, this.facing, pos)) != null) {
                return entityitemframe.func_174866_q();
            }
        }
        return 0;
    }

    private EntityItemFrame findItemFrame(World world, EnumFacing facing, BlockPos pos) {
        List list = world.func_175647_a(EntityItemFrame.class, new AxisAlignedBB(pos), entity -> entity != null && entity.func_174811_aO() == facing);
        return list.size() == 1 ? (EntityItemFrame)list.get(0) : null;
    }

    @Override
    public void updateInput(byte[] signals) {
        signals[this.redstoneChannelSending] = (byte)Math.max(this.lastOutput, signals[this.redstoneChannelSending]);
        this.rsDirty = false;
    }

    @Override
    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            this.redstoneChannel = (this.redstoneChannel + 1) % 16;
        } else {
            this.redstoneChannelSending = (this.redstoneChannelSending + 1) % 16;
        }
        this.func_70296_d();
        this.wireNetwork.updateValues();
        this.onChange();
        this.markContainingBlockForUpdate(null);
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 254, 0);
        return true;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("redstoneChannelSending", this.redstoneChannelSending);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.redstoneChannelSending = nbt.func_74762_e("redstoneChannelSending");
    }

    @Override
    public Vec3d getRaytraceOffset(IImmersiveConnectable link) {
        EnumFacing side = this.facing.func_176734_d();
        return new Vec3d(0.5 + (double)side.func_82601_c() * 0.375, 0.5 + (double)side.func_96559_d() * 0.375, 0.5 + (double)side.func_82599_e() * 0.375);
    }

    @Override
    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        EnumFacing side = this.facing.func_176734_d();
        double conRadius = con.cableType.getRenderDiameter() / 2.0;
        return new Vec3d(0.5 + (double)side.func_82601_c() * (0.375 - conRadius), 0.5 + (double)side.func_96559_d() * (0.375 - conRadius), 0.5 + (double)side.func_82599_e() * (0.375 - conRadius));
    }

    @Override
    public float[] getBlockBounds() {
        float wMin = 0.28125f;
        float wMax = 0.71875f;
        switch (this.facing.func_176734_d()) {
            case UP: 
            case DOWN: {
                return new float[]{wMin, 0.0f, wMin, wMax, 1.0f, wMax};
            }
            case SOUTH: 
            case NORTH: {
                return new float[]{wMin, wMin, 0.0f, wMax, wMax, 1.0f};
            }
            case EAST: 
            case WEST: {
                return new float[]{0.0f, wMin, wMin, 1.0f, wMax, wMax};
            }
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureReplacement(IBlockState object, String material) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderGroup(IBlockState object, String group) {
        if (MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.SOLID) {
            return false;
        }
        if ("glass".equals(group)) {
            return MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.TRANSLUCENT;
        }
        return MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.CUTOUT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getRenderColour(IBlockState object, String group) {
        if ("colour_in".equals(group)) {
            return 0xFF000000 | EnumDyeColor.func_176764_b((int)this.redstoneChannel).func_193350_e();
        }
        if ("colour_out".equals(group)) {
            return 0xFF000000 | EnumDyeColor.func_176764_b((int)this.redstoneChannelSending).func_193350_e();
        }
        return -1;
    }

    @Override
    public String getCacheKey(IBlockState object) {
        return this.redstoneChannel + ";" + this.redstoneChannelSending;
    }

    @Override
    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer) {
        if (!hammer) {
            return null;
        }
        return new String[]{I18n.func_135052_a((String)"desc.immersiveengineering.info.redstoneChannel.rec", (Object[])new Object[]{I18n.func_135052_a((String)("item.fireworksCharge." + EnumDyeColor.func_176764_b((int)this.redstoneChannel).func_176762_d()), (Object[])new Object[0])}), I18n.func_135052_a((String)"desc.immersiveengineering.info.redstoneChannel.send", (Object[])new Object[]{I18n.func_135052_a((String)("item.fireworksCharge." + EnumDyeColor.func_176764_b((int)this.redstoneChannelSending).func_176762_d()), (Object[])new Object[0])})};
    }

    @Override
    public boolean useNixieFont(EntityPlayer player, RayTraceResult mop) {
        return false;
    }
}

