/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockAutoWorkbench;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityAutoWorkbench
extends TileEntityMultiblockMetal<TileEntityAutoWorkbench, IMultiblockRecipe>
implements IEBlockInterfaces.IGuiTile,
ConveyorHandler.IConveyorAttachable {
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)17, (Object)ItemStack.field_190927_a);
    public int selectedRecipe = -1;
    IItemHandler insertionHandler = new IEInventoryHandler(16, (IIEInventory)this, 1, true, false);

    public TileEntityAutoWorkbench() {
        super(MultiblockAutoWorkbench.instance, new int[]{2, 3, 3}, 32000, true);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.selectedRecipe = nbt.func_74762_e("selectedRecipe");
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 17);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("selectedRecipe", this.selectedRecipe);
        nbt.func_74782_a("inventory", (NBTBase)Utils.writeInventory(this.inventory));
    }

    @Override
    public void receiveMessageFromClient(NBTTagCompound message) {
        if (message.func_74764_b("recipe")) {
            this.selectedRecipe = message.func_74762_e("recipe");
        }
    }

    @Override
    public void func_73660_a() {
        BlueprintCraftingRecipe recipe;
        super.func_73660_a();
        if (this.isDummy() || this.isRSDisabled() || this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 16L != (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0xF) || ((ItemStack)this.inventory.get(0)).func_190926_b()) {
            return;
        }
        BlueprintCraftingRecipe[] recipes = BlueprintCraftingRecipe.findRecipes(ItemNBTHelper.getString((ItemStack)this.inventory.get(0), "blueprint"));
        if (recipes.length > 0 && this.selectedRecipe >= 0 && this.selectedRecipe < recipes.length && (recipe = recipes[this.selectedRecipe]) != null && !recipe.output.func_190926_b()) {
            NonNullList query = NonNullList.func_191197_a((int)16, (Object)ItemStack.field_190927_a);
            for (int i = 0; i < query.size(); ++i) {
                query.set(i, this.inventory.get(i + 1));
            }
            int crafted = recipe.getMaxCrafted((NonNullList<ItemStack>)query);
            if (crafted > 0 && this.addProcessToQueue(new TileEntityMultiblockMetal.MultiblockProcessInWorld<BlueprintCraftingRecipe>(recipe, 0.78f, (NonNullList<ItemStack>)NonNullList.func_191196_a()), true)) {
                this.addProcessToQueue(new TileEntityMultiblockMetal.MultiblockProcessInWorld<BlueprintCraftingRecipe>(recipe, 0.78f, recipe.consumeInputs((NonNullList<ItemStack>)query, 1)), false);
                for (int i = 0; i < query.size(); ++i) {
                    this.inventory.set(i + 1, query.get(i));
                }
                this.func_70296_d();
                this.markContainingBlockForUpdate(null);
            }
        }
    }

    @Override
    public float[] getBlockBounds() {
        if (this.field_174879_c < 10 || this.field_174879_c == 12) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        if (this.field_174879_c >= 13 && this.field_174879_c <= 16) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f};
        }
        float xMin = 0.0f;
        float yMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float yMax = 1.0f;
        float zMax = 1.0f;
        if (this.field_174879_c == 10 || this.field_174879_c == 11) {
            yMax = 0.8125f;
            if (this.facing == EnumFacing.NORTH) {
                zMin = 0.1875f;
                if (this.field_174879_c == 11) {
                    xMax = 0.875f;
                }
            } else if (this.facing == EnumFacing.SOUTH) {
                zMax = 0.8125f;
                if (this.field_174879_c == 11) {
                    xMin = 0.125f;
                }
            } else if (this.facing == EnumFacing.WEST) {
                xMin = 0.1875f;
                if (this.field_174879_c == 11) {
                    zMin = 0.125f;
                }
            } else if (this.facing == EnumFacing.EAST) {
                xMax = 0.8125f;
                if (this.field_174879_c == 11) {
                    zMax = 0.875f;
                }
            }
        }
        if (this.field_174879_c == 17) {
            yMax = 0.3125f;
            if (this.facing == EnumFacing.NORTH) {
                zMin = 0.25f;
                xMax = 0.875f;
            } else if (this.facing == EnumFacing.SOUTH) {
                zMax = 0.75f;
                xMin = 0.125f;
            } else if (this.facing == EnumFacing.WEST) {
                xMin = 0.25f;
                zMin = 0.125f;
            } else if (this.facing == EnumFacing.EAST) {
                xMax = 0.75f;
                zMax = 0.875f;
            }
        }
        return new float[]{xMin, yMin, zMin, xMax, yMax, zMax};
    }

    @Override
    public int[] getEnergyPos() {
        return new int[]{9};
    }

    @Override
    public int[] getRedstonePos() {
        return new int[]{1};
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return true;
    }

    @Override
    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return true;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        EnumFacing outDir = this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e();
        BlockPos pos = this.func_174877_v().func_177967_a(outDir, 2);
        TileEntity inventoryTile = this.field_145850_b.func_175625_s(pos);
        if (inventoryTile != null) {
            output = Utils.insertStackIntoInventory(inventoryTile, output, outDir.func_176734_d());
        }
        if (!output.func_190926_b()) {
            Utils.dropStackAtPos(this.field_145850_b, pos, output, outDir);
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 3;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 3;
    }

    @Override
    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return 0.4375f;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return null;
    }

    @Override
    public int[] getOutputTanks() {
        return new int[0];
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return null;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.field_174879_c == 9 && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.field_174879_c == 9 && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntityAutoWorkbench master = (TileEntityAutoWorkbench)this.master();
            if (master == null) {
                return null;
            }
            return (T)master.insertionHandler;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public IMultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected IMultiblockRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return BlueprintCraftingRecipe.loadFromNBT(tag);
    }

    @Override
    public boolean canOpenGui() {
        return this.formed;
    }

    @Override
    public int getGuiID() {
        return 11;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this.master();
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource) {
        return true;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return true;
    }

    @Override
    public EnumFacing[] sigOutputDirections() {
        if (this.field_174879_c == 14) {
            return new EnumFacing[]{this.facing.func_176746_e()};
        }
        return new EnumFacing[0];
    }
}

