/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWindmill;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;

public class TileRenderWindmill
extends TileEntitySpecialRenderer<TileEntityWindmill> {
    private List<BakedQuad>[] quads = new List[9];
    private static WeakHashMap<TileRenderWindmill, Boolean> instances = new WeakHashMap();

    public TileRenderWindmill() {
        instances.put(this, true);
    }

    public void render(TileEntityWindmill tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (!tile.func_145831_w().func_175668_a(tile.func_174877_v(), false)) {
            return;
        }
        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        BlockPos blockPos = tile.func_174877_v();
        if (this.quads[tile.sails] == null) {
            IBlockState state = this.func_178459_a().func_180495_p(blockPos);
            state = state.func_185899_b((IBlockAccess)this.func_178459_a(), blockPos);
            state = state.func_177226_a((IProperty)IEProperties.FACING_ALL, (Comparable)EnumFacing.NORTH);
            IBakedModel model = blockRenderer.func_175023_a().func_178125_b(state);
            if (state instanceof IExtendedBlockState) {
                ArrayList<String> parts = new ArrayList<String>();
                parts.add("base");
                for (int i = 1; i <= tile.sails; ++i) {
                    parts.add("sail_" + i);
                }
                state = ((IExtendedBlockState)state).withProperty(Properties.AnimationProperty, (Object)new OBJModel.OBJState(parts, true));
            }
            this.quads[tile.sails] = model.func_188616_a(state, null, 0L);
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        float dir = tile.facing == EnumFacing.SOUTH ? 0.0f : (tile.facing == EnumFacing.NORTH ? 180.0f : (tile.facing == EnumFacing.EAST ? 90.0f : -90.0f));
        float rot = 360.0f * (tile.rotation + (!tile.canTurn || tile.rotation == 0.0f ? 0.0f : partialTicks) * tile.perTick);
        if (tile.facing.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
            rot *= -1.0f;
        }
        GlStateManager.func_179114_b((float)rot, (float)(tile.facing.func_176740_k() == EnumFacing.Axis.X ? 1.0f : 0.0f), (float)0.0f, (float)(tile.facing.func_176740_k() == EnumFacing.Axis.Z ? 1.0f : 0.0f));
        GlStateManager.func_179114_b((float)dir, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74518_a();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        worldRenderer.func_178969_c(-0.5, -0.5, -0.5);
        ClientUtils.renderModelTESRFast(this.quads[tile.sails], worldRenderer, tile.func_145831_w(), blockPos);
        worldRenderer.func_178969_c(0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        RenderHelper.func_74519_b();
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
    }

    public static void reset() {
        for (TileRenderWindmill r : instances.keySet()) {
            for (int i = 0; i < r.quads.length; ++i) {
                r.quads[i] = null;
            }
        }
    }
}

