/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveengineering.MetalPress")
public class MetalPress {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input, IItemStack mold, int energy, @Optional int inputSize) {
        Object oInput = CraftTweakerHelper.toObject(input);
        if (oInput == null) {
            return;
        }
        ItemStack sOut = CraftTweakerHelper.toStack(output);
        ItemStack sMold = CraftTweakerHelper.toStack(mold);
        if (!sOut.func_190926_b() && !sMold.func_190926_b()) {
            MetalPressRecipe r = new MetalPressRecipe(sOut, oInput, sMold, energy);
            if (inputSize > 0) {
                r.setInputSize(inputSize);
            }
            MineTweakerAPI.apply((IUndoableAction)new Add(r));
        }
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(CraftTweakerHelper.toStack(output)));
    }

    @ZenMethod
    public static void removeRecipeByMold(IItemStack mold) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveByMold(CraftTweakerHelper.toStack(mold)));
    }

    private static class RemoveByMold
    implements IUndoableAction {
        private final ComparableItemStack mold;
        List<MetalPressRecipe> removedRecipes;

        public RemoveByMold(ItemStack mold) {
            this.mold = ApiUtils.createComparableItemStack(mold);
        }

        public void apply() {
            this.removedRecipes = new ArrayList<MetalPressRecipe>(MetalPressRecipe.recipeList.get((Object)this.mold));
            MetalPressRecipe.recipeList.removeAll((Object)this.mold);
            for (MetalPressRecipe recipe : this.removedRecipes) {
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)recipe);
            }
        }

        public void undo() {
            if (this.removedRecipes != null) {
                MetalPressRecipe.recipeList.putAll((Object)this.mold, this.removedRecipes);
                for (MetalPressRecipe recipe : this.removedRecipes) {
                    MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)recipe);
                }
            }
        }

        public String describe() {
            return "Removing Metal Press Recipes for Mold: " + this.mold.stack.func_82833_r();
        }

        public String describeUndo() {
            return "Re-Adding Metal Press Recipes for Mold: " + this.mold.stack.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    private static class Remove
    implements IUndoableAction {
        private final ItemStack output;
        List<MetalPressRecipe> removedRecipes;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            this.removedRecipes = MetalPressRecipe.removeRecipes(this.output);
            for (MetalPressRecipe recipe : this.removedRecipes) {
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)recipe);
            }
        }

        public void undo() {
            if (this.removedRecipes != null) {
                for (MetalPressRecipe recipe : this.removedRecipes) {
                    if (recipe == null) continue;
                    MetalPressRecipe.recipeList.put((Object)recipe.mold, (Object)recipe);
                    MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)recipe);
                }
            }
        }

        public String describe() {
            return "Removing Metal Press Recipes for " + this.output.func_82833_r();
        }

        public String describeUndo() {
            return "Re-Adding Metal Press Recipes for " + this.output.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    private static class Add
    implements IUndoableAction {
        private final MetalPressRecipe recipe;

        public Add(MetalPressRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            MetalPressRecipe.recipeList.put((Object)this.recipe.mold, (Object)this.recipe);
            MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            MetalPressRecipe.recipeList.remove((Object)this.recipe.mold, (Object)this.recipe);
            MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)this.recipe);
        }

        public String describe() {
            return "Adding Metal Press Recipe for " + this.recipe.output.func_82833_r();
        }

        public String describeUndo() {
            return "Removing Metal Press Recipe for " + this.recipe.output.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

