/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import java.util.ArrayList;
import java.util.Iterator;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveengineering.Fermenter")
public class Fermenter {
    @ZenMethod
    public static void addRecipe(IItemStack output, ILiquidStack fluid, IIngredient input, int energy) {
        if (CraftTweakerHelper.toObject(input) == null) {
            return;
        }
        if (CraftTweakerHelper.toStack(output).func_190926_b() && (CraftTweakerHelper.toFluidStack(fluid) == null || CraftTweakerHelper.toFluidStack(fluid).getFluid() == null)) {
            return;
        }
        FermenterRecipe r = new FermenterRecipe(CraftTweakerHelper.toFluidStack(fluid), CraftTweakerHelper.toStack(output), CraftTweakerHelper.toObject(input), energy);
        MineTweakerAPI.apply((IUndoableAction)new Add(r));
    }

    @ZenMethod
    public static void removeFluidRecipe(ILiquidStack fluid) {
        if (CraftTweakerHelper.toFluidStack(fluid) != null) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveFluid(CraftTweakerHelper.toFluidStack(fluid)));
        }
    }

    @ZenMethod
    public static void removeItemRecipe(IItemStack stack) {
        if (!CraftTweakerHelper.toStack(stack).func_190926_b()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveStack(CraftTweakerHelper.toStack(stack)));
        }
    }

    @ZenMethod
    public static void removeByInput(IItemStack stack) {
        if (CraftTweakerHelper.toStack(stack) != null) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveByInput(CraftTweakerHelper.toStack(stack)));
        }
    }

    private static class RemoveByInput
    implements IUndoableAction {
        private final ItemStack input;
        ArrayList<FermenterRecipe> removedRecipes = new ArrayList();

        public RemoveByInput(ItemStack input) {
            this.input = input;
        }

        public void apply() {
            Iterator<FermenterRecipe> it = FermenterRecipe.recipeList.iterator();
            while (it.hasNext()) {
                FermenterRecipe r = it.next();
                if (r == null || !r.input.matchesItemStack(this.input)) continue;
                this.removedRecipes.add(r);
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)r);
                it.remove();
            }
        }

        public void undo() {
            if (this.removedRecipes != null) {
                for (FermenterRecipe recipe : this.removedRecipes) {
                    if (recipe == null) continue;
                    FermenterRecipe.recipeList.add(recipe);
                    MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)recipe);
                }
            }
        }

        public String describe() {
            return "Removing Fermenter Recipes for input " + this.input.func_82833_r();
        }

        public String describeUndo() {
            return "Re-Adding Fermenter Recipes for input " + this.input.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    private static class RemoveStack
    implements IUndoableAction {
        private final ItemStack output;
        ArrayList<FermenterRecipe> removedRecipes = new ArrayList();

        public RemoveStack(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            Iterator<FermenterRecipe> it = FermenterRecipe.recipeList.iterator();
            while (it.hasNext()) {
                FermenterRecipe r = it.next();
                if (r == null || !OreDictionary.itemMatches((ItemStack)this.output, (ItemStack)r.itemOutput, (boolean)false)) continue;
                this.removedRecipes.add(r);
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)r);
                it.remove();
            }
        }

        public void undo() {
            if (this.removedRecipes != null) {
                for (FermenterRecipe recipe : this.removedRecipes) {
                    if (recipe == null) continue;
                    FermenterRecipe.recipeList.add(recipe);
                    MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)recipe);
                }
            }
        }

        public String describe() {
            return "Removing Fermenter Recipes for ItemStack " + this.output.func_82833_r();
        }

        public String describeUndo() {
            return "Re-Adding Fermenter Recipes for ItemStack " + this.output.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    private static class RemoveFluid
    implements IUndoableAction {
        private final FluidStack output;
        ArrayList<FermenterRecipe> removedRecipes = new ArrayList();

        public RemoveFluid(FluidStack output) {
            this.output = output;
        }

        public void apply() {
            Iterator<FermenterRecipe> it = FermenterRecipe.recipeList.iterator();
            while (it.hasNext()) {
                FermenterRecipe r = it.next();
                if (r == null || r.fluidOutput == null || !r.fluidOutput.isFluidEqual(this.output)) continue;
                this.removedRecipes.add(r);
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)r);
                it.remove();
            }
        }

        public void undo() {
            if (this.removedRecipes != null) {
                for (FermenterRecipe recipe : this.removedRecipes) {
                    if (recipe == null) continue;
                    FermenterRecipe.recipeList.add(recipe);
                    MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)recipe);
                }
            }
        }

        public String describe() {
            return "Removing Fermenter Recipes for Fluid " + this.output.getLocalizedName();
        }

        public String describeUndo() {
            return "Re-Adding Fermenter Recipes for Fluid " + this.output.getLocalizedName();
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    private static class Add
    implements IUndoableAction {
        private final FermenterRecipe recipe;

        public Add(FermenterRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            FermenterRecipe.recipeList.add(this.recipe);
            MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            FermenterRecipe.recipeList.remove(this.recipe);
            MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)this.recipe);
        }

        public String describe() {
            String fluid = this.recipe.fluidOutput != null ? this.recipe.fluidOutput.getLocalizedName() : "null";
            String out = !this.recipe.itemOutput.func_190926_b() ? this.recipe.itemOutput.func_82833_r() : "null";
            return "Adding Fermenter Recipe for Fluid " + fluid + " and Item " + out;
        }

        public String describeUndo() {
            String fluid = this.recipe.fluidOutput != null ? this.recipe.fluidOutput.getLocalizedName() : "null";
            String out = !this.recipe.itemOutput.func_190926_b() ? this.recipe.itemOutput.func_82833_r() : "null";
            return "Removing Fermenter Recipe for Fluid " + fluid + " and Item " + out;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

