/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fluids.FluidStack;

public class ItemNBTHelper {
    public static NBTTagCompound getTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static boolean hasTag(ItemStack stack) {
        return stack.func_77942_o();
    }

    public static boolean hasKey(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) && ItemNBTHelper.getTag(stack).func_74764_b(key);
    }

    public static void remove(ItemStack stack, String key) {
        if (ItemNBTHelper.hasKey(stack, key)) {
            ItemNBTHelper.getTag(stack).func_82580_o(key);
            if (ItemNBTHelper.getTag(stack).func_82582_d()) {
                stack.func_77982_d(null);
            }
        }
    }

    public static void setInt(ItemStack stack, String key, int val) {
        ItemNBTHelper.getTag(stack).func_74768_a(key, val);
    }

    public static void modifyInt(ItemStack stack, String key, int mod) {
        ItemNBTHelper.getTag(stack).func_74768_a(key, ItemNBTHelper.getTag(stack).func_74762_e(key) + mod);
    }

    public static int getInt(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? ItemNBTHelper.getTag(stack).func_74762_e(key) : 0;
    }

    public static void setString(ItemStack stack, String key, String val) {
        ItemNBTHelper.getTag(stack).func_74778_a(key, val);
    }

    public static String getString(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? ItemNBTHelper.getTag(stack).func_74779_i(key) : "";
    }

    public static void setLong(ItemStack stack, String key, long val) {
        ItemNBTHelper.getTag(stack).func_74772_a(key, val);
    }

    public static long getLong(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? ItemNBTHelper.getTag(stack).func_74763_f(key) : 0L;
    }

    public static void setIntArray(ItemStack stack, String key, int[] val) {
        ItemNBTHelper.getTag(stack).func_74783_a(key, val);
    }

    public static int[] getIntArray(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? ItemNBTHelper.getTag(stack).func_74759_k(key) : new int[]{};
    }

    public static void setFloat(ItemStack stack, String key, float val) {
        ItemNBTHelper.getTag(stack).func_74776_a(key, val);
    }

    public static float getFloat(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? ItemNBTHelper.getTag(stack).func_74760_g(key) : 0.0f;
    }

    public static void setBoolean(ItemStack stack, String key, boolean val) {
        ItemNBTHelper.getTag(stack).func_74757_a(key, val);
    }

    public static boolean getBoolean(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) && ItemNBTHelper.getTag(stack).func_74767_n(key);
    }

    public static void setTagCompound(ItemStack stack, String key, NBTTagCompound val) {
        ItemNBTHelper.getTag(stack).func_74782_a(key, (NBTBase)val);
    }

    public static NBTTagCompound getTagCompound(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? ItemNBTHelper.getTag(stack).func_74775_l(key) : new NBTTagCompound();
    }

    public static void setDelayedSoundsForStack(ItemStack stack, String nbtKey, String sound, float volume, float pitch, int amount, int baseDelay, int iDelay) {
        int[] delayedSounds = new int[amount];
        for (int i = 0; i < delayedSounds.length; ++i) {
            delayedSounds[i] = baseDelay + i * iDelay;
        }
        ItemNBTHelper.setIntArray(stack, "delayedSound_" + nbtKey + "_delay", delayedSounds);
        ItemNBTHelper.setString(stack, "delayedSound_" + nbtKey + "_sound", sound);
        ItemNBTHelper.setFloat(stack, "delayedSound_" + nbtKey + "_volume", volume);
        ItemNBTHelper.setFloat(stack, "delayedSound_" + nbtKey + "_pitch", pitch);
    }

    public static int handleDelayedSoundsForStack(ItemStack stack, String nbtKey, Entity ent) {
        if (!ItemNBTHelper.hasKey(stack, "delayedSound_" + nbtKey + "_delay")) {
            return -1;
        }
        int[] delayedSounds = ItemNBTHelper.getIntArray(stack, "delayedSound_" + nbtKey + "_delay");
        int l = 0;
        for (int i = 0; i < delayedSounds.length; ++i) {
            int n = i;
            delayedSounds[n] = delayedSounds[n] - 1;
            if (delayedSounds[i] <= 0) continue;
            ++l;
        }
        if (l > 0) {
            ItemNBTHelper.setIntArray(stack, "delayedSound_" + nbtKey + "_delay", delayedSounds);
        } else {
            ItemNBTHelper.remove(stack, "delayedSound_" + nbtKey + "_delay");
            ItemNBTHelper.remove(stack, "delayedSound_" + nbtKey + "_sound");
            ItemNBTHelper.remove(stack, "delayedSound_" + nbtKey + "_volume");
            ItemNBTHelper.remove(stack, "delayedSound_" + nbtKey + "_pitch");
        }
        return l;
    }

    public static void setFluidStack(ItemStack stack, String key, FluidStack val) {
        if (val != null && val.getFluid() != null) {
            NBTTagCompound tag = ItemNBTHelper.getTagCompound(stack, key);
            ItemNBTHelper.setTagCompound(stack, "Fluid", val.writeToNBT(new NBTTagCompound()));
        } else {
            ItemNBTHelper.remove(stack, "Fluid");
        }
    }

    public static FluidStack getFluidStack(ItemStack stack, String key) {
        if (ItemNBTHelper.hasTag(stack)) {
            NBTTagCompound tag = ItemNBTHelper.getTagCompound(stack, key);
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("Fluid"));
        }
        return null;
    }

    public static void setItemStack(ItemStack stack, String key, ItemStack val) {
        ItemNBTHelper.getTag(stack).func_74782_a(key, (NBTBase)val.func_77955_b(new NBTTagCompound()));
    }

    public static ItemStack getItemStack(ItemStack stack, String key) {
        if (ItemNBTHelper.hasTag(stack) && ItemNBTHelper.getTag(stack).func_74764_b(key)) {
            return new ItemStack(ItemNBTHelper.getTagCompound(stack, key));
        }
        return ItemStack.field_190927_a;
    }

    public static void setLore(ItemStack stack, String ... lore) {
        NBTTagCompound displayTag = ItemNBTHelper.getTagCompound(stack, "display");
        NBTTagList list = new NBTTagList();
        for (String s : lore) {
            list.func_74742_a((NBTBase)new NBTTagString(s));
        }
        displayTag.func_74782_a("Lore", (NBTBase)list);
        ItemNBTHelper.setTagCompound(stack, "display", displayTag);
    }

    public static int insertFluxItem(ItemStack container, int energy, int maxEnergy, boolean simulate) {
        int stored = ItemNBTHelper.getFluxStoredInItem(container);
        int accepted = Math.min(energy, maxEnergy - stored);
        if (!simulate) {
            ItemNBTHelper.setInt(container, "energy", stored += accepted);
        }
        return accepted;
    }

    public static int extractFluxFromItem(ItemStack container, int energy, boolean simulate) {
        int stored = ItemNBTHelper.getFluxStoredInItem(container);
        int extracted = Math.min(energy, stored);
        if (!simulate) {
            ItemNBTHelper.setInt(container, "energy", stored -= extracted);
        }
        return extracted;
    }

    public static int getFluxStoredInItem(ItemStack container) {
        return ItemNBTHelper.getInt(container, "energy");
    }

    public static ItemStack stackWithData(ItemStack stack, Object ... data) {
        assert (data.length % 2 == 0);
        for (int i = 0; i < data.length / 2; ++i) {
            Object key = data[i];
            Object value = data[i + 1];
            if (!(key instanceof String)) continue;
            if (value instanceof Boolean) {
                ItemNBTHelper.setBoolean(stack, (String)key, (Boolean)value);
                continue;
            }
            if (value instanceof Integer) {
                ItemNBTHelper.setInt(stack, (String)key, (Integer)value);
                continue;
            }
            if (value instanceof Float) {
                ItemNBTHelper.setFloat(stack, (String)key, ((Float)value).floatValue());
                continue;
            }
            if (value instanceof Long) {
                ItemNBTHelper.setLong(stack, (String)key, (Long)value);
                continue;
            }
            if (value instanceof String) {
                ItemNBTHelper.setString(stack, (String)key, (String)value);
                continue;
            }
            if (value instanceof NBTTagCompound) {
                ItemNBTHelper.setTagCompound(stack, (String)key, (NBTTagCompound)value);
                continue;
            }
            if (value instanceof int[]) {
                ItemNBTHelper.setIntArray(stack, (String)key, (int[])value);
                continue;
            }
            if (value instanceof ItemStack) {
                ItemNBTHelper.setItemStack(stack, (String)key, (ItemStack)value);
                continue;
            }
            if (!(value instanceof FluidStack)) continue;
            ItemNBTHelper.setFluidStack(stack, (String)key, (FluidStack)value);
        }
        return stack;
    }
}

