/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxContainerItem;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.api.tool.ZoomHandler;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.entities.EntityRailgunShot;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.ItemUpgradeableTool;
import blusunrize.immersiveengineering.common.util.IEAchievements;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import cofh.api.energy.IEnergyContainerItem;
import com.google.common.base.Optional;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRailgun
extends ItemUpgradeableTool
implements IFluxContainerItem,
IEnergyContainerItem,
ZoomHandler.IZoomTool,
ITool,
IOBJModelCallback<ItemStack> {
    float[] zoomSteps = new float[]{0.1f, 0.15625f, 0.2f, 0.25f, 0.3125f, 0.4f, 0.5f, 0.625f};

    public ItemRailgun() {
        super("railgun", 1, "RAILGUN", new String[0]);
    }

    @Override
    public int getInternalSlots(ItemStack stack) {
        return 3;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack, IInventory invItem) {
        return new Slot[]{new IESlot.Upgrades(container, invItem, 0, 80, 32, "RAILGUN", stack, true), new IESlot.Upgrades(container, invItem, 1, 100, 32, "RAILGUN", stack, true)};
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public void recalculateUpgrades(ItemStack stack) {
        super.recalculateUpgrades(stack);
        if (this.getEnergyStored(stack) > this.getMaxEnergyStored(stack)) {
            ItemNBTHelper.setInt(stack, "energy", this.getMaxEnergyStored(stack));
        }
    }

    @Override
    public void clearUpgrades(ItemStack stack) {
        super.clearUpgrades(stack);
        if (this.getEnergyStored(stack) > this.getMaxEnergyStored(stack)) {
            ItemNBTHelper.setInt(stack, "energy", this.getMaxEnergyStored(stack));
        }
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged) {
            return true;
        }
        if (oldStack.hasCapability(CapabilityShader.SHADER_CAPABILITY, null) && newStack.hasCapability(CapabilityShader.SHADER_CAPABILITY, null)) {
            CapabilityShader.ShaderWrapper wrapperOld = (CapabilityShader.ShaderWrapper)oldStack.getCapability(CapabilityShader.SHADER_CAPABILITY, null);
            CapabilityShader.ShaderWrapper wrapperNew = (CapabilityShader.ShaderWrapper)newStack.getCapability(CapabilityShader.SHADER_CAPABILITY, null);
            if (!ItemStack.func_77989_b((ItemStack)wrapperOld.getShaderItem(), (ItemStack)wrapperNew.getShaderItem())) {
                return true;
            }
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        return new ICapabilityProvider(){
            CapabilityShader.ShaderWrapper_Item shaders;
            {
                this.shaders = new CapabilityShader.ShaderWrapper_Item("immersiveengineering:railgun", stack);
            }

            public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                return capability == CapabilityShader.SHADER_CAPABILITY;
            }

            public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                if (capability == CapabilityShader.SHADER_CAPABILITY) {
                    return (T)this.shaders;
                }
                return null;
            }
        };
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        String stored = this.getEnergyStored(stack) + "/" + this.getMaxEnergyStored(stack);
        list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{stored}));
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack);
    }

    public boolean func_77662_d() {
        return true;
    }

    public EnumAction func_77661_b(ItemStack p_77661_1_) {
        return EnumAction.NONE;
    }

    public void func_77663_a(ItemStack stack, World world, Entity ent, int slot, boolean inHand) {
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        int energy = Config.IEConfig.Tools.railgun_consumption;
        float energyMod = 1.0f + this.getUpgrades(stack).func_74760_g("consumption");
        if (this.extractEnergy(stack, energy = (int)((float)energy * energyMod), true) == energy && !ItemRailgun.findAmmo(player).func_190926_b()) {
            player.func_184598_c(hand);
            player.func_184185_a(this.getChargeTime(stack) <= 20 ? IESounds.chargeFast : IESounds.chargeSlow, 1.5f, 1.0f);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase user, int count) {
        int inUse = this.func_77626_a(stack) - count;
        if (inUse > this.getChargeTime(stack) && inUse % 20 == user.func_70681_au().nextInt(20)) {
            user.func_184185_a(IESounds.spark, 0.8f + 0.2f * user.func_70681_au().nextFloat(), 0.5f + 0.5f * user.func_70681_au().nextFloat());
        }
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase user, int timeLeft) {
        if (user instanceof EntityPlayer) {
            ItemStack ammo;
            int inUse = this.func_77626_a(stack) - timeLeft;
            ItemNBTHelper.remove(stack, "inUse");
            if (inUse < this.getChargeTime(stack)) {
                return;
            }
            int energy = Config.IEConfig.Tools.railgun_consumption;
            float energyMod = 1.0f + this.getUpgrades(stack).func_74760_g("consumption");
            if (this.extractEnergy(stack, energy = (int)((float)energy * energyMod), true) == energy && !(ammo = ItemRailgun.findAmmo((EntityPlayer)user)).func_190926_b()) {
                Vec3d vec = user.func_70040_Z();
                float speed = 20.0f;
                EntityRailgunShot shot = new EntityRailgunShot(user.field_70170_p, user, vec.field_72450_a * (double)speed, vec.field_72448_b * (double)speed, vec.field_72449_c * (double)speed, Utils.copyStackWithAmount(ammo, 1));
                ammo.func_190918_g(1);
                if (ammo.func_190916_E() <= 0) {
                    ((EntityPlayer)user).field_71071_by.func_184437_d(ammo);
                }
                user.func_184185_a(IESounds.railgunFire, 1.0f, 0.5f + 0.5f * user.func_70681_au().nextFloat());
                this.extractEnergy(stack, energy, false);
                if (!world.field_72995_K) {
                    user.field_70170_p.func_72838_d((Entity)shot);
                }
            }
        }
    }

    public static ItemStack findAmmo(EntityPlayer player) {
        if (ItemRailgun.isAmmo(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (ItemRailgun.isAmmo(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!ItemRailgun.isAmmo(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isAmmo(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        RailgunHandler.RailgunProjectileProperties prop = RailgunHandler.getProjectileProperties(stack);
        return prop != null;
    }

    public int getChargeTime(ItemStack railgun) {
        return (int)(40.0f / (1.0f + this.getUpgrades(railgun).func_74760_g("speed")));
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @Override
    public void removeFromWorkbench(EntityPlayer player, ItemStack stack) {
        NonNullList<ItemStack> contents = this.getContainedItems(stack);
        player.func_71029_a((StatBase)IEAchievements.craftRailgun);
    }

    @Override
    public int receiveEnergy(ItemStack container, int energy, boolean simulate) {
        return ItemNBTHelper.insertFluxItem(container, energy, this.getMaxEnergyStored(container), simulate);
    }

    @Override
    public int extractEnergy(ItemStack container, int energy, boolean simulate) {
        return ItemNBTHelper.extractFluxFromItem(container, energy, simulate);
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return ItemNBTHelper.getFluxStoredInItem(container);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return 8000 + this.getUpgrades(container).func_74762_e("capacity");
    }

    public String[] compileRender(ItemStack stack) {
        HashSet<String> render = new HashSet<String>();
        render.add("frame");
        render.add("barrel");
        render.add("grip");
        render.add("capacitors");
        render.add("sled");
        render.add("wires");
        NBTTagCompound upgrades = this.getUpgrades(stack);
        if (upgrades.func_74769_h("speed") > 0.0) {
            render.add("upgrade_speed");
        }
        if (upgrades.func_74767_n("scope")) {
            render.add("upgrade_scope");
        }
        return render.toArray(new String[render.size()]);
    }

    @Override
    public boolean canZoom(ItemStack stack, EntityPlayer player) {
        return this.getUpgrades(stack).func_74767_n("scope");
    }

    @Override
    public float[] getZoomSteps(ItemStack stack, EntityPlayer player) {
        return this.zoomSteps;
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureReplacement(ItemStack stack, String material) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderGroup(ItemStack stack, String group) {
        if (group.equals("upgrade_scope")) {
            return this.getUpgrades(stack).func_74767_n("scope");
        }
        if (group.equals("upgrade_speed")) {
            return this.getUpgrades(stack).func_74769_h("speed") > 0.0;
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Optional<TRSRTransformation> applyTransformations(ItemStack stack, String group, Optional<TRSRTransformation> transform) {
        return transform;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Matrix4 handlePerspective(ItemStack stack, ItemCameraTransforms.TransformType cameraTransformType, Matrix4 perspective) {
        return perspective;
    }
}

