/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.stone.BlockTypes_StoneDevices;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCoresample
extends ItemIEBase {
    public ItemCoresample() {
        super("coresample", 1, new String[0]);
    }

    @Override
    public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> list) {
        super.func_150895_a(item, tab, list);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        if (ItemNBTHelper.hasKey(stack, "coords")) {
            String s2;
            if (ItemNBTHelper.hasKey(stack, "mineral")) {
                String mineral = ItemNBTHelper.getString(stack, "mineral");
                String unloc = "desc.immersiveengineering.info.mineral." + mineral;
                String loc = I18n.func_135052_a((String)unloc, (Object[])new Object[0]);
                list.add(I18n.func_135052_a((String)"chat.immersiveengineering.info.coresample.mineral", (Object[])new Object[]{unloc.equals(loc) ? mineral : loc}));
            } else {
                list.add(I18n.func_135052_a((String)"chat.immersiveengineering.info.coresample.noMineral", (Object[])new Object[0]));
            }
            int[] coords = ItemNBTHelper.getIntArray(stack, "coords");
            WorldServer world = DimensionManager.getWorld((int)coords[0]);
            String s0 = coords[1] * 16 + ", " + coords[2] * 16;
            String s1 = coords[1] * 16 + 16 + ", " + (coords[2] * 16 + 16);
            if (world != null && world.field_73011_w != null) {
                String name = world.field_73011_w.func_186058_p().func_186065_b();
                if (name.toLowerCase(Locale.ENGLISH).startsWith("the ")) {
                    name = name.substring(4);
                }
                s2 = name;
            } else {
                s2 = "Dimension " + coords[0];
            }
            list.add(s2);
            list.add(I18n.func_135052_a((String)"chat.immersiveengineering.info.coresample.pos", (Object[])new Object[]{s0, s1, ""}));
            if (ItemNBTHelper.hasKey(stack, "infinite")) {
                list.add(I18n.func_135052_a((String)"chat.immersiveengineering.info.coresample.infinite", (Object[])new Object[0]));
            } else if (ItemNBTHelper.hasKey(stack, "depletion")) {
                list.add(I18n.func_135052_a((String)"chat.immersiveengineering.info.coresample.yield", (Object[])new Object[]{ExcavatorHandler.mineralVeinCapacity - ItemNBTHelper.getInt(stack, "depletion")}));
            }
            if (ItemNBTHelper.hasKey(stack, "timestamp") && world != null) {
                long timestamp = ItemNBTHelper.getLong(stack, "timestamp");
                long dist = world.func_82737_E() - timestamp;
                if (dist < 0L) {
                    list.add("Somehow this sample is dated in the future...are you a time traveller?!");
                } else {
                    list.add(I18n.func_135052_a((String)"chat.immersiveengineering.info.coresample.timestamp", (Object[])new Object[]{ClientUtils.fomatTimestamp(dist, ClientUtils.TimestampFormat.DHM)}));
                }
            } else {
                list.add(I18n.func_135052_a((String)"chat.immersiveengineering.info.coresample.noTimestamp", (Object[])new Object[0]));
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (!block.func_176200_f((IBlockAccess)world, pos)) {
                pos = pos.func_177972_a(side);
            }
            if (!stack.func_190926_b() && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)IEContent.blockStoneDevice, pos, false, side, null)) {
                IBlockState toolbox = IEContent.blockStoneDevice.func_176203_a(BlockTypes_StoneDevices.CORESAMPLE.getMeta());
                if (world.func_180501_a(pos, toolbox, 3)) {
                    IEContent.blockStoneDevice.onIEBlockPlacedBy(world, pos, toolbox, side, hitX, hitY, hitZ, (EntityLivingBase)player, stack);
                    SoundType soundtype = world.func_180495_p(pos).func_177230_c().getSoundType(world.func_180495_p(pos), world, pos, (Entity)player);
                    world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    stack.func_190918_g(1);
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return super.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
    }
}

