/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class RecipeShapedIngredient
extends ShapedOreRecipe {
    static IngredientStack[] tempIngredients;
    IngredientStack[] ingredients;
    IngredientStack[] ingredientsQuarterTurn;
    IngredientStack[] ingredientsEighthTurn;
    int nbtCopyTargetSlot = -1;
    int lastMatch = 0;
    static int[] eighthTurnMap;

    public RecipeShapedIngredient(ItemStack result, Object ... recipe) {
        super(result, RecipeShapedIngredient.saveIngredients(recipe));
        this.setIngredients(tempIngredients);
        tempIngredients = null;
    }

    public RecipeShapedIngredient setIngredients(IngredientStack[] ingr) {
        this.ingredients = ingr;
        for (int i = 0; i < this.input.length; ++i) {
            if (this.ingredients[i] == null) continue;
            this.input[i] = this.ingredients[i].getShapedRecipeInput();
        }
        return this;
    }

    public IngredientStack[] getIngredients() {
        return this.ingredients;
    }

    public RecipeShapedIngredient allowQuarterTurn() {
        this.ingredientsQuarterTurn = new IngredientStack[this.ingredients.length];
        int maxH = this.height - 1;
        for (int h = 0; h < this.height; ++h) {
            for (int w = 0; w < this.width; ++w) {
                this.ingredientsQuarterTurn[w * this.height + (maxH - h)] = this.ingredients[h * this.width + w];
            }
        }
        return this;
    }

    public RecipeShapedIngredient allowEighthTurn() {
        if (this.width != 3 || this.height != 3) {
            return this;
        }
        this.ingredientsEighthTurn = new IngredientStack[this.ingredients.length];
        int maxH = this.height - 1;
        for (int h = 0; h < this.height; ++h) {
            for (int w = 0; w < this.width; ++w) {
                int i = h * this.width + w;
                this.ingredientsEighthTurn[i + RecipeShapedIngredient.eighthTurnMap[i]] = this.ingredients[i];
            }
        }
        return this;
    }

    public RecipeShapedIngredient setNBTCopyTargetRecipe(int slot) {
        this.nbtCopyTargetSlot = slot;
        return this;
    }

    public static Object[] saveIngredients(Object ... recipe) {
        Object[] converted = new Object[recipe.length];
        String shape = "";
        boolean shapeDone = false;
        for (int i = 0; i < converted.length; ++i) {
            converted[i] = recipe[i];
            if (!shapeDone) {
                if (recipe[i] instanceof String[]) {
                    String[] parts;
                    for (String s : parts = (String[])recipe[i]) {
                        shape = shape + s;
                    }
                } else if (recipe[i] instanceof String) {
                    shape = shape + (String)recipe[i];
                }
            }
            if (!(recipe[i] instanceof Character)) continue;
            if (!shapeDone) {
                shapeDone = true;
                tempIngredients = new IngredientStack[shape.length()];
            }
            Character chr = (Character)recipe[i];
            Object in = recipe[i + 1];
            IngredientStack ingredient = ApiUtils.createIngredientStack(in);
            if (ingredient == null) continue;
            recipe[i + 1] = Blocks.field_150480_ab;
            for (int j = 0; j < shape.length(); ++j) {
                if (chr.charValue() != shape.charAt(j)) continue;
                RecipeShapedIngredient.tempIngredients[j] = ingredient;
            }
        }
        return converted;
    }

    public ItemStack func_77572_b(InventoryCrafting matrix) {
        if (this.nbtCopyTargetSlot >= 0) {
            ItemStack out = this.output.func_77946_l();
            if (!matrix.func_70301_a(this.nbtCopyTargetSlot).func_190926_b() && matrix.func_70301_a(this.nbtCopyTargetSlot).func_77942_o()) {
                out.func_77982_d(matrix.func_70301_a(this.nbtCopyTargetSlot).func_77978_p().func_74737_b());
            }
            return out;
        }
        return super.func_77572_b(matrix);
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList remains = ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
        return remains;
    }

    protected boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        if (this.checkMatchDo(inv, this.ingredients, startX, startY, mirror, false)) {
            this.lastMatch = 0;
            return true;
        }
        if (this.ingredientsQuarterTurn != null && this.checkMatchDo(inv, this.ingredientsQuarterTurn, startX, startY, mirror, true)) {
            this.lastMatch = 1;
            return true;
        }
        if (this.ingredientsEighthTurn != null && this.checkMatchDo(inv, this.ingredientsEighthTurn, startX, startY, mirror, false)) {
            this.lastMatch = 2;
            return true;
        }
        return false;
    }

    protected boolean checkMatchDo(InventoryCrafting inv, IngredientStack[] ingredients, int startX, int startY, boolean mirror, boolean rotate) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack slot;
                int subX = x - startX;
                int subY = y - startY;
                IngredientStack target = null;
                if (!rotate) {
                    if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                        target = mirror ? ingredients[this.width - subX - 1 + subY * this.width] : ingredients[subX + subY * this.width];
                    }
                } else if (subX >= 0 && subY >= 0 && subX < this.height && subY < this.width) {
                    target = mirror ? ingredients[this.height - subX - 1 + subY * this.width] : ingredients[subY + subX * this.height];
                }
                if (target == null != (slot = inv.func_70463_b(x, y)).func_190926_b()) {
                    return false;
                }
                if (target == null || target.matchesItemStack(slot)) continue;
                return false;
            }
        }
        return true;
    }

    static {
        eighthTurnMap = new int[]{3, -1, -1, 3, 0, -3, 1, 1, -3};
    }
}

