/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.ILootContainer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityWoodenCrate
extends TileEntityIEBase
implements IIEInventory,
IEBlockInterfaces.IGuiTile,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IComparatorOverride,
ILootContainer {
    NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    public ResourceLocation lootTable;
    public String name;
    IItemHandler insertionHandler = new IEInventoryHandler(27, this);

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        if (nbt.func_74764_b("name")) {
            this.name = nbt.func_74779_i("name");
        }
        if (!descPacket) {
            if (nbt.func_150297_b("lootTable", 8)) {
                this.lootTable = new ResourceLocation(nbt.func_74779_i("lootTable"));
            } else {
                this.inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 27);
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        if (this.name != null) {
            nbt.func_74778_a("name", this.name);
        }
        if (!descPacket) {
            if (this.lootTable != null) {
                nbt.func_74778_a("lootTable", this.lootTable.toString());
            } else {
                this.writeInv(nbt, false);
            }
        }
    }

    public void writeInv(NBTTagCompound nbt, boolean toItem) {
        boolean write = false;
        NBTTagList invList = new NBTTagList();
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            if (toItem) {
                write = true;
            }
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.inventory.get(i)).func_77955_b(itemTag);
            invList.func_74742_a((NBTBase)itemTag);
        }
        if (!toItem || write) {
            nbt.func_74782_a("inventory", (NBTBase)invList);
        }
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        return this.name != null ? new TextComponentString(this.name) : new TextComponentTranslation(this.func_145832_p() == 0 ? "tile.immersiveengineering.wooden_device0.crate.name" : "tile.immersiveengineering.wooden_device0.reinforced_crate.name", new Object[0]);
    }

    @Override
    public boolean canOpenGui() {
        return true;
    }

    @Override
    public int getGuiID() {
        return 2;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this;
    }

    @Override
    public void onGuiOpened(EntityPlayer player, boolean clientside) {
        if (this.lootTable != null && !clientside) {
            LootTable loottable = this.field_145850_b.func_184146_ak().func_186521_a(this.lootTable);
            this.lootTable = null;
            LootContext.Builder contextBuilder = new LootContext.Builder((WorldServer)this.field_145850_b);
            if (player != null) {
                contextBuilder.func_186469_a(player.func_184817_da());
            }
            LootContext context = contextBuilder.func_186471_a();
            Random rand = new Random();
            List list = loottable.func_186462_a(rand, context);
            ArrayList listSlots = Lists.newArrayList();
            for (int i = 0; i < this.inventory.size(); ++i) {
                if (!((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
                listSlots.add(i);
            }
            Collections.shuffle(listSlots, rand);
            if (listSlots.isEmpty()) {
                return;
            }
            Utils.shuffleLootItems(list, listSlots.size(), rand);
            for (ItemStack itemstack : list) {
                int slot = (Integer)listSlots.remove(listSlots.size() - 1);
                this.inventory.set(slot, (Object)itemstack);
            }
        }
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        if (!stack.func_190926_b()) {
            if (OreDictionary.itemMatches((ItemStack)new ItemStack((Block)IEContent.blockWoodenDevice0, 1, 0), (ItemStack)stack, (boolean)true)) {
                return false;
            }
            if (OreDictionary.itemMatches((ItemStack)new ItemStack((Block)IEContent.blockWoodenDevice0, 1, 5), (ItemStack)stack, (boolean)true)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
    }

    @Override
    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        NBTTagCompound tag = new NBTTagCompound();
        this.writeInv(tag, true);
        if (!tag.func_82582_d()) {
            stack.func_77982_d(tag);
        }
        if (this.name != null) {
            stack.func_151001_c(this.name);
        }
        return stack;
    }

    @Override
    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        if (stack.func_77942_o()) {
            this.readCustomNBT(stack.func_77978_p(), false);
            if (stack.func_82837_s()) {
                this.name = stack.func_82833_r();
            }
        }
    }

    @Override
    public boolean preventInventoryDrop() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        return Utils.calcRedstoneFromInventory(this);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.insertionHandler;
        }
        return super.getCapability(capability, facing);
    }

    public ResourceLocation func_184276_b() {
        return this.lootTable;
    }
}

