/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntitySorter
extends TileEntityIEBase
implements IEBlockInterfaces.IGuiTile {
    public SorterInventory filter;
    public int[] sideFilter = new int[]{0, 0, 0, 0, 0, 0};
    public static final int filterSlotsPerSide = 8;
    private boolean isRouting = false;
    IItemHandler[] insertionHandlers = new IItemHandler[]{new SorterInventoryHandler(this, EnumFacing.DOWN), new SorterInventoryHandler(this, EnumFacing.UP), new SorterInventoryHandler(this, EnumFacing.NORTH), new SorterInventoryHandler(this, EnumFacing.SOUTH), new SorterInventoryHandler(this, EnumFacing.WEST), new SorterInventoryHandler(this, EnumFacing.EAST)};

    public TileEntitySorter() {
        this.filter = new SorterInventory(this);
    }

    public ItemStack routeItem(EnumFacing inputSide, ItemStack stack, boolean simulate) {
        if (!this.field_145850_b.field_72995_K) {
            int i;
            int rand;
            Integer[][] validOutputs = this.getValidOutputs(inputSide, stack, true, false);
            if (validOutputs[0].length > 0 && !(stack = this.outputItemToInv(stack, EnumFacing.func_82600_a((int)validOutputs[0][rand = this.field_145850_b.field_73012_v.nextInt(validOutputs[0].length)]), simulate)).func_190926_b()) {
                for (i = 0; i < validOutputs[0].length; ++i) {
                    if (i == rand || !(stack = this.outputItemToInv(stack, EnumFacing.func_82600_a((int)validOutputs[0][i]), simulate)).func_190926_b()) continue;
                    return ItemStack.field_190927_a;
                }
            }
            if (!stack.func_190926_b() && validOutputs[1].length > 0) {
                if (!simulate) {
                    rand = this.field_145850_b.field_73012_v.nextInt(validOutputs[1].length);
                    EnumFacing fd = EnumFacing.func_82600_a((int)validOutputs[1][rand]);
                    EntityItem ei = new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5 + (double)fd.func_82601_c(), (double)this.func_174877_v().func_177956_o() + 0.5 + (double)fd.func_96559_d(), (double)this.func_174877_v().func_177952_p() + 0.5 + (double)fd.func_82599_e(), stack.func_77946_l());
                    ei.field_70159_w = 0.075f * (float)fd.func_82601_c();
                    ei.field_70181_x = 0.025000000372529;
                    ei.field_70179_y = 0.075f * (float)fd.func_82599_e();
                    this.field_145850_b.func_72838_d((Entity)ei);
                }
                return ItemStack.field_190927_a;
            }
            if (validOutputs[2].length > 0 && !(stack = this.outputItemToInv(stack, EnumFacing.func_82600_a((int)validOutputs[2][rand = this.field_145850_b.field_73012_v.nextInt(validOutputs[2].length)]), simulate)).func_190926_b()) {
                for (i = 0; i < validOutputs[2].length; ++i) {
                    if (i == rand || !(stack = this.outputItemToInv(stack, EnumFacing.func_82600_a((int)validOutputs[2][i]), simulate)).func_190926_b()) continue;
                    return ItemStack.field_190927_a;
                }
            }
            if (!stack.func_190926_b() && validOutputs[3].length > 0) {
                if (!simulate) {
                    rand = this.field_145850_b.field_73012_v.nextInt(validOutputs[3].length);
                    EnumFacing fd = EnumFacing.func_82600_a((int)validOutputs[1][rand]);
                    EntityItem ei = new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5 + (double)fd.func_82601_c(), (double)this.func_174877_v().func_177956_o() + 0.5 + (double)fd.func_96559_d(), (double)this.func_174877_v().func_177952_p() + 0.5 + (double)fd.func_82599_e(), stack.func_77946_l());
                    ei.field_70159_w = 0.075f * (float)fd.func_82601_c();
                    ei.field_70181_x = 0.025000000372529;
                    ei.field_70179_y = 0.075f * (float)fd.func_82599_e();
                    this.field_145850_b.func_72838_d((Entity)ei);
                }
                return ItemStack.field_190927_a;
            }
        }
        return stack;
    }

    public boolean doOredict(int side) {
        if (side >= 0 && side < this.sideFilter.length) {
            return (this.sideFilter[side] & 1) != 0;
        }
        return false;
    }

    public boolean doNBT(int side) {
        if (side >= 0 && side < this.sideFilter.length) {
            return (this.sideFilter[side] & 2) != 0;
        }
        return false;
    }

    public boolean doFuzzy(int side) {
        if (side >= 0 && side < this.sideFilter.length) {
            return (this.sideFilter[side] & 4) != 0;
        }
        return false;
    }

    @Override
    public boolean canOpenGui() {
        return true;
    }

    @Override
    public int getGuiID() {
        return 5;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this;
    }

    @Override
    public void receiveMessageFromClient(NBTTagCompound message) {
        if (message.func_74764_b("sideConfig")) {
            this.sideFilter = message.func_74759_k("sideConfig");
        }
    }

    public Integer[][] getValidOutputs(EnumFacing inputSide, ItemStack stack, boolean allowUnmapped, boolean allowThrowing) {
        if (this.isRouting || stack.func_190926_b()) {
            return new Integer[][]{new Integer[0], new Integer[0], new Integer[0], new Integer[0]};
        }
        this.isRouting = true;
        ArrayList<Integer> validFilteredInvOuts = new ArrayList<Integer>(6);
        ArrayList<Integer> validFilteredEntityOuts = new ArrayList<Integer>(6);
        ArrayList<Integer> validUnfilteredInvOuts = new ArrayList<Integer>(6);
        ArrayList<Integer> validUnfilteredEntityOuts = new ArrayList<Integer>(6);
        for (EnumFacing side : EnumFacing.values()) {
            TileEntity inventory;
            if (side == inputSide) continue;
            boolean unmapped = true;
            boolean allowed = false;
            for (ItemStack filterStack : this.filter.filters[side.ordinal()]) {
                if (filterStack.func_190926_b()) continue;
                unmapped = false;
                boolean b = OreDictionary.itemMatches((ItemStack)filterStack, (ItemStack)stack, (boolean)true);
                if (!b && this.doFuzzy(side.ordinal())) {
                    b = filterStack.func_77973_b().equals(stack.func_77973_b());
                }
                if (!b && this.doOredict(side.ordinal())) {
                    for (String name : OreDictionary.getOreNames()) {
                        if (!Utils.compareToOreName(stack, name) || !Utils.compareToOreName(filterStack, name)) continue;
                        b = true;
                        break;
                    }
                }
                if (this.doNBT(side.ordinal())) {
                    b &= Utils.compareItemNBT(filterStack, stack);
                }
                if (!b) continue;
                allowed = true;
                break;
            }
            if (allowed) {
                inventory = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(side));
                if (Utils.canInsertStackIntoInventory(inventory, stack, side.func_176734_d())) {
                    validFilteredInvOuts.add(side.ordinal());
                    continue;
                }
                if (!allowThrowing) continue;
                validFilteredEntityOuts.add(side.ordinal());
                continue;
            }
            if (!allowUnmapped || !unmapped) continue;
            inventory = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(side));
            if (Utils.canInsertStackIntoInventory(inventory, stack, side.func_176734_d())) {
                validUnfilteredInvOuts.add(side.ordinal());
                continue;
            }
            if (!allowThrowing) continue;
            validUnfilteredEntityOuts.add(side.ordinal());
        }
        this.isRouting = false;
        return new Integer[][]{validFilteredInvOuts.toArray(new Integer[validFilteredInvOuts.size()]), validFilteredEntityOuts.toArray(new Integer[validFilteredEntityOuts.size()]), validUnfilteredInvOuts.toArray(new Integer[validUnfilteredInvOuts.size()]), validUnfilteredEntityOuts.toArray(new Integer[validUnfilteredEntityOuts.size()])};
    }

    public ItemStack outputItemToInv(ItemStack stack, EnumFacing side, boolean simulate) {
        TileEntity inventory = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(side));
        return Utils.insertStackIntoInventory(inventory, stack, side.func_176734_d(), simulate);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.sideFilter = nbt.func_74759_k("sideFilter");
        if (!descPacket) {
            NBTTagList filterList = nbt.func_150295_c("filter", 10);
            this.filter = new SorterInventory(this);
            this.filter.readFromNBT(filterList);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74783_a("sideFilter", this.sideFilter);
        if (!descPacket) {
            NBTTagList filterList = new NBTTagList();
            this.filter.writeToNBT(filterList);
            nbt.func_74782_a("filter", (NBTBase)filterList);
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != null) {
            return (T)this.insertionHandlers[facing.ordinal()];
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        return id == 0;
    }

    public static class SorterInventory
    implements IInventory {
        public ItemStack[][] filters = new ItemStack[6][8];
        final TileEntitySorter tile;

        public SorterInventory(TileEntitySorter tile) {
            this.tile = tile;
            this.func_174888_l();
        }

        public int func_70302_i_() {
            return 48;
        }

        public boolean func_191420_l() {
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 8; ++j) {
                    if (this.filters[i][j].func_190926_b()) continue;
                    return false;
                }
            }
            return true;
        }

        public ItemStack func_70301_a(int slot) {
            return this.filters[slot / 8][slot % 8];
        }

        public ItemStack func_70298_a(int slot, int amount) {
            ItemStack stack = this.func_70301_a(slot);
            if (!stack.func_190926_b()) {
                if (stack.func_190916_E() <= amount) {
                    this.func_70299_a(slot, null);
                } else if ((stack = stack.func_77979_a(amount)).func_190916_E() == 0) {
                    this.func_70299_a(slot, null);
                }
            }
            return stack;
        }

        public ItemStack func_70304_b(int slot) {
            ItemStack stack = this.func_70301_a(slot);
            if (!stack.func_190926_b()) {
                this.func_70299_a(slot, null);
            }
            return stack;
        }

        public void func_70299_a(int slot, ItemStack stack) {
            this.filters[slot / 8][slot % 8] = stack;
            if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
        }

        public void func_174888_l() {
            for (int i = 0; i < this.filters.length; ++i) {
                for (int j = 0; j < this.filters[i].length; ++j) {
                    this.filters[i][j] = ItemStack.field_190927_a;
                }
            }
        }

        public String func_70005_c_() {
            return "IESorterLayout";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_145748_c_() {
            return new TextComponentString(this.func_70005_c_());
        }

        public int func_70297_j_() {
            return 1;
        }

        public boolean func_70300_a(EntityPlayer player) {
            return true;
        }

        public void func_174889_b(EntityPlayer player) {
        }

        public void func_174886_c(EntityPlayer player) {
        }

        public boolean func_94041_b(int slot, ItemStack stack) {
            return true;
        }

        public void func_70296_d() {
            this.tile.func_70296_d();
        }

        public void writeToNBT(NBTTagList list) {
            for (int i = 0; i < this.filters.length; ++i) {
                for (int j = 0; j < this.filters[i].length; ++j) {
                    if (this.filters[i][j].func_190926_b()) continue;
                    NBTTagCompound itemTag = new NBTTagCompound();
                    itemTag.func_74774_a("Slot", (byte)(i * 8 + j));
                    this.filters[i][j].func_77955_b(itemTag);
                    list.func_74742_a((NBTBase)itemTag);
                }
            }
        }

        public void readFromNBT(NBTTagList list) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound itemTag = list.func_150305_b(i);
                int slot = itemTag.func_74771_c("Slot") & 0xFF;
                if (slot < 0 || slot >= this.func_70302_i_()) continue;
                this.filters[slot / 8][slot % 8] = new ItemStack(itemTag);
            }
        }

        public int func_174887_a_(int id) {
            return 0;
        }

        public void func_174885_b(int id, int value) {
        }

        public int func_174890_g() {
            return 0;
        }
    }

    public static class SorterInventoryHandler
    implements IItemHandlerModifiable {
        TileEntitySorter sorter;
        EnumFacing side;

        public SorterInventoryHandler(TileEntitySorter sorter, EnumFacing side) {
            this.sorter = sorter;
            this.side = side;
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.sorter.routeItem(this.side, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
        }
    }
}

