/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.BlockIEMultiblock;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.blocks.stone.BlockTypes_StoneDevices;
import blusunrize.immersiveengineering.common.blocks.stone.TileEntityBlastFurnace;
import blusunrize.immersiveengineering.common.blocks.stone.TileEntityBlastFurnaceAdvanced;
import blusunrize.immersiveengineering.common.blocks.stone.TileEntityCokeOven;
import blusunrize.immersiveengineering.common.blocks.stone.TileEntityCoresample;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockStoneDevice
extends BlockIEMultiblock<BlockTypes_StoneDevices> {
    private static final AxisAlignedBB AABB_CARPET = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    private static final AxisAlignedBB AABB_QUARTER = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    private static final AxisAlignedBB AABB_THREEQUARTER = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
    private static final AxisAlignedBB AABB_CORESAMPLE_X = new AxisAlignedBB(0.0, 0.0, 0.28125, 1.0, 1.0, 0.71875);
    private static final AxisAlignedBB AABB_CORESAMPLE_Z = new AxisAlignedBB(0.28125, 0.0, 0.0, 0.71875, 1.0, 1.0);

    public BlockStoneDevice() {
        super("stone_device", Material.field_151576_e, PropertyEnum.func_177709_a((String)"type", BlockTypes_StoneDevices.class), ItemBlockIEBase.class, new Object[]{IEProperties.BOOLEANS[0]});
        this.func_149711_c(2.0f);
        this.func_149752_b(20.0f);
        this.setAllNotNormalBlock();
        this.field_149786_r = 0;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityBlastFurnaceAdvanced) {
            return ((TileEntityBlastFurnaceAdvanced)te).field_174879_c == 1 || ((TileEntityBlastFurnaceAdvanced)te).field_174879_c == 4 || ((TileEntityBlastFurnaceAdvanced)te).field_174879_c == 7 || ((TileEntityBlastFurnaceAdvanced)te).field_174879_c == 31;
        }
        return true;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te;
        BlockTypes_StoneDevices meta = (BlockTypes_StoneDevices)((Object)state.func_177229_b(this.getMetaProperty()));
        if (meta == BlockTypes_StoneDevices.CONCRETE_SHEET) {
            return AABB_CARPET;
        }
        if (meta == BlockTypes_StoneDevices.CONCRETE_QUARTER) {
            return AABB_QUARTER;
        }
        if (meta == BlockTypes_StoneDevices.CONCRETE_THREEQUARTER) {
            return AABB_THREEQUARTER;
        }
        if (meta == BlockTypes_StoneDevices.CORESAMPLE && (te = world.func_175625_s(pos)) != null && te instanceof TileEntityCoresample) {
            return ((TileEntityCoresample)te).facing.func_176740_k() == EnumFacing.Axis.Z ? AABB_CORESAMPLE_Z : AABB_CORESAMPLE_X;
        }
        return super.func_185496_a(state, world, pos);
    }

    @Override
    public void func_149666_a(Item item, CreativeTabs tab, NonNullList<ItemStack> list) {
        super.func_149666_a(item, tab, list);
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileEntityCokeOven();
            }
            case 1: {
                return new TileEntityBlastFurnace();
            }
            case 2: {
                return new TileEntityBlastFurnaceAdvanced();
            }
            case 6: {
                return new TileEntityCoresample();
            }
        }
        return null;
    }
}

