/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.ModelConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorBasic;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ConveyorVertical
extends ConveyorBasic {
    static AxisAlignedBB[] verticalBounds = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125), new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0), new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0)};
    public static ResourceLocation texture_on = new ResourceLocation("immersiveengineering:blocks/conveyor_vertical");
    public static ResourceLocation texture_off = new ResourceLocation("immersiveengineering:blocks/conveyor_vertical_off");

    @Override
    public boolean renderWall(TileEntity tile, EnumFacing facing, int wall) {
        return true;
    }

    @Override
    public boolean changeConveyorDirection() {
        return false;
    }

    @Override
    public boolean setConveyorDirection(ConveyorHandler.ConveyorDirection dir) {
        return false;
    }

    @Override
    public String getModelCacheKey(TileEntity tile, EnumFacing facing) {
        String key = ConveyorHandler.reverseClassRegistry.get(this.getClass()).toString();
        key = key + "f" + facing.ordinal();
        key = key + "a" + (this.isActive(tile) ? 1 : 0);
        key = key + "b" + (this.renderBottomBelt(tile, facing) ? "1" + (super.renderWall(tile, facing, 0) ? "1" : "0") + (super.renderWall(tile, facing, 1) ? "1" : "0") : "000");
        key = key + "c" + this.getDyeColour();
        return key;
    }

    boolean renderBottomBelt(TileEntity tile, EnumFacing facing) {
        TileEntity te = tile.func_145831_w().func_175625_s(tile.func_174877_v().func_177982_a(0, -1, 0));
        if (te instanceof ConveyorHandler.IConveyorTile && ((ConveyorHandler.IConveyorTile)te).getConveyorSubtype() != null) {
            for (EnumFacing f : ((ConveyorHandler.IConveyorTile)te).getConveyorSubtype().sigTransportDirections(te, ((ConveyorHandler.IConveyorTile)te).getFacing())) {
                if (f != EnumFacing.UP) continue;
                return false;
            }
        }
        for (EnumFacing f : EnumFacing.field_176754_o) {
            ConveyorHandler.IConveyorBelt sub;
            if (f == facing) continue;
            te = tile.func_145831_w().func_175625_s(tile.func_174877_v().func_177972_a(f));
            if (te instanceof ConveyorHandler.IConveyorTile && (sub = ((ConveyorHandler.IConveyorTile)te).getConveyorSubtype()) != null) {
                for (EnumFacing f2 : sub.sigTransportDirections(te, ((ConveyorHandler.IConveyorTile)te).getFacing())) {
                    if (f != f2.func_176734_d()) continue;
                    return true;
                }
            }
            if (!((te = tile.func_145831_w().func_175625_s(tile.func_174877_v().func_177982_a(0, -1, 0).func_177972_a(f))) instanceof ConveyorHandler.IConveyorTile) || (sub = ((ConveyorHandler.IConveyorTile)te).getConveyorSubtype()) == null) continue;
            int b = 0;
            for (EnumFacing f2 : sub.sigTransportDirections(te, ((ConveyorHandler.IConveyorTile)te).getFacing())) {
                if (f == f2.func_176734_d()) {
                    ++b;
                } else if (EnumFacing.UP == f2) {
                    ++b;
                }
                if (b != 2) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public EnumFacing[] sigTransportDirections(TileEntity conveyorTile, EnumFacing facing) {
        return new EnumFacing[]{EnumFacing.UP, facing};
    }

    @Override
    public Vec3d getDirection(TileEntity conveyorTile, Entity entity, EnumFacing facing) {
        BlockPos posWall = conveyorTile.func_174877_v().func_177972_a(facing);
        double d = 0.625 + (double)entity.field_70130_N;
        double distToWall = Math.abs((double)(facing.func_176740_k() == EnumFacing.Axis.Z ? posWall.func_177952_p() : posWall.func_177958_n()) + 0.5 - (facing.func_176740_k() == EnumFacing.Axis.Z ? entity.field_70161_v : entity.field_70165_t));
        if (distToWall > d) {
            return super.getDirection(conveyorTile, entity, facing);
        }
        double vBase = entity instanceof EntityLivingBase ? 1.5 : 1.15;
        double distY = Math.abs((double)conveyorTile.func_174877_v().func_177982_a(0, 1, 0).func_177956_o() + 0.5 - entity.field_70163_u);
        double treshold = 0.9;
        boolean contact = distY < treshold;
        double vX = entity.field_70159_w;
        double vY = 0.1 * vBase;
        double vZ = entity.field_70179_y;
        if (entity.field_70181_x < 0.0) {
            vY += entity.field_70181_x * 0.9;
        }
        if (!(entity instanceof EntityPlayer)) {
            vX = 0.05 * (double)facing.func_82601_c();
            vZ = 0.05 * (double)facing.func_82599_e();
            if (facing == EnumFacing.WEST || facing == EnumFacing.EAST) {
                if (entity.field_70161_v > (double)conveyorTile.func_174877_v().func_177952_p() + 0.65) {
                    vZ = -0.1 * vBase;
                } else if (entity.field_70161_v < (double)conveyorTile.func_174877_v().func_177952_p() + 0.35) {
                    vZ = 0.1 * vBase;
                }
            } else if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                if (entity.field_70165_t > (double)conveyorTile.func_174877_v().func_177958_n() + 0.65) {
                    vX = -0.1 * vBase;
                } else if (entity.field_70165_t < (double)conveyorTile.func_174877_v().func_177958_n() + 0.35) {
                    vX = 0.1 * vBase;
                }
            }
        }
        if (contact && !(conveyorTile.func_145831_w().func_175625_s(conveyorTile.func_174877_v().func_177982_a(0, 1, 0)) instanceof ConveyorHandler.IConveyorTile)) {
            vY *= 2.25;
        }
        return new Vec3d(vX, vY, vZ);
    }

    @Override
    public void onEntityCollision(TileEntity tile, Entity entity, EnumFacing facing) {
        if (!this.isActive(tile)) {
            return;
        }
        BlockPos posWall = tile.func_174877_v().func_177972_a(facing);
        double d = 0.625 + (double)entity.field_70130_N;
        double distToWall = Math.abs((double)(facing.func_176740_k() == EnumFacing.Axis.Z ? posWall.func_177952_p() : posWall.func_177958_n()) + 0.5 - (facing.func_176740_k() == EnumFacing.Axis.Z ? entity.field_70161_v : entity.field_70165_t));
        if (distToWall > d) {
            super.onEntityCollision(tile, entity, facing);
            return;
        }
        if (!(entity == null || entity.field_70128_L || entity instanceof EntityPlayer && entity.func_70093_af())) {
            double treshold;
            double distY = Math.abs((double)tile.func_174877_v().func_177982_a(0, 1, 0).func_177956_o() + 0.5 - entity.field_70163_u);
            boolean contact = distY < (treshold = 0.9);
            entity.field_70122_E = false;
            entity.field_70143_R = entity.field_70143_R < 3.0f ? 0.0f : (float)((double)entity.field_70143_R * 0.9);
            Vec3d vec = this.getDirection(tile, entity, facing);
            entity.field_70159_w = vec.field_72450_a;
            entity.field_70181_x = vec.field_72448_b;
            entity.field_70179_y = vec.field_72449_c;
            if (!contact) {
                ConveyorHandler.applyMagnetSupression(entity, (ConveyorHandler.IConveyorTile)tile);
            } else {
                BlockPos posTop = tile.func_174877_v().func_177982_a(0, 1, 0);
                if (!(tile.func_145831_w().func_175625_s(posTop) instanceof ConveyorHandler.IConveyorTile || tile.func_145831_w().func_175623_d(posTop) && tile.func_145831_w().func_175625_s(posTop.func_177972_a(facing)) instanceof ConveyorHandler.IConveyorTile)) {
                    ConveyorHandler.revertMagnetSupression(entity, (ConveyorHandler.IConveyorTile)tile);
                }
            }
            if (entity instanceof EntityItem) {
                ItemStack stack;
                ((EntityItem)entity).func_174873_u();
                TileEntity inventoryTile = tile.func_145831_w().func_175625_s(tile.func_174877_v().func_177982_a(0, 1, 0));
                if (!tile.func_145831_w().field_72995_K && contact && inventoryTile != null && !(inventoryTile instanceof ConveyorHandler.IConveyorTile) && !(stack = ((EntityItem)entity).func_92059_d()).func_190926_b()) {
                    ItemStack ret = Utils.insertStackIntoInventory(inventoryTile, stack, EnumFacing.DOWN);
                    if (ret.func_190926_b()) {
                        entity.func_70106_y();
                    } else if (ret.func_190916_E() < stack.func_190916_E()) {
                        ((EntityItem)entity).func_92058_a(ret);
                    }
                }
            }
        }
    }

    @Override
    public List<AxisAlignedBB> getSelectionBoxes(TileEntity tile, EnumFacing facing) {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        if (facing.ordinal() > 1) {
            list.add(verticalBounds[facing.ordinal() - 2]);
        }
        if (this.renderBottomBelt(tile, facing) || list.isEmpty()) {
            list.add(conveyorBounds);
        }
        return list;
    }

    @Override
    public List<AxisAlignedBB> getColisionBoxes(TileEntity tile, EnumFacing facing) {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        if (facing.ordinal() > 1) {
            list.add(verticalBounds[facing.ordinal() - 2]);
        }
        if (this.renderBottomBelt(tile, facing) || list.isEmpty()) {
            list.add(conveyorBounds);
        }
        return list;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Matrix4f modifyBaseRotationMatrix(Matrix4f matrix, TileEntity tile, EnumFacing facing) {
        return new Matrix4(matrix).translate(0.0, 1.0, 0.0).rotate(1.5707963267948966, 1.0, 0.0, 0.0).toMatrix4f();
    }

    @Override
    public ResourceLocation getActiveTexture() {
        return texture_on;
    }

    @Override
    public ResourceLocation getInactiveTexture() {
        return texture_off;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel, @Nullable TileEntity tile, EnumFacing facing) {
        if (tile != null && this.renderBottomBelt(tile, facing)) {
            TextureAtlasSprite sprite = ClientUtils.getSprite(this.isActive(tile) ? ConveyorBasic.texture_on : ConveyorBasic.texture_off);
            TextureAtlasSprite spriteColour = ClientUtils.getSprite(this.getColouredStripesTexture());
            boolean[] walls = new boolean[]{super.renderWall(tile, facing, 0), super.renderWall(tile, facing, 1)};
            baseModel.addAll(ModelConveyor.getBaseConveyor(facing, 0.875f, new Matrix4(facing), ConveyorHandler.ConveyorDirection.HORIZONTAL, sprite, walls, new boolean[]{true, false}, spriteColour, this.getDyeColour()));
        }
        return baseModel;
    }
}

