/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration1;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorBasic;
import blusunrize.immersiveengineering.common.blocks.wooden.BlockTypes_WoodenDecoration;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.util.vector.Vector3f;

public class ConveyorCovered
extends ConveyorBasic {
    public static ArrayList<Function<ItemStack, Boolean>> validCoveyorCovers = new ArrayList();
    public ItemStack cover = ItemStack.field_190927_a;
    static final ItemStack defaultCover;
    static final AxisAlignedBB topBox;

    @Override
    public void onEntityCollision(TileEntity tile, Entity entity, EnumFacing facing) {
        super.onEntityCollision(tile, entity, facing);
        if (entity instanceof EntityItem) {
            ((EntityItem)entity).func_174867_a(10);
        }
    }

    @Override
    public String getModelCacheKey(TileEntity tile, EnumFacing facing) {
        String key = super.getModelCacheKey(tile, facing);
        if (!this.cover.func_190926_b()) {
            key = key + "s" + this.cover.func_77973_b().getRegistryName() + this.cover.func_77960_j();
        }
        return key;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel, @Nullable TileEntity tile, EnumFacing facing) {
        ItemStack cover = !this.cover.func_190926_b() ? this.cover : defaultCover;
        Block b = Block.func_149634_a((Item)cover.func_77973_b());
        IBlockState state = !cover.func_190926_b() ? b.func_176203_a(cover.func_77960_j()) : Blocks.field_150348_b.func_176223_P();
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
        if (model != null) {
            TextureAtlasSprite sprite = model.func_177554_e();
            HashMap<EnumFacing, TextureAtlasSprite> sprites = new HashMap<EnumFacing, TextureAtlasSprite>();
            ConveyorHandler.ConveyorDirection conDir = this.getConveyorDirection();
            for (EnumFacing f2 : EnumFacing.field_82609_l) {
                for (BakedQuad q : model.func_188616_a(state, f2, 0L)) {
                    if (q == null || q.func_187508_a() == null) continue;
                    sprites.put(f2, q.func_187508_a());
                }
            }
            for (BakedQuad q : model.func_188616_a(state, null, 0L)) {
                if (q == null || q.func_187508_a() == null || q.func_178210_d() == null) continue;
                sprites.put(q.func_178210_d(), q.func_187508_a());
            }
            java.util.function.Function<EnumFacing, TextureAtlasSprite> getSprite = f -> sprites.containsKey(f) ? (TextureAtlasSprite)sprites.get(f) : sprite;
            java.util.function.Function<EnumFacing, TextureAtlasSprite> getSpriteHorizontal = f -> f.func_176740_k() == EnumFacing.Axis.Y ? null : (sprites.containsKey(f) ? (TextureAtlasSprite)sprites.get(f) : sprite);
            float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            Matrix4 matrix = new Matrix4(facing);
            boolean wallLeft = tile == null || this.renderWall(tile, facing, 0);
            boolean wallRight = tile == null || this.renderWall(tile, facing, 1);
            java.util.function.Function<Vector3f[], Vector3f[]> vertexTransformer = conDir == ConveyorHandler.ConveyorDirection.HORIZONTAL ? vertices -> vertices : vertices -> {
                Vector3f[] ret = new Vector3f[((Vector3f[])vertices).length];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = new Vector3f(vertices[i].x, vertices[i].y + (float)(vertices[i].z == (float)(conDir != ConveyorHandler.ConveyorDirection.UP ? 1 : 0) ? 1 : 0), vertices[i].z);
                }
                return ret;
            };
            baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.0f, 0.75f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f), matrix, facing, vertexTransformer, getSprite, colour));
            if (wallLeft) {
                baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.0f, 0.1875f, 0.0f), new Vector3f(0.0625f, 0.75f, 1.0f), matrix, facing, vertexTransformer, getSpriteHorizontal, colour));
            } else {
                baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.0f, 0.1875f, 0.0f), new Vector3f(0.0625f, 0.75f, 0.0625f), matrix, facing, getSpriteHorizontal, colour));
                baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.0f, 0.1875f, 0.9375f), new Vector3f(0.0625f, 0.75f, 1.0f), matrix, facing, getSpriteHorizontal, colour));
            }
            if (wallRight) {
                baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.9375f, 0.1875f, 0.0f), new Vector3f(1.0f, 0.75f, 1.0f), matrix, facing, vertexTransformer, getSpriteHorizontal, colour));
            } else {
                baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.9375f, 0.1875f, 0.0f), new Vector3f(1.0f, 0.75f, 0.0625f), matrix, facing, getSpriteHorizontal, colour));
                baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.9375f, 0.1875f, 0.9375f), new Vector3f(1.0f, 0.75f, 1.0f), matrix, facing, getSpriteHorizontal, colour));
            }
        }
        return baseModel;
    }

    @Override
    public boolean playerInteraction(TileEntity tile, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ, EnumFacing side) {
        if (heldItem.func_190926_b() && player.func_70093_af() && !this.cover.func_190926_b()) {
            EntityItem entityitem;
            if (!tile.func_145831_w().field_72995_K && tile.func_145831_w().func_82736_K().func_82766_b("doTileDrops") && (entityitem = player.func_71019_a(this.cover.func_77946_l(), false)) != null) {
                entityitem.func_174868_q();
            }
            this.cover = ItemStack.field_190927_a;
            return true;
        }
        if (!heldItem.func_190926_b() && !player.func_70093_af()) {
            for (Function<ItemStack, Boolean> func : validCoveyorCovers) {
                EntityItem entityitem;
                if (func.apply((Object)heldItem) != Boolean.TRUE || OreDictionary.itemMatches((ItemStack)this.cover, (ItemStack)heldItem, (boolean)true)) continue;
                if (!tile.func_145831_w().field_72995_K && !this.cover.func_190926_b() && tile.func_145831_w().func_82736_K().func_82766_b("doTileDrops") && (entityitem = player.func_71019_a(this.cover.func_77946_l(), false)) != null) {
                    entityitem.func_174868_q();
                }
                this.cover = Utils.copyStackWithAmount(heldItem, 1);
                heldItem.func_190918_g(1);
                if (heldItem.func_190916_E() <= 0) {
                    player.func_184611_a(hand, heldItem);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public List<AxisAlignedBB> getColisionBoxes(TileEntity tile, EnumFacing facing) {
        ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{conveyorBounds});
        if (this.getConveyorDirection() == ConveyorHandler.ConveyorDirection.HORIZONTAL) {
            list.add(topBox);
        } else {
            boolean up = this.getConveyorDirection() == ConveyorHandler.ConveyorDirection.UP;
            list.add(new AxisAlignedBB(facing == EnumFacing.WEST && !up || facing == EnumFacing.EAST && up ? 0.5 : 0.0, 1.75, facing == EnumFacing.NORTH && !up || facing == EnumFacing.SOUTH && up ? 0.5 : 0.0, facing == EnumFacing.WEST && up || facing == EnumFacing.EAST && !up ? 0.5 : 1.0, 2.0, facing == EnumFacing.NORTH && up || facing == EnumFacing.SOUTH && !up ? 0.5 : 1.0));
            list.add(new AxisAlignedBB(facing == EnumFacing.WEST && up || facing == EnumFacing.EAST && !up ? 0.5 : 0.0, 1.25, facing == EnumFacing.NORTH && up || facing == EnumFacing.SOUTH && !up ? 0.5 : 0.0, facing == EnumFacing.WEST && !up || facing == EnumFacing.EAST && up ? 0.5 : 1.0, 1.5, facing == EnumFacing.NORTH && !up || facing == EnumFacing.SOUTH && up ? 0.5 : 1.0));
        }
        return list;
    }

    @Override
    public List<AxisAlignedBB> getSelectionBoxes(TileEntity tile, EnumFacing facing) {
        if (this.getConveyorDirection() == ConveyorHandler.ConveyorDirection.HORIZONTAL) {
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{Block.field_185505_j});
        }
        boolean up = this.getConveyorDirection() == ConveyorHandler.ConveyorDirection.UP;
        ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(facing == EnumFacing.WEST && !up || facing == EnumFacing.EAST && up ? 0.5 : 0.0, 0.5, facing == EnumFacing.NORTH && !up || facing == EnumFacing.SOUTH && up ? 0.5 : 0.0, facing == EnumFacing.WEST && up || facing == EnumFacing.EAST && !up ? 0.5 : 1.0, 2.0, facing == EnumFacing.NORTH && up || facing == EnumFacing.SOUTH && !up ? 0.5 : 1.0), new AxisAlignedBB(facing == EnumFacing.WEST && up || facing == EnumFacing.EAST && !up ? 0.5 : 0.0, 0.0, facing == EnumFacing.NORTH && up || facing == EnumFacing.SOUTH && !up ? 0.5 : 0.0, facing == EnumFacing.WEST && !up || facing == EnumFacing.EAST && up ? 0.5 : 1.0, 1.5, facing == EnumFacing.NORTH && !up || facing == EnumFacing.SOUTH && up ? 0.5 : 1.0)});
        return list;
    }

    @Override
    public NBTTagCompound writeConveyorNBT() {
        NBTTagCompound nbt = super.writeConveyorNBT();
        if (this.cover != null) {
            nbt.func_74782_a("cover", (NBTBase)this.cover.func_77955_b(new NBTTagCompound()));
        }
        return nbt;
    }

    @Override
    public void readConveyorNBT(NBTTagCompound nbt) {
        super.readConveyorNBT(nbt);
        this.cover = new ItemStack(nbt.func_74775_l("cover"));
    }

    static {
        final ArrayList scaffolds = Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Block)IEContent.blockWoodenDecoration, 1, BlockTypes_WoodenDecoration.SCAFFOLDING.getMeta()), new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_1.getMeta()), new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_2.getMeta()), new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.ALUMINUM_SCAFFOLDING_0.getMeta()), new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.ALUMINUM_SCAFFOLDING_1.getMeta()), new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.ALUMINUM_SCAFFOLDING_2.getMeta())});
        validCoveyorCovers.add(new Function<ItemStack, Boolean>(){

            @Nullable
            public Boolean apply(@Nullable ItemStack input) {
                if (input == null) {
                    return Boolean.FALSE;
                }
                for (ItemStack stack : scaffolds) {
                    if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)input, (boolean)false)) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        validCoveyorCovers.add((Function<ItemStack, Boolean>)((Function)input -> input == null ? Boolean.FALSE : Utils.compareToOreName(input, "blockGlass")));
        defaultCover = new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_0.getMeta());
        topBox = new AxisAlignedBB(0.0, 0.75, 0.0, 1.0, 1.0, 1.0);
    }
}

