/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.tool.ITeslaEntity;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IEPotions;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTeslaCoil
extends TileEntityIEBase
implements ITickable,
EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IHammerInteraction {
    public boolean dummy = false;
    public FluxStorage energyStorage = new FluxStorage(48000);
    public boolean redstoneControlInverted = false;
    public EnumFacing facing = EnumFacing.UP;
    public boolean lowPower = false;
    private Vec3d soundPos = null;
    @SideOnly(value=Side.CLIENT)
    public static ArrayListMultimap<BlockPos, LightningAnimation> effectMap;
    AxisAlignedBB renderBB;
    EnergyHelper.IEForgeEnergyWrapper[] wrappers = EnergyHelper.IEForgeEnergyWrapper.getDefaultWrapperArray(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_73660_a() {
        if (this.dummy) {
            return;
        }
        TileEntityTeslaCoil tileEntityTeslaCoil = this;
        synchronized (tileEntityTeslaCoil) {
            if (this.field_145850_b.field_72995_K && this.soundPos != null) {
                this.field_145850_b.func_184134_a(this.soundPos.field_72450_a, this.soundPos.field_72448_b, this.soundPos.field_72449_c, IESounds.tesla, SoundCategory.BLOCKS, 2.5f, 0.5f + this.field_145850_b.field_73012_v.nextFloat(), true);
                this.soundPos = null;
            }
        }
        int timeKey = this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p();
        int energyDrain = Config.IEConfig.Machines.teslacoil_consumption;
        if (this.lowPower) {
            energyDrain /= 2;
        }
        if (this.field_145850_b.func_82737_E() % 32L == (long)(timeKey & 0x1F) && this.canRun(energyDrain)) {
            List targets;
            if (!this.field_145850_b.field_72995_K) {
                this.energyStorage.extractEnergy(energyDrain, false);
            }
            double radius = 6.0;
            if (this.lowPower) {
                radius /= 2.0;
            }
            AxisAlignedBB aabbSmall = new AxisAlignedBB((double)this.func_174877_v().func_177958_n() + 0.5 - radius, (double)this.func_174877_v().func_177956_o() + 0.5 - radius, (double)this.func_174877_v().func_177952_p() + 0.5 - radius, (double)this.func_174877_v().func_177958_n() + 0.5 + radius, (double)this.func_174877_v().func_177956_o() + 0.5 + radius, (double)this.func_174877_v().func_177952_p() + 0.5 + radius);
            AxisAlignedBB aabb = aabbSmall.func_72314_b(radius / 2.0, radius / 2.0, radius / 2.0);
            List targetsAll = this.field_145850_b.func_72872_a(Entity.class, aabb);
            if (!this.field_145850_b.field_72995_K) {
                for (Entity e2 : targetsAll) {
                    if (!(e2 instanceof ITeslaEntity)) continue;
                    ((ITeslaEntity)e2).onHit(this, this.lowPower);
                }
            }
            if (!(targets = targetsAll.stream().filter(e -> e instanceof EntityLivingBase && aabbSmall.func_72326_a(e.func_174813_aQ())).collect(Collectors.toList())).isEmpty()) {
                IEDamageSources.TeslaDamageSource dmgsrc = IEDamageSources.causeTeslaDamage(Config.IEConfig.Machines.teslacoil_damage, this.lowPower);
                int randomTarget = this.field_145850_b.field_73012_v.nextInt(targets.size());
                EntityLivingBase target = (EntityLivingBase)targets.get(randomTarget);
                if (target != null && !this.field_145850_b.field_72995_K) {
                    energyDrain = Config.IEConfig.Machines.teslacoil_consumption_active;
                    if (this.lowPower) {
                        energyDrain /= 2;
                    }
                    if (this.energyStorage.extractEnergy(energyDrain, true) == energyDrain) {
                        this.energyStorage.extractEnergy(energyDrain, false);
                        if (dmgsrc.apply((Entity)target)) {
                            int prevFire = target.field_190534_ay;
                            target.field_190534_ay = 1;
                            target.func_70690_d(new PotionEffect(IEPotions.stunned, 128));
                            target.field_190534_ay = prevFire;
                        }
                        this.sendRenderPacket((Entity)target);
                    }
                }
            } else if (this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 128L == (long)(timeKey & 0x7F)) {
                double tV = (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 8.0;
                double tH = (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 8.0;
                if (this.lowPower) {
                    tV /= 2.0;
                    tH /= 2.0;
                }
                BlockPos targetBlock = this.func_174877_v().func_177963_a(this.facing.func_176740_k() == EnumFacing.Axis.X ? 0.0 : (tH += tH < 0.0 ? -2.0 : 2.0), this.facing.func_176740_k() == EnumFacing.Axis.Y ? 0.0 : (tV += tV < 0.0 ? -2.0 : 2.0), this.facing.func_176740_k() == EnumFacing.Axis.Y ? tV : (this.facing.func_176740_k() == EnumFacing.Axis.X ? tH : 0.0));
                double tL = 0.0;
                boolean targetFound = false;
                if (!this.field_145850_b.func_175623_d(targetBlock)) {
                    IBlockState state = this.field_145850_b.func_180495_p(targetBlock);
                    AxisAlignedBB blockBounds = state.func_185900_c((IBlockAccess)this.field_145850_b, targetBlock);
                    tL = this.facing == EnumFacing.UP ? (double)(targetBlock.func_177956_o() - this.func_174877_v().func_177956_o()) + blockBounds.field_72337_e : (this.facing == EnumFacing.DOWN ? (double)(targetBlock.func_177956_o() - this.func_174877_v().func_177956_o()) + blockBounds.field_72338_b : (this.facing == EnumFacing.NORTH ? (double)(targetBlock.func_177952_p() - this.func_174877_v().func_177952_p()) + blockBounds.field_72339_c : (this.facing == EnumFacing.SOUTH ? (double)(targetBlock.func_177952_p() - this.func_174877_v().func_177952_p()) + blockBounds.field_72334_f : (this.facing == EnumFacing.WEST ? (double)(targetBlock.func_177958_n() - this.func_174877_v().func_177958_n()) + blockBounds.field_72340_a : (double)(targetBlock.func_177958_n() - this.func_174877_v().func_177958_n()) + blockBounds.field_72336_d))));
                    targetFound = true;
                } else {
                    boolean positiveFirst = this.field_145850_b.field_73012_v.nextBoolean();
                    for (int i = 0; i < 2; ++i) {
                        for (int ll = 0; ll <= 6; ++ll) {
                            EnumFacing tempF;
                            BlockPos targetBlock2 = targetBlock.func_177967_a(positiveFirst ? this.facing : this.facing.func_176734_d(), ll);
                            if (this.field_145850_b.func_175623_d(targetBlock2)) continue;
                            IBlockState state = this.field_145850_b.func_180495_p(targetBlock2);
                            AxisAlignedBB blockBounds = state.func_185900_c((IBlockAccess)this.field_145850_b, targetBlock2);
                            tL = this.facing.func_176740_k() == EnumFacing.Axis.Y ? (double)(targetBlock2.func_177956_o() - this.func_174877_v().func_177956_o()) : (this.facing.func_176740_k() == EnumFacing.Axis.Z ? (double)(targetBlock2.func_177952_p() - this.func_174877_v().func_177952_p()) : (double)(targetBlock2.func_177952_p() - this.func_174877_v().func_177952_p()));
                            EnumFacing enumFacing = tempF = positiveFirst ? this.facing : this.facing.func_176734_d();
                            tL = tempF == EnumFacing.UP ? (tL += blockBounds.field_72337_e) : (tempF == EnumFacing.DOWN ? (tL += blockBounds.field_72338_b) : (tempF == EnumFacing.NORTH ? (tL += blockBounds.field_72339_c) : (tempF == EnumFacing.SOUTH ? (tL += blockBounds.field_72334_f) : (tempF == EnumFacing.WEST ? (tL += blockBounds.field_72340_a) : (tL += blockBounds.field_72336_d)))));
                            targetFound = true;
                            break;
                        }
                        if (targetFound) break;
                        positiveFirst = !positiveFirst;
                    }
                }
                if (targetFound) {
                    double ty;
                    double tx = this.facing.func_176740_k() == EnumFacing.Axis.X ? tL : tH;
                    double d = ty = this.facing.func_176740_k() == EnumFacing.Axis.Y ? tL : tV;
                    double tz = this.facing.func_176740_k() == EnumFacing.Axis.Y ? tV : (this.facing.func_176740_k() == EnumFacing.Axis.X ? tH : tL);
                    EnumFacing f = null;
                    f = this.facing.func_176740_k() == EnumFacing.Axis.Y ? (Math.abs(tz) > Math.abs(tx) ? (tz < 0.0 ? EnumFacing.NORTH : EnumFacing.SOUTH) : (tx < 0.0 ? EnumFacing.WEST : EnumFacing.EAST)) : (this.facing.func_176740_k() == EnumFacing.Axis.Z ? (Math.abs(ty) > Math.abs(tx) ? (ty < 0.0 ? EnumFacing.DOWN : EnumFacing.UP) : (tx < 0.0 ? EnumFacing.WEST : EnumFacing.EAST)) : (Math.abs(ty) > Math.abs(tz) ? (ty < 0.0 ? EnumFacing.DOWN : EnumFacing.UP) : (tz < 0.0 ? EnumFacing.NORTH : EnumFacing.SOUTH)));
                    double verticalOffset = 1.0 + this.field_145850_b.field_73012_v.nextDouble() * 0.25;
                    Vec3d coilPos = new Vec3d((Vec3i)this.func_174877_v()).func_72441_c(0.5, 0.5, 0.5);
                    coilPos = coilPos.func_72441_c((double)this.facing.func_82601_c() * verticalOffset, (double)this.facing.func_96559_d() * verticalOffset, (double)this.facing.func_82599_e() * verticalOffset);
                    if (f != null) {
                        coilPos = coilPos.func_72441_c((double)f.func_82601_c() * 0.375, (double)f.func_96559_d() * 0.375, (double)f.func_82599_e() * 0.375);
                        f = f.func_176732_a(this.facing.func_176740_k());
                        double dShift = (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 0.75;
                        coilPos = coilPos.func_72441_c((double)f.func_82601_c() * dShift, (double)f.func_96559_d() * dShift, (double)f.func_82599_e() * dShift);
                    }
                    effectMap.put((Object)this.func_174877_v(), (Object)new LightningAnimation(coilPos, new Vec3d((Vec3i)this.func_174877_v()).func_72441_c(tx, ty, tz)));
                    this.field_145850_b.func_184134_a(coilPos.field_72450_a, coilPos.field_72448_b, coilPos.field_72449_c, IESounds.tesla, SoundCategory.BLOCKS, 2.5f, 0.5f + this.field_145850_b.field_73012_v.nextFloat(), true);
                }
            }
            this.func_70296_d();
        }
    }

    protected void sendRenderPacket(Entity target) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("targetEntity", target.func_145782_y());
        ImmersiveEngineering.packetHandler.sendToAll((IMessage)new MessageTileSync(this, tag));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveMessageFromServer(NBTTagCompound message) {
        Entity target;
        if (message.func_74764_b("targetEntity") && (target = this.field_145850_b.func_73045_a(message.func_74762_e("targetEntity"))) instanceof EntityLivingBase) {
            double dx = target.field_70165_t - (double)this.func_174877_v().func_177958_n();
            double dy = target.field_70163_u - (double)this.func_174877_v().func_177956_o();
            double dz = target.field_70161_v - (double)this.func_174877_v().func_177952_p();
            EnumFacing f = null;
            f = this.facing.func_176740_k() == EnumFacing.Axis.Y ? (Math.abs(dz) > Math.abs(dx) ? (dz < 0.0 ? EnumFacing.NORTH : EnumFacing.SOUTH) : (dx < 0.0 ? EnumFacing.WEST : EnumFacing.EAST)) : (this.facing.func_176740_k() == EnumFacing.Axis.Z ? (Math.abs(dy) > Math.abs(dx) ? (dy < 0.0 ? EnumFacing.DOWN : EnumFacing.UP) : (dx < 0.0 ? EnumFacing.WEST : EnumFacing.EAST)) : (Math.abs(dy) > Math.abs(dz) ? (dy < 0.0 ? EnumFacing.DOWN : EnumFacing.UP) : (dz < 0.0 ? EnumFacing.NORTH : EnumFacing.SOUTH)));
            double verticalOffset = 1.0 + this.field_145850_b.field_73012_v.nextDouble() * 0.25;
            Vec3d coilPos = new Vec3d((Vec3i)this.func_174877_v()).func_72441_c(0.5, 0.5, 0.5);
            coilPos = coilPos.func_72441_c((double)this.facing.func_82601_c() * verticalOffset, (double)this.facing.func_96559_d() * verticalOffset, (double)this.facing.func_82599_e() * verticalOffset);
            if (f != null) {
                coilPos = coilPos.func_72441_c((double)f.func_82601_c() * 0.375, (double)f.func_96559_d() * 0.375, (double)f.func_82599_e() * 0.375);
                f = f.func_176732_a(this.facing.func_176740_k());
                double dShift = (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 0.75;
                coilPos = coilPos.func_72441_c((double)f.func_82601_c() * dShift, (double)f.func_96559_d() * dShift, (double)f.func_82599_e() * dShift);
            }
            effectMap.put((Object)this.func_174877_v(), (Object)new LightningAnimation(coilPos, (EntityLivingBase)target));
            TileEntityTeslaCoil tileEntityTeslaCoil = this;
            synchronized (tileEntityTeslaCoil) {
                this.soundPos = coilPos;
            }
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.dummy = nbt.func_74767_n("dummy");
        this.redstoneControlInverted = nbt.func_74767_n("redstoneInverted");
        this.lowPower = nbt.func_74767_n("lowPower");
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74757_a("dummy", this.dummy);
        nbt.func_74757_a("redstoneInverted", this.redstoneControlInverted);
        nbt.func_74757_a("lowPower", this.lowPower);
        if (this.facing != null) {
            nbt.func_74768_a("facing", this.facing.ordinal());
        }
        this.energyStorage.writeToNBT(nbt);
    }

    @Override
    public float[] getBlockBounds() {
        if (!this.dummy) {
            return null;
        }
        switch (this.facing) {
            case DOWN: {
                return new float[]{0.125f, 0.125f, 0.125f, 0.875f, 1.0f, 0.875f};
            }
            case UP: {
                return new float[]{0.125f, 0.0f, 0.125f, 0.875f, 0.875f, 0.875f};
            }
            case NORTH: {
                return new float[]{0.125f, 0.125f, 0.125f, 0.875f, 0.875f, 1.0f};
            }
            case SOUTH: {
                return new float[]{0.125f, 0.125f, 0.0f, 0.875f, 0.875f, 0.875f};
            }
            case WEST: {
                return new float[]{0.125f, 0.125f, 0.125f, 1.0f, 0.875f, 0.875f};
            }
            case EAST: {
                return new float[]{0.0f, 0.125f, 0.125f, 0.875f, 0.875f, 0.875f};
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderBB == null) {
            this.renderBB = new AxisAlignedBB(this.func_174877_v().func_177982_a(-8, -8, -8), this.func_174877_v().func_177982_a(8, 8, 8));
        }
        return this.renderBB;
    }

    @Override
    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (this.dummy) {
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(this.facing, -1));
            if (te instanceof TileEntityTeslaCoil) {
                return ((TileEntityTeslaCoil)te).hammerUseSide(side, player, hitX, hitY, hitZ);
            }
            return false;
        }
        if (player.func_70093_af()) {
            int energyDrain = Config.IEConfig.Machines.teslacoil_consumption;
            if (this.lowPower) {
                energyDrain /= 2;
            }
            if (this.canRun(energyDrain)) {
                player.func_70097_a(IEDamageSources.causeTeslaPrimaryDamage(), Float.MAX_VALUE);
            } else {
                this.lowPower = !this.lowPower;
                ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.tesla." + (this.lowPower ? "lowPower" : "highPower"), new Object[0])});
                this.func_70296_d();
            }
        } else {
            this.redstoneControlInverted = !this.redstoneControlInverted;
            ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.rsControl." + (this.redstoneControlInverted ? "invertedOn" : "invertedOff"), new Object[0])});
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
        }
        return true;
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 0;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return false;
    }

    @Override
    public boolean isDummy() {
        return this.dummy;
    }

    @Override
    public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.field_145850_b.func_175656_a(pos.func_177972_a(this.facing), state);
        ((TileEntityTeslaCoil)this.field_145850_b.func_175625_s((BlockPos)pos.func_177972_a((EnumFacing)this.facing))).dummy = true;
        ((TileEntityTeslaCoil)this.field_145850_b.func_175625_s((BlockPos)pos.func_177972_a((EnumFacing)this.facing))).facing = this.facing;
    }

    @Override
    public void breakDummies(BlockPos pos, IBlockState state) {
        for (int i = 0; i <= 1; ++i) {
            if (!(this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(this.facing, this.dummy ? -1 : 0).func_177967_a(this.facing, i)) instanceof TileEntityTeslaCoil)) continue;
            this.field_145850_b.func_175698_g(this.func_174877_v().func_177967_a(this.facing, this.dummy ? -1 : 0).func_177967_a(this.facing, i));
        }
    }

    @Override
    @Nonnull
    public FluxStorage getFluxStorage() {
        TileEntity te;
        if (this.dummy && (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(this.facing, -1))) instanceof TileEntityTeslaCoil) {
            return ((TileEntityTeslaCoil)te).getFluxStorage();
        }
        return this.energyStorage;
    }

    @Override
    @Nonnull
    public IEEnums.SideConfig getEnergySideConfig(EnumFacing facing) {
        return !this.dummy ? IEEnums.SideConfig.INPUT : IEEnums.SideConfig.NONE;
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(EnumFacing facing) {
        if (!this.dummy) {
            return this.wrappers[facing == null ? 0 : facing.ordinal()];
        }
        return null;
    }

    public boolean canRun(int energyDrain) {
        return this.field_145850_b.func_175687_A(this.func_174877_v()) > 0 ^ this.redstoneControlInverted && this.energyStorage.getEnergyStored() >= energyDrain;
    }

    public static class LightningAnimation {
        public Vec3d startPos;
        public EntityLivingBase targetEntity;
        public Vec3d targetPos;
        public int timer = 40;
        public List<Vec3d> subPoints = new ArrayList<Vec3d>();
        private Vec3d prevTarget;

        public LightningAnimation(Vec3d startPos, EntityLivingBase targetEntity) {
            this.startPos = startPos;
            this.targetEntity = targetEntity;
        }

        public LightningAnimation(Vec3d startPos, Vec3d targetPos) {
            this.startPos = startPos;
            this.targetPos = targetPos;
        }

        public boolean shoudlRecalculateLightning() {
            Vec3d end;
            if (this.subPoints.isEmpty() || this.timer % 8 == 0) {
                return true;
            }
            boolean b = false;
            Vec3d vec3d = end = this.targetEntity != null ? this.targetEntity.func_174791_d() : this.targetPos;
            if (this.prevTarget != null) {
                b = this.prevTarget.func_72438_d(end) > 1.0;
            }
            this.prevTarget = end;
            return b;
        }

        public void createLightning(Random rand) {
            this.subPoints.clear();
            Vec3d end = this.targetEntity != null ? this.targetEntity.func_174791_d() : this.targetPos;
            Vec3d dist = end.func_178788_d(this.startPos);
            double points = 12.0;
            int i = 0;
            while ((double)i < points) {
                Vec3d sub = this.startPos.func_72441_c(dist.field_72450_a / points * (double)i, dist.field_72448_b / points * (double)i, dist.field_72449_c / points * (double)i);
                double fixPointDist = ((double)i - points / 2.0) / (points / 2.0);
                double mod = 1.0 - 0.75 * Math.abs(fixPointDist);
                double offX = (rand.nextDouble() - 0.5) * mod;
                double offY = (rand.nextDouble() - 0.5) * mod;
                double offZ = (rand.nextDouble() - 0.5) * mod;
                if (fixPointDist < 0.0) {
                    offY += 0.75 * mod * (0.75 + fixPointDist);
                    offX = sub.field_72450_a - this.startPos.field_72450_a < 0.0 ? -Math.abs(offX) : Math.abs(offX);
                    offZ = sub.field_72449_c - this.startPos.field_72449_c < 0.0 ? -Math.abs(offZ) : Math.abs(offZ);
                } else {
                    offY = Math.min(end.field_72448_b + 1.0 * (1.0 - fixPointDist) * -Math.signum(dist.field_72448_b), offY);
                    offX = Math.abs(offX) * (end.field_72450_a - sub.field_72450_a);
                    offZ = Math.abs(offZ) * (end.field_72449_c - sub.field_72449_c);
                }
                this.subPoints.add(sub.func_72441_c(offX, offY, offZ));
                ++i;
            }
        }
    }
}

