/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorageAdvanced;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;

public abstract class TileEntityMultiblockMetal<T extends TileEntityMultiblockMetal<T, R>, R extends IMultiblockRecipe>
extends TileEntityMultiblockPart<T>
implements IIEInventory,
EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IMirrorAble,
IEBlockInterfaces.IProcessTile {
    protected final int[] structureDimensions;
    public final FluxStorageAdvanced energyStorage;
    protected final boolean hasRedstoneControl;
    protected final MultiblockHandler.IMultiblock mutliblockInstance;
    protected boolean redstoneControlInverted = false;
    public int controllingComputers = 0;
    public boolean computerOn = true;
    EnergyHelper.IEForgeEnergyWrapper wrapper = new EnergyHelper.IEForgeEnergyWrapper(this, null);
    public List<MultiblockProcess<R>> processQueue = new ArrayList<MultiblockProcess<R>>();
    public int tickedProcesses = 0;

    public TileEntityMultiblockMetal(MultiblockHandler.IMultiblock mutliblockInstance, int[] structureDimensions, int energyCapacity, boolean redstoneControl) {
        this.structureDimensions = structureDimensions;
        this.energyStorage = new FluxStorageAdvanced(energyCapacity);
        this.hasRedstoneControl = redstoneControl;
        this.mutliblockInstance = mutliblockInstance;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.energyStorage.readFromNBT(nbt);
        this.redstoneControlInverted = nbt.func_74767_n("redstoneControlInverted");
        NBTTagList processNBT = nbt.func_150295_c("processQueue", 10);
        this.processQueue.clear();
        for (int i = 0; i < processNBT.func_74745_c(); ++i) {
            NBTTagCompound tag = processNBT.func_150305_b(i);
            R recipe = this.readRecipeFromNBT(tag);
            if (recipe == null) continue;
            int processTick = tag.func_74762_e("process_processTick");
            MultiblockProcess process = this.loadProcessFromNBT(tag);
            if (process == null) continue;
            process.processTick = processTick;
            this.processQueue.add(process);
        }
        if (descPacket) {
            this.controllingComputers = nbt.func_74767_n("computerControlled") ? 1 : 0;
            this.computerOn = nbt.func_74767_n("computerOn");
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        this.energyStorage.writeToNBT(nbt);
        nbt.func_74757_a("redstoneControlInverted", this.redstoneControlInverted);
        NBTTagList processNBT = new NBTTagList();
        for (MultiblockProcess<R> process : this.processQueue) {
            processNBT.func_74742_a((NBTBase)this.writeProcessToNBT(process));
        }
        nbt.func_74782_a("processQueue", (NBTBase)processNBT);
        if (descPacket) {
            nbt.func_74757_a("computerControlled", this.controllingComputers > 0);
            nbt.func_74757_a("computerOn", this.computerOn);
        }
    }

    protected abstract R readRecipeFromNBT(NBTTagCompound var1);

    protected MultiblockProcess loadProcessFromNBT(NBTTagCompound tag) {
        R recipe = this.readRecipeFromNBT(tag);
        if (recipe != null) {
            if (this.isInWorldProcessingMachine()) {
                return new MultiblockProcessInWorld<R>(recipe, tag.func_74760_g("process_transformationPoint"), Utils.loadItemStacksFromNBT(tag.func_74781_a("process_inputItem")));
            }
            return new MultiblockProcessInMachine<R>(recipe, tag.func_74759_k("process_inputSlots")).setInputTanks(tag.func_74759_k("process_inputTanks"));
        }
        return null;
    }

    protected NBTTagCompound writeProcessToNBT(MultiblockProcess process) {
        NBTTagCompound tag = process.recipe.writeToNBT(new NBTTagCompound());
        tag.func_74768_a("process_processTick", process.processTick);
        process.writeExtraDataToNBT(tag);
        return tag;
    }

    public abstract int[] getEnergyPos();

    public boolean isEnergyPos() {
        for (int i : this.getEnergyPos()) {
            if (this.field_174879_c != i) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public FluxStorage getFluxStorage() {
        TileEntityMultiblockMetal master = (TileEntityMultiblockMetal)this.master();
        if (master != null) {
            return master.energyStorage;
        }
        return this.energyStorage;
    }

    @Override
    @Nonnull
    public IEEnums.SideConfig getEnergySideConfig(EnumFacing facing) {
        return this.formed && this.isEnergyPos() ? IEEnums.SideConfig.INPUT : IEEnums.SideConfig.NONE;
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(EnumFacing facing) {
        if (this.formed && this.isEnergyPos()) {
            return this.wrapper;
        }
        return null;
    }

    @Override
    public void postEnergyTransferUpdate(int energy, boolean simulate) {
        if (!simulate) {
            this.updateMasterBlock(null, energy != 0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (!this.isDummy()) {
            BlockPos nullPos = this.getBlockPosForPos(0);
            return new AxisAlignedBB(nullPos, nullPos.func_177967_a(this.facing, this.structureDimensions[1]).func_177967_a(this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e(), this.structureDimensions[2]).func_177981_b(this.structureDimensions[0]));
        }
        return super.getRenderBoundingBox();
    }

    public abstract int[] getRedstonePos();

    public boolean isRedstonePos() {
        if (!this.hasRedstoneControl || this.getRedstonePos() == null) {
            return false;
        }
        for (int i : this.getRedstonePos()) {
            if (this.field_174879_c != i) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (this.isRedstonePos()) {
            TileEntityMultiblockMetal master = (TileEntityMultiblockMetal)this.master();
            master.redstoneControlInverted = !master.redstoneControlInverted;
            ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.rsControl." + (master.redstoneControlInverted ? "invertedOn" : "invertedOff"), new Object[0])});
            this.updateMasterBlock(null, true);
            return true;
        }
        return false;
    }

    public boolean isRSDisabled() {
        if (this.controllingComputers > 0 && !this.computerOn) {
            return true;
        }
        int[] rsPositions = this.getRedstonePos();
        if (rsPositions == null || rsPositions.length < 1) {
            return false;
        }
        for (int rsPos : rsPositions) {
            T tile = this.getTileForPos(rsPos);
            if (tile == null) continue;
            boolean b = this.field_145850_b.func_175687_A(tile.func_174877_v()) > 0;
            return this.redstoneControlInverted != b;
        }
        return false;
    }

    public BlockPos getBlockPosForPos(int targetPos) {
        int blocksPerLevel = this.structureDimensions[1] * this.structureDimensions[2];
        int distH = targetPos / blocksPerLevel - this.field_174879_c / blocksPerLevel;
        int distL = targetPos % blocksPerLevel / this.structureDimensions[2] - this.field_174879_c % blocksPerLevel / this.structureDimensions[2];
        int distW = targetPos % this.structureDimensions[2] - this.field_174879_c % this.structureDimensions[2];
        int w = this.mirrored ? -distW : distW;
        return this.func_174877_v().func_177967_a(this.facing, distL).func_177967_a(this.facing.func_176746_e(), w).func_177982_a(0, distH, 0);
    }

    public T getTileForPos(int targetPos) {
        BlockPos target = this.getBlockPosForPos(targetPos);
        TileEntity tile = this.field_145850_b.func_175625_s(target);
        if (this.getClass().isInstance(tile)) {
            return (T)((TileEntityMultiblockMetal)tile);
        }
        return null;
    }

    @Override
    public ItemStack getOriginalBlock() {
        if (this.field_174879_c < 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack s = ItemStack.field_190927_a;
        try {
            int blocksPerLevel = this.structureDimensions[1] * this.structureDimensions[2];
            int h = this.field_174879_c / blocksPerLevel;
            int l = this.field_174879_c % blocksPerLevel / this.structureDimensions[2];
            int w = this.field_174879_c % this.structureDimensions[2];
            s = this.mutliblockInstance.getStructureManual()[h][l][w];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s.func_77946_l();
    }

    @Override
    public void disassemble() {
        if (this.formed && !this.field_145850_b.field_72995_K) {
            BlockPos startPos = this.getBlockPosForPos(0);
            for (int yy = 0; yy < this.structureDimensions[0]; ++yy) {
                for (int ll = 0; ll < this.structureDimensions[1]; ++ll) {
                    for (int ww = 0; ww < this.structureDimensions[2]; ++ww) {
                        IBlockState state;
                        int w = this.mirrored ? -ww : ww;
                        BlockPos pos = startPos.func_177967_a(this.facing, ll).func_177967_a(this.facing.func_176746_e(), w).func_177982_a(0, yy, 0);
                        ItemStack s = ItemStack.field_190927_a;
                        TileEntity te = this.field_145850_b.func_175625_s(pos);
                        if (te instanceof TileEntityMultiblockMetal) {
                            s = ((TileEntityMultiblockMetal)te).getOriginalBlock();
                            ((TileEntityMultiblockMetal)te).formed = false;
                        }
                        if (pos.equals((Object)this.func_174877_v())) {
                            s = this.getOriginalBlock();
                        }
                        if ((state = Utils.getStateFromItemStack(s)) == null) continue;
                        if (pos.equals((Object)this.func_174877_v())) {
                            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, s));
                            continue;
                        }
                        this.replaceStructureBlock(pos, state, s, yy, ll, ww);
                    }
                }
            }
        }
    }

    public void replaceStructureBlock(BlockPos pos, IBlockState state, ItemStack stack, int h, int l, int w) {
        if (state.func_177230_c() == this.func_145838_q()) {
            this.field_145850_b.func_175698_g(pos);
        }
        this.field_145850_b.func_175656_a(pos, state);
        TileEntity tile = this.field_145850_b.func_175625_s(pos);
        if (tile instanceof IEBlockInterfaces.ITileDrop) {
            ((IEBlockInterfaces.ITileDrop)tile).readOnPlacement(null, stack);
        }
    }

    @Override
    public boolean getIsMirrored() {
        return this.mirrored;
    }

    @Override
    public IEProperties.PropertyBoolInverted getBoolProperty(Class<? extends IEBlockInterfaces.IUsesBooleanProperty> inf) {
        return IEProperties.BOOLEANS[0];
    }

    public void func_73660_a() {
        this.tickedProcesses = 0;
        if (this.field_145850_b.field_72995_K || this.isDummy() || this.isRSDisabled()) {
            return;
        }
        int max = this.getMaxProcessPerTick();
        int i = 0;
        Iterator<MultiblockProcess<R>> processIterator = this.processQueue.iterator();
        this.tickedProcesses = 0;
        while (processIterator.hasNext() && i++ < max) {
            MultiblockProcess<R> process = processIterator.next();
            if (process.canProcess(this)) {
                process.doProcessTick(this);
                ++this.tickedProcesses;
            }
            if (!process.clearProcess) continue;
            processIterator.remove();
        }
    }

    public abstract IFluidTank[] getInternalTanks();

    public abstract R findRecipeForInsertion(ItemStack var1);

    public abstract int[] getOutputSlots();

    public abstract int[] getOutputTanks();

    public abstract boolean additionalCanProcessCheck(MultiblockProcess<R> var1);

    public abstract void doProcessOutput(ItemStack var1);

    public abstract void doProcessFluidOutput(FluidStack var1);

    public abstract void onProcessFinish(MultiblockProcess<R> var1);

    public abstract int getMaxProcessPerTick();

    public abstract int getProcessQueueMaxLength();

    public abstract float getMinProcessDistance(MultiblockProcess<R> var1);

    public abstract boolean isInWorldProcessingMachine();

    public boolean addProcessToQueue(MultiblockProcess<R> process, boolean simulate) {
        return this.addProcessToQueue(process, simulate, false);
    }

    public boolean addProcessToQueue(MultiblockProcess<R> process, boolean simulate, boolean addToPrevious) {
        if (addToPrevious && process instanceof MultiblockProcessInWorld) {
            for (MultiblockProcess<R> curr : this.processQueue) {
                if (!(curr instanceof MultiblockProcessInWorld) || !process.recipe.equals(curr.recipe)) continue;
                MultiblockProcessInWorld p = (MultiblockProcessInWorld)curr;
                boolean canStack = true;
                for (ItemStack old : p.inputItems) {
                    for (ItemStack in : ((MultiblockProcessInWorld)process).inputItems) {
                        if (!OreDictionary.itemMatches((ItemStack)old, (ItemStack)in, (boolean)true) || !Utils.compareItemNBT(old, in) || old.func_190916_E() + in.func_190916_E() <= old.func_77976_d()) continue;
                        canStack = false;
                        break;
                    }
                    if (canStack) continue;
                    break;
                }
                if (!canStack) continue;
                if (!simulate) {
                    block3: for (ItemStack old : p.inputItems) {
                        for (ItemStack in : ((MultiblockProcessInWorld)process).inputItems) {
                            if (!OreDictionary.itemMatches((ItemStack)old, (ItemStack)in, (boolean)true) || !Utils.compareItemNBT(old, in)) continue;
                            old.func_190917_f(in.func_190916_E());
                            continue block3;
                        }
                    }
                }
                return true;
            }
        }
        if (this.getProcessQueueMaxLength() < 0 || this.processQueue.size() < this.getProcessQueueMaxLength()) {
            float dist = 1.0f;
            MultiblockProcess<R> p = null;
            if (this.processQueue.size() > 0 && (p = this.processQueue.get(this.processQueue.size() - 1)) != null) {
                dist = (float)p.processTick / (float)p.maxTicks;
            }
            if (p != null && dist < this.getMinProcessDistance(p)) {
                return false;
            }
            if (!simulate) {
                this.processQueue.add(process);
            }
            return true;
        }
        return false;
    }

    @Override
    public int[] getCurrentProcessesStep() {
        TileEntityMultiblockMetal master = (TileEntityMultiblockMetal)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesStep();
        }
        int[] ia = new int[this.processQueue.size()];
        for (int i = 0; i < ia.length; ++i) {
            ia[i] = this.processQueue.get((int)i).processTick;
        }
        return ia;
    }

    @Override
    public int[] getCurrentProcessesMax() {
        TileEntityMultiblockMetal master = (TileEntityMultiblockMetal)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesMax();
        }
        int[] ia = new int[this.processQueue.size()];
        for (int i = 0; i < ia.length; ++i) {
            ia[i] = this.processQueue.get((int)i).maxTicks;
        }
        return ia;
    }

    public boolean shouldRenderAsActive() {
        return (this.controllingComputers <= 0 || this.computerOn) && this.getEnergyStored(null) > 0 && !this.isRSDisabled() && !this.processQueue.isEmpty();
    }

    public static class MultiblockInventoryHandler_DirectProcessing
    implements IItemHandlerModifiable {
        TileEntityMultiblockMetal multiblock;
        float transformationPoint = 0.5f;
        boolean doProcessStacking = false;

        public MultiblockInventoryHandler_DirectProcessing(TileEntityMultiblockMetal multiblock) {
            this.multiblock = multiblock;
        }

        public MultiblockInventoryHandler_DirectProcessing setTransformationPoint(float point) {
            this.transformationPoint = point;
            return this;
        }

        public MultiblockInventoryHandler_DirectProcessing setProcessStacking(boolean stacking) {
            this.doProcessStacking = stacking;
            return this;
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            Object recipe = this.multiblock.findRecipeForInsertion(stack = stack.func_77946_l());
            if (recipe == null) {
                return stack;
            }
            ItemStack displayStack = ItemStack.field_190927_a;
            for (IngredientStack ingr : recipe.getItemInputs()) {
                if (!ingr.matchesItemStack(stack)) continue;
                displayStack = Utils.copyStackWithAmount(stack, ingr.inputSize);
                break;
            }
            if (this.multiblock.addProcessToQueue(new MultiblockProcessInWorld(recipe, this.transformationPoint, Utils.createNonNullItemStackListFromItemStack(displayStack)), simulate, this.doProcessStacking)) {
                this.multiblock.func_70296_d();
                this.multiblock.markContainingBlockForUpdate(null);
                stack.func_190918_g(displayStack.func_190916_E());
                if (stack.func_190916_E() <= 0) {
                    stack = ItemStack.field_190927_a;
                }
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
        }
    }

    public static class MultiblockProcessInWorld<R extends IMultiblockRecipe>
    extends MultiblockProcess<R> {
        public List<ItemStack> inputItems;
        protected float transformationPoint;

        public MultiblockProcessInWorld(R recipe, float transformationPoint, NonNullList<ItemStack> inputItem) {
            super(recipe);
            this.inputItems = new ArrayList<ItemStack>(inputItem.size());
            for (ItemStack s : inputItem) {
                this.inputItems.add(s);
            }
            this.transformationPoint = transformationPoint;
        }

        public List<ItemStack> getDisplayItem() {
            NonNullList<ItemStack> list;
            if ((float)this.processTick / (float)this.maxTicks > this.transformationPoint && !(list = this.recipe.getItemOutputs()).isEmpty()) {
                return list;
            }
            return this.inputItems;
        }

        @Override
        protected void writeExtraDataToNBT(NBTTagCompound nbt) {
            nbt.func_74782_a("process_inputItem", (NBTBase)Utils.writeInventory(this.inputItems));
            nbt.func_74776_a("process_transformationPoint", this.transformationPoint);
        }

        @Override
        protected void processFinish(TileEntityMultiblockMetal multiblock) {
            super.processFinish(multiblock);
            int size = -1;
            for (ItemStack inputItem : this.inputItems) {
                for (IngredientStack s : this.recipe.getItemInputs()) {
                    if (!s.matchesItemStackIgnoringSize(inputItem)) continue;
                    size = s.inputSize;
                    break;
                }
                if (size <= 0 || inputItem.func_190916_E() <= size) continue;
                inputItem.func_77979_a(size);
                this.processTick = 0;
                this.clearProcess = false;
            }
        }
    }

    public static class MultiblockProcessInMachine<R extends IMultiblockRecipe>
    extends MultiblockProcess<R> {
        protected int[] inputSlots = new int[0];
        protected int[] inputTanks = new int[0];

        public MultiblockProcessInMachine(R recipe, int ... inputSlots) {
            super(recipe);
            this.inputSlots = inputSlots;
        }

        public MultiblockProcessInMachine setInputTanks(int ... inputTanks) {
            this.inputTanks = inputTanks;
            return this;
        }

        public int[] getInputSlots() {
            return this.inputSlots;
        }

        public int[] getInputTanks() {
            return this.inputTanks;
        }

        protected List<IngredientStack> getRecipeItemInputs(TileEntityMultiblockMetal multiblock) {
            return this.recipe.getItemInputs();
        }

        protected List<FluidStack> getRecipeFluidInputs(TileEntityMultiblockMetal multiblock) {
            return this.recipe.getFluidInputs();
        }

        @Override
        public void doProcessTick(TileEntityMultiblockMetal multiblock) {
            NonNullList inv = multiblock.getInventory();
            if (this.recipe.getItemInputs() != null && inv != null) {
                NonNullList query = NonNullList.func_191197_a((int)this.inputSlots.length, (Object)ItemStack.field_190927_a);
                for (int i = 0; i < this.inputSlots.length; ++i) {
                    if (this.inputSlots[i] < 0 || this.inputSlots[i] >= inv.size()) continue;
                    query.set(i, multiblock.getInventory().get(this.inputSlots[i]));
                }
                if (!ApiUtils.stacksMatchIngredientList(this.recipe.getItemInputs(), (NonNullList<ItemStack>)query)) {
                    this.clearProcess = true;
                    return;
                }
            }
            super.doProcessTick(multiblock);
        }

        @Override
        protected void processFinish(TileEntityMultiblockMetal multiblock) {
            super.processFinish(multiblock);
            NonNullList inv = multiblock.getInventory();
            List<IngredientStack> itemInputList = this.getRecipeItemInputs(multiblock);
            if (inv != null && this.inputSlots != null && itemInputList != null) {
                block0: for (IngredientStack ingr : new ArrayList<IngredientStack>(itemInputList)) {
                    int ingrSize = ingr.inputSize;
                    for (int slot : this.inputSlots) {
                        if (((ItemStack)inv.get(slot)).func_190926_b() || !ingr.matchesItemStackIgnoringSize((ItemStack)inv.get(slot))) continue;
                        int taken = Math.min(((ItemStack)inv.get(slot)).func_190916_E(), ingrSize);
                        ((ItemStack)inv.get(slot)).func_190918_g(taken);
                        if (((ItemStack)inv.get(slot)).func_190916_E() <= 0) {
                            inv.set(slot, (Object)ItemStack.field_190927_a);
                        }
                        if ((ingrSize -= taken) <= 0) continue block0;
                    }
                }
            }
            IFluidTank[] tanks = multiblock.getInternalTanks();
            List<FluidStack> fluidInputList = this.getRecipeFluidInputs(multiblock);
            if (tanks != null && this.inputTanks != null && fluidInputList != null) {
                block2: for (FluidStack ingr : new ArrayList<FluidStack>(fluidInputList)) {
                    int ingrSize = ingr.amount;
                    for (int tank : this.inputTanks) {
                        if (tanks[tank] == null) continue;
                        if (tanks[tank] instanceof IFluidHandler && ((IFluidHandler)tanks[tank]).drain(ingr, false) != null) {
                            FluidStack taken = ((IFluidHandler)tanks[tank]).drain(ingr, true);
                            if ((ingrSize -= taken.amount) > 0) continue;
                            continue block2;
                        }
                        if (tanks[tank].getFluid() == null || !tanks[tank].getFluid().isFluidEqual(ingr)) continue;
                        int taken = Math.min(tanks[tank].getFluidAmount(), ingrSize);
                        tanks[tank].drain(taken, true);
                        if ((ingrSize -= taken) <= 0) continue block2;
                    }
                }
            }
        }

        @Override
        protected void writeExtraDataToNBT(NBTTagCompound nbt) {
            if (this.inputSlots != null) {
                nbt.func_74783_a("process_inputSlots", this.inputSlots);
            }
            if (this.inputTanks != null) {
                nbt.func_74783_a("process_inputTanks", this.inputTanks);
            }
        }
    }

    public static abstract class MultiblockProcess<R extends IMultiblockRecipe> {
        public R recipe;
        public int processTick;
        public int maxTicks;
        public int energyPerTick;
        public boolean clearProcess = false;

        public MultiblockProcess(R recipe) {
            this.recipe = recipe;
            this.processTick = 0;
            this.maxTicks = this.recipe.getTotalProcessTime();
            this.energyPerTick = this.recipe.getTotalProcessEnergy() / this.maxTicks;
        }

        protected List<ItemStack> getRecipeItemOutputs(TileEntityMultiblockMetal multiblock) {
            return this.recipe.getActualItemOutputs(multiblock);
        }

        protected List<FluidStack> getRecipeFluidOutputs(TileEntityMultiblockMetal multiblock) {
            return this.recipe.getActualFluidOutputs(multiblock);
        }

        public boolean canProcess(TileEntityMultiblockMetal multiblock) {
            if (multiblock.energyStorage.extractEnergy(this.energyPerTick, true) == this.energyPerTick) {
                List<FluidStack> fluidOutputs;
                NonNullList<ItemStack> outputs = this.recipe.getItemOutputs();
                if (outputs != null && !outputs.isEmpty()) {
                    int[] outputSlots = multiblock.getOutputSlots();
                    for (ItemStack output : outputs) {
                        if (output.func_190926_b()) continue;
                        boolean canOutput = false;
                        if (outputSlots == null) {
                            canOutput = true;
                        } else {
                            for (int iOutputSlot : outputSlots) {
                                ItemStack s = (ItemStack)multiblock.getInventory().get(iOutputSlot);
                                if (!s.func_190926_b() && (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)output) || s.func_190916_E() + output.func_190916_E() > multiblock.getSlotLimit(iOutputSlot))) continue;
                                canOutput = true;
                                break;
                            }
                        }
                        if (canOutput) continue;
                        return false;
                    }
                }
                if ((fluidOutputs = this.recipe.getFluidOutputs()) != null && !fluidOutputs.isEmpty()) {
                    IFluidTank[] tanks = multiblock.getInternalTanks();
                    int[] outputTanks = multiblock.getOutputTanks();
                    for (FluidStack output : fluidOutputs) {
                        if (output == null || output.amount <= 0) continue;
                        boolean canOutput = false;
                        if (tanks == null || outputTanks == null) {
                            canOutput = true;
                        } else {
                            for (int iOutputTank : outputTanks) {
                                if (iOutputTank < 0 || iOutputTank >= tanks.length || tanks[iOutputTank] == null || tanks[iOutputTank].fill(output, false) != output.amount) continue;
                                canOutput = true;
                                break;
                            }
                        }
                        if (canOutput) continue;
                        return false;
                    }
                }
                return multiblock.additionalCanProcessCheck(this);
            }
            return false;
        }

        public void doProcessTick(TileEntityMultiblockMetal multiblock) {
            int energyExtracted = this.energyPerTick;
            int ticksAdded = 1;
            if (this.recipe.getMultipleProcessTicks() > 1) {
                int possibleTicks;
                int averageInsertion = multiblock.energyStorage.getAverageInsertion();
                if ((averageInsertion = multiblock.energyStorage.extractEnergy(averageInsertion, true)) > energyExtracted && (possibleTicks = Math.min(averageInsertion / this.energyPerTick, Math.min(this.recipe.getMultipleProcessTicks(), this.maxTicks - this.processTick))) > 1) {
                    ticksAdded = possibleTicks;
                    energyExtracted *= ticksAdded;
                }
            }
            multiblock.energyStorage.extractEnergy(energyExtracted, false);
            this.processTick += ticksAdded;
            if (this.processTick >= this.maxTicks) {
                this.processFinish(multiblock);
            }
        }

        protected void processFinish(TileEntityMultiblockMetal multiblock) {
            List<FluidStack> fluidOutputs;
            List<ItemStack> outputs = this.getRecipeItemOutputs(multiblock);
            if (outputs != null && !outputs.isEmpty()) {
                int[] outputSlots = multiblock.getOutputSlots();
                block0: for (ItemStack output : outputs) {
                    if (output.func_190926_b()) continue;
                    if (outputSlots == null || multiblock.getInventory() == null) {
                        multiblock.doProcessOutput(output.func_77946_l());
                        continue;
                    }
                    for (Object iOutputSlot : (Object)outputSlots) {
                        ItemStack s = (ItemStack)multiblock.getInventory().get((int)iOutputSlot);
                        if (s.func_190926_b()) {
                            multiblock.getInventory().set((int)iOutputSlot, (Object)output.func_77946_l());
                            continue block0;
                        }
                        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)output) || s.func_190916_E() + output.func_190916_E() > multiblock.getSlotLimit((int)iOutputSlot)) continue;
                        ((ItemStack)multiblock.getInventory().get((int)iOutputSlot)).func_190917_f(output.func_190916_E());
                        continue block0;
                    }
                }
            }
            if ((fluidOutputs = this.getRecipeFluidOutputs(multiblock)) != null && !fluidOutputs.isEmpty()) {
                IFluidTank[] tanks = multiblock.getInternalTanks();
                int[] outputTanks = multiblock.getOutputTanks();
                block2: for (FluidStack output : fluidOutputs) {
                    if (output == null || output.amount <= 0) continue;
                    if (tanks == null || outputTanks == null) {
                        multiblock.doProcessFluidOutput(output);
                        continue;
                    }
                    for (int iOutputTank : outputTanks) {
                        if (iOutputTank < 0 || iOutputTank >= tanks.length || tanks[iOutputTank] == null || tanks[iOutputTank].fill(output, false) != output.amount) continue;
                        tanks[iOutputTank].fill(output, true);
                        continue block2;
                    }
                }
            }
            multiblock.onProcessFinish(this);
            this.clearProcess = true;
        }

        protected abstract void writeExtraDataToNBT(NBTTagCompound var1);
    }
}

