/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxProvider;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxReceiver;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration1;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockLightningrod;
import blusunrize.immersiveengineering.common.util.Utils;
import cofh.api.energy.IEnergyProvider;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityLightningrod
extends TileEntityMultiblockPart<TileEntityLightningrod>
implements IFluxProvider,
IEnergyProvider {
    FluxStorage energyStorage = new FluxStorage(Config.IEConfig.Machines.lightning_output);
    ArrayList<BlockPos> fenceNet = null;
    int height;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.formed && this.field_174879_c == 13) {
            if (this.energyStorage.getEnergyStored() > 0) {
                for (EnumFacing f : EnumFacing.field_176754_o) {
                    TileEntity tileEntity = this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(f, 2));
                    if (!(tileEntity instanceof IFluxReceiver)) continue;
                    IFluxReceiver ifr = (IFluxReceiver)tileEntity;
                    int accepted = ifr.receiveEnergy(f.func_176734_d(), this.energyStorage.getEnergyStored(), true);
                    int extracted = this.energyStorage.extractEnergy(accepted, false);
                    ifr.receiveEnergy(f.func_176734_d(), extracted, false);
                }
            }
            if (this.field_145850_b.func_82737_E() % 256L == (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0xFF)) {
                this.fenceNet = null;
            }
            if (this.fenceNet == null) {
                this.fenceNet = this.getFenceNet();
            }
            if (this.fenceNet != null && this.field_145850_b.func_82737_E() % 128L == (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0x7F) && (this.field_145850_b.func_72911_I() || this.field_145850_b.func_72896_J() && this.field_145850_b.field_73012_v.nextInt(10) == 0)) {
                int i = this.height + this.fenceNet.size();
                if (this.field_145850_b.field_73012_v.nextInt(4096 * this.field_145850_b.func_72800_K()) < i * (this.func_174877_v().func_177956_o() + i)) {
                    this.energyStorage.setEnergy(Config.IEConfig.Machines.lightning_output);
                    BlockPos pos = this.fenceNet.get(this.field_145850_b.field_73012_v.nextInt(this.fenceNet.size()));
                    EntityLightningBolt entityLightningBolt = new EntityLightningBolt(this.field_145850_b, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), true);
                    this.field_145850_b.func_72942_c((Entity)entityLightningBolt);
                    this.field_145850_b.func_72838_d((Entity)entityLightningBolt);
                }
            }
        }
    }

    ArrayList<BlockPos> getFenceNet() {
        this.height = 0;
        boolean broken = false;
        for (int i = this.func_174877_v().func_177956_o() + 2; i < this.field_145850_b.func_72800_K() - 1; ++i) {
            BlockPos pos = new BlockPos(this.func_174877_v().func_177958_n(), i, this.func_174877_v().func_177952_p());
            if (!broken && this.isFence(pos)) {
                ++this.height;
                continue;
            }
            if (!this.field_145850_b.func_175623_d(pos)) {
                return null;
            }
            if (broken) continue;
            broken = true;
        }
        ArrayList<BlockPos> openList = new ArrayList<BlockPos>();
        ArrayList<BlockPos> closedList = new ArrayList<BlockPos>();
        openList.add(this.func_174877_v().func_177982_a(0, this.height, 0));
        while (!openList.isEmpty() && closedList.size() < 256) {
            BlockPos next = (BlockPos)openList.get(0);
            if (!closedList.contains(next) && this.isFence(next)) {
                closedList.add(next);
                openList.add(next.func_177972_a(EnumFacing.WEST));
                openList.add(next.func_177972_a(EnumFacing.EAST));
                openList.add(next.func_177972_a(EnumFacing.NORTH));
                openList.add(next.func_177972_a(EnumFacing.SOUTH));
                openList.add(next.func_177972_a(EnumFacing.UP));
            }
            openList.remove(0);
        }
        return closedList;
    }

    boolean isFence(BlockPos pos) {
        return Utils.isBlockAt(this.field_145850_b, pos, IEContent.blockMetalDecoration1, BlockTypes_MetalDecoration1.STEEL_FENCE.getMeta());
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        this.energyStorage.writeToNBT(nbt);
    }

    @Override
    public float[] getBlockBounds() {
        if (this.field_174879_c == 22) {
            return new float[]{-0.125f, 0.0f, -0.125f, 1.125f, 1.0f, 1.125f};
        }
        if (this.field_174879_c % 9 == 4 || this.field_174879_c < 18 && this.field_174879_c % 9 % 2 == 1) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        if (this.field_174879_c < 9) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f};
        }
        float xMin = 0.0f;
        float xMax = 1.0f;
        float yMin = 0.0f;
        float yMax = 1.0f;
        float zMin = 0.0f;
        float zMax = 1.0f;
        if (this.field_174879_c % 9 == 0 || this.field_174879_c % 9 == 2 || this.field_174879_c % 9 == 6 || this.field_174879_c % 9 == 8) {
            if (this.field_174879_c < 18) {
                yMin = -0.5f;
                yMax = 1.25f;
                float f = (this.facing.func_176740_k() == EnumFacing.Axis.X ? this.field_174879_c % 9 > 2 ^ this.facing == EnumFacing.EAST : this.field_174879_c % 3 == 2 ^ this.facing == EnumFacing.NORTH) ? 0.8125f : (xMin = 0.4375f);
                float f2 = (this.facing.func_176740_k() == EnumFacing.Axis.X ? this.field_174879_c % 9 < 3 ^ this.facing == EnumFacing.EAST : this.field_174879_c % 3 == 0 ^ this.facing == EnumFacing.NORTH) ? 0.1875f : (xMax = 0.5625f);
                float f3 = (this.facing.func_176740_k() == EnumFacing.Axis.X ? this.field_174879_c % 3 == 2 ^ this.facing == EnumFacing.EAST : this.field_174879_c % 9 < 3 ^ this.facing == EnumFacing.NORTH) ? 0.8125f : (zMin = 0.4375f);
                zMax = (this.facing.func_176740_k() == EnumFacing.Axis.X ? this.field_174879_c % 3 == 0 ^ this.facing == EnumFacing.EAST : this.field_174879_c % 9 > 2 ^ this.facing == EnumFacing.NORTH) ? 0.1875f : 0.5625f;
            } else {
                yMin = 0.25f;
                yMax = 0.75f;
                float f = (this.facing.func_176740_k() == EnumFacing.Axis.X ? this.field_174879_c % 9 > 2 ^ this.facing == EnumFacing.EAST : this.field_174879_c % 3 == 2 ^ this.facing == EnumFacing.NORTH) ? 1.0f : (xMin = 0.625f);
                float f4 = (this.facing.func_176740_k() == EnumFacing.Axis.X ? this.field_174879_c % 9 < 3 ^ this.facing == EnumFacing.EAST : this.field_174879_c % 3 == 0 ^ this.facing == EnumFacing.NORTH) ? 0.0f : (xMax = 0.375f);
                float f5 = (this.facing.func_176740_k() == EnumFacing.Axis.X ? this.field_174879_c % 3 == 2 ^ this.facing == EnumFacing.EAST : this.field_174879_c % 9 < 3 ^ this.facing == EnumFacing.NORTH) ? 1.0f : (zMin = 0.625f);
                zMax = (this.facing.func_176740_k() == EnumFacing.Axis.X ? this.field_174879_c % 3 == 0 ^ this.facing == EnumFacing.EAST : this.field_174879_c % 9 > 2 ^ this.facing == EnumFacing.NORTH) ? 0.0f : 0.375f;
            }
        } else if (this.field_174879_c > 17) {
            yMin = 0.25f;
            yMax = 0.75f;
            xMin = this.offset[0] < 0 ? 0.375f : 0.0f;
            xMax = this.offset[0] > 0 ? 0.625f : 1.0f;
            zMin = this.offset[2] < 0 ? 0.375f : 0.0f;
            zMax = this.offset[2] > 0 ? 0.625f : 1.0f;
        }
        return new float[]{xMin, yMin, zMin, xMax, yMax, zMax};
    }

    @Override
    public ItemStack getOriginalBlock() {
        if (this.field_174879_c < 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack s = ItemStack.field_190927_a;
        try {
            s = MultiblockLightningrod.instance.getStructureManual()[this.field_174879_c / 9][this.field_174879_c % 9 / 3][this.field_174879_c % 3];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s.func_77946_l();
    }

    @Override
    public void disassemble() {
        super.func_145843_s();
        if (this.formed && !this.field_145850_b.field_72995_K) {
            BlockPos startPos = this.func_174877_v().func_177982_a(-this.offset[0], -this.offset[1], -this.offset[2]);
            if (!(this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0 || this.field_145850_b.func_175625_s(startPos) instanceof TileEntityLightningrod)) {
                return;
            }
            for (int yy = -1; yy <= 1; ++yy) {
                for (int xx = -1; xx <= 1; ++xx) {
                    for (int zz = -1; zz <= 1; ++zz) {
                        ItemStack s = ItemStack.field_190927_a;
                        TileEntity te = this.field_145850_b.func_175625_s(startPos.func_177982_a(xx, yy, zz));
                        if (te instanceof TileEntityLightningrod) {
                            s = ((TileEntityLightningrod)te).getOriginalBlock();
                            ((TileEntityLightningrod)te).formed = false;
                        }
                        if (startPos.func_177982_a(xx, yy, zz).equals((Object)this.func_174877_v())) {
                            s = this.getOriginalBlock();
                        }
                        if (s.func_190926_b() || Block.func_149634_a((Item)s.func_77973_b()) == null) continue;
                        if (startPos.func_177982_a(xx, yy, zz).equals((Object)this.func_174877_v())) {
                            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, s));
                            continue;
                        }
                        if (Block.func_149634_a((Item)s.func_77973_b()) == IEContent.blockMetalMultiblock) {
                            this.field_145850_b.func_175698_g(startPos.func_177982_a(xx, yy, zz));
                        }
                        this.field_145850_b.func_175656_a(startPos.func_177982_a(xx, yy, zz), Block.func_149634_a((Item)s.func_77973_b()).func_176203_a(s.func_77952_i()));
                    }
                }
            }
        }
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        return new IFluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.field_174879_c == 4 ? new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, 0, -1), this.func_174877_v().func_177982_a(2, 5, 2)) : new AxisAlignedBB(this.func_174877_v(), this.func_174877_v());
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return super.func_145833_n() * Config.IEConfig.increasedTileRenderdistance;
    }

    @Override
    public int extractEnergy(@Nullable EnumFacing from, int energy, boolean simulate) {
        if (this.field_174879_c != 10 && this.field_174879_c != 12 && this.field_174879_c != 14 & this.field_174879_c != 16) {
            return 0;
        }
        TileEntityLightningrod master = (TileEntityLightningrod)this.master();
        return master == null ? 0 : master.energyStorage.extractEnergy(energy, simulate);
    }

    @Override
    public int getEnergyStored(@Nullable EnumFacing from) {
        TileEntityLightningrod master = (TileEntityLightningrod)this.master();
        return master == null ? 0 : master.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(@Nullable EnumFacing from) {
        TileEntityLightningrod master = (TileEntityLightningrod)this.master();
        return master == null ? 0 : master.energyStorage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(@Nullable EnumFacing from) {
        return this.field_174879_c == 10 || this.field_174879_c == 12 || this.field_174879_c == 14 || this.field_174879_c == 16;
    }
}

