/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChorusPlant;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockStem;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class BelljarHandler {
    private static HashSet<IPlantHandler> plantHandlers = new HashSet();
    private static HashMap<ComparableItemStack, ResourceLocation> soilTextureMap = new HashMap();
    private static HashSet<FluidFertilizerHandler> fluidFertilizers = new HashSet();
    private static HashSet<ItemFertilizerHandler> itemFertilizers = new HashSet();
    private static HashMap<ComparableItemStack, IngredientStack> seedSoilMap = new HashMap();
    private static HashMap<ComparableItemStack, ItemStack[]> seedOutputMap = new HashMap();
    private static HashMap<ComparableItemStack, IBlockState[]> seedRenderMap = new HashMap();
    public static DefaultPlantHandler cropHandler = new DefaultPlantHandler(){
        private HashSet<ComparableItemStack> validSeeds = new HashSet();

        @Override
        protected HashSet<ComparableItemStack> getSeedSet() {
            return this.validSeeds;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public IBlockState[] getRenderedPlant(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
            IBlockState[] states = (IBlockState[])seedRenderMap.get(new ComparableItemStack(seed, false));
            if (states != null) {
                IBlockState[] ret = new IBlockState[states.length];
                for (int i = 0; i < states.length; ++i) {
                    if (states[i] == null) continue;
                    if (states[i].func_177230_c() instanceof BlockCrops) {
                        int max = ((BlockCrops)states[i].func_177230_c()).func_185526_g();
                        ret[i] = ((BlockCrops)states[i].func_177230_c()).func_185528_e(Math.min(max, Math.round((float)max * growth)));
                        continue;
                    }
                    for (IProperty prop : states[i].func_177227_a()) {
                        if (!"age".equals(prop.func_177701_a()) || !(prop instanceof PropertyInteger)) continue;
                        int max = 0;
                        for (Integer allowed : ((PropertyInteger)prop).func_177700_c()) {
                            if (allowed == null || allowed <= max) continue;
                            max = allowed;
                        }
                        ret[i] = states[i].func_177226_a(prop, (Comparable)Integer.valueOf(Math.min(max, Math.round((float)max * growth))));
                    }
                    if (ret[i] != null) continue;
                    ret[i] = states[i];
                }
                return ret;
            }
            return null;
        }
    };
    public static DefaultPlantHandler stemHandler = new DefaultPlantHandler(){
        private HashSet<ComparableItemStack> validSeeds = new HashSet();

        @Override
        protected HashSet<ComparableItemStack> getSeedSet() {
            return this.validSeeds;
        }

        @Override
        public float getGrowthStep(ItemStack seed, ItemStack soil, float growth, TileEntity tile, float fertilizer, boolean render) {
            return ((double)growth < 0.5 ? 0.00625f : 0.003125f) * fertilizer;
        }

        @Override
        public float resetGrowth(ItemStack seed, ItemStack soil, float growth, TileEntity tile, boolean render) {
            return 0.5f;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public IBlockState[] getRenderedPlant(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
            return new IBlockState[0];
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public float getRenderSize(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
            return 1.0f;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean overrideRender(ItemStack seed, ItemStack soil, float growth, TileEntity tile, BlockRendererDispatcher blockRenderer) {
            ComparableItemStack comp = new ComparableItemStack(seed, false);
            IBlockState[] renderStates = (IBlockState[])seedRenderMap.get(comp);
            if (renderStates.length > 0 && renderStates[0] != null && renderStates[0].func_177230_c() instanceof BlockStem) {
                Block fruitBlock;
                ItemStack[] fruit;
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                BlockStem stem = (BlockStem)renderStates[0].func_177230_c();
                IBlockState state = stem.func_176223_P().func_177226_a((IProperty)BlockStem.field_176484_a, (Comparable)Integer.valueOf((int)((double)growth >= 0.5 ? 7.0f : 2.0f * growth * 7.0f)));
                if ((double)growth >= 0.5) {
                    state = state.func_177226_a((IProperty)BlockStem.field_176483_b, (Comparable)EnumFacing.NORTH);
                }
                IBakedModel model = blockRenderer.func_184389_a(state);
                GlStateManager.func_179109_b((float)0.25f, (float)0.0625f, (float)0.0f);
                GlStateManager.func_179094_E();
                blockRenderer.func_175019_b().func_178266_a(model, state, 1.0f, true);
                GlStateManager.func_179121_F();
                if ((double)growth >= 0.5 && (fruit = (ItemStack[])seedOutputMap.get(new ComparableItemStack(seed, false))) != null && fruit.length > 0 && fruit[0] != null && fruit[0].func_77973_b() != null && (fruitBlock = Block.func_149634_a((Item)fruit[0].func_77973_b())) != null) {
                    state = fruitBlock.func_176223_P();
                    model = blockRenderer.func_184389_a(state);
                    GlStateManager.func_179094_E();
                    float scale = (growth - 0.5f) * 0.5f;
                    GlStateManager.func_179137_b((double)(-scale / 2.0f), (double)(0.5 - (double)scale), (double)(-0.5 + (double)(scale / 2.0f)));
                    GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                    blockRenderer.func_175019_b().func_178266_a(model, state, 1.0f, true);
                    GlStateManager.func_179121_F();
                }
            }
            return true;
        }
    };
    public static DefaultPlantHandler stackingHandler = new DefaultPlantHandler(){
        private HashSet<ComparableItemStack> validSeeds = new HashSet();

        @Override
        protected HashSet<ComparableItemStack> getSeedSet() {
            return this.validSeeds;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public IBlockState[] getRenderedPlant(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
            IBlockState[] states = (IBlockState[])seedRenderMap.get(new ComparableItemStack(seed, false));
            if (states != null) {
                return states;
            }
            return null;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public float getRenderSize(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
            IBlockState[] states = (IBlockState[])seedRenderMap.get(new ComparableItemStack(seed, false));
            if (states != null && states.length > 2) {
                return 0.6875f - (float)states.length * 0.0625f;
            }
            return 0.6875f;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean overrideRender(ItemStack seed, ItemStack soil, float growth, TileEntity tile, BlockRendererDispatcher blockRenderer) {
            IBlockState[] states = (IBlockState[])seedRenderMap.get(new ComparableItemStack(seed, false));
            if (states != null) {
                GlStateManager.func_179109_b((float)0.0f, (float)((-1.0f + growth) * (float)(states.length - 1)), (float)0.0f);
            }
            return false;
        }
    };

    public static void registerHandler(IPlantHandler handler) {
        plantHandlers.add(handler);
    }

    public static IPlantHandler getHandler(ItemStack seed) {
        if (seed.func_190926_b()) {
            return null;
        }
        for (IPlantHandler handler : plantHandlers) {
            if (!handler.isValid(seed)) continue;
            return handler;
        }
        return null;
    }

    public static void registerFluidFertilizer(FluidFertilizerHandler handler) {
        fluidFertilizers.add(handler);
    }

    public static FluidFertilizerHandler getFluidFertilizerHandler(FluidStack fluid) {
        if (fluid == null) {
            return null;
        }
        for (FluidFertilizerHandler handler : fluidFertilizers) {
            if (!handler.isValid(fluid)) continue;
            return handler;
        }
        return null;
    }

    public static void registerItemFertilizer(ItemFertilizerHandler handler) {
        itemFertilizers.add(handler);
    }

    public static ItemFertilizerHandler getItemFertilizerHandler(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return null;
        }
        for (ItemFertilizerHandler handler : itemFertilizers) {
            if (!handler.isValid(itemStack)) continue;
            return handler;
        }
        return null;
    }

    public static ResourceLocation getSoilTexture(ItemStack soil) {
        return soilTextureMap.get(new ComparableItemStack(soil, false));
    }

    static {
        soilTextureMap.put(new ComparableItemStack(new ItemStack(Blocks.field_150346_d)), new ResourceLocation("minecraft:blocks/farmland_wet"));
        BelljarHandler.registerHandler(cropHandler);
        BelljarHandler.registerHandler(stemHandler);
        BelljarHandler.registerHandler(stackingHandler);
        cropHandler.register(new ItemStack(Items.field_151014_N), new ItemStack[]{new ItemStack(Items.field_151015_O), new ItemStack(Items.field_151014_N, 2)}, new ItemStack(Blocks.field_150346_d), Blocks.field_150464_aj.func_176223_P());
        cropHandler.register(new ItemStack(Items.field_151174_bG), new ItemStack[]{new ItemStack(Items.field_151174_bG, 2)}, new ItemStack(Blocks.field_150346_d), Blocks.field_150469_bN.func_176223_P());
        cropHandler.register(new ItemStack(Items.field_151172_bF), new ItemStack[]{new ItemStack(Items.field_151172_bF, 2)}, new ItemStack(Blocks.field_150346_d), Blocks.field_150459_bM.func_176223_P());
        cropHandler.register(new ItemStack(Items.field_185163_cU), new ItemStack[]{new ItemStack(Items.field_185164_cV), new ItemStack(Items.field_185163_cU, 2)}, new ItemStack(Blocks.field_150346_d), Blocks.field_185773_cZ.func_176223_P());
        cropHandler.register(new ItemStack(Items.field_151075_bm), new ItemStack[]{new ItemStack(Items.field_151075_bm, 2)}, new ItemStack(Blocks.field_150425_aM), Blocks.field_150388_bm.func_176223_P());
        stemHandler.register(new ItemStack(Items.field_151080_bb), new ItemStack[]{new ItemStack(Blocks.field_150423_aK)}, new ItemStack(Blocks.field_150346_d), Blocks.field_150393_bb.func_176223_P());
        stemHandler.register(new ItemStack(Items.field_151081_bc), new ItemStack[]{new ItemStack(Blocks.field_150440_ba)}, new ItemStack(Blocks.field_150346_d), Blocks.field_150394_bc.func_176223_P());
        stackingHandler.register(new ItemStack(Items.field_151120_aE), new ItemStack[]{new ItemStack(Items.field_151120_aE, 2)}, "sand", Blocks.field_150436_aH.func_176223_P(), Blocks.field_150436_aH.func_176223_P());
        stackingHandler.register(new ItemStack((Block)Blocks.field_150434_aF), new ItemStack[]{new ItemStack((Block)Blocks.field_150434_aF, 2)}, "sand", Blocks.field_150434_aF.func_176223_P(), Blocks.field_150434_aF.func_176223_P());
        stackingHandler.register(new ItemStack(Blocks.field_185766_cS), new ItemStack[]{new ItemStack(Items.field_185161_cS, 1)}, new ItemStack(Blocks.field_150377_bs), Blocks.field_185765_cR.func_176223_P().func_177226_a((IProperty)BlockChorusPlant.field_185614_f, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockChorusPlant.field_185613_e, (Comparable)Boolean.valueOf(true)), Blocks.field_185765_cR.func_176223_P().func_177226_a((IProperty)BlockChorusPlant.field_185614_f, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockChorusPlant.field_185613_e, (Comparable)Boolean.valueOf(true)), Blocks.field_185766_cS.func_176223_P());
        cropHandler.register(new ItemStack((Block)Blocks.field_150337_Q), new ItemStack[]{new ItemStack((Block)Blocks.field_150337_Q, 2)}, new ItemStack((Block)Blocks.field_150391_bh), Blocks.field_150337_Q.func_176223_P());
        cropHandler.register(new ItemStack((Block)Blocks.field_150338_P), new ItemStack[]{new ItemStack((Block)Blocks.field_150338_P, 2)}, new ItemStack((Block)Blocks.field_150391_bh), Blocks.field_150338_P.func_176223_P());
        BelljarHandler.registerFluidFertilizer(new FluidFertilizerHandler(){

            @Override
            public boolean isValid(@Nullable FluidStack fertilizer) {
                return fertilizer != null && fertilizer.getFluid() == FluidRegistry.WATER;
            }

            @Override
            public float getGrowthMultiplier(FluidStack fertilizer, ItemStack seed, ItemStack soil, TileEntity tile) {
                return 1.0f;
            }
        });
        BelljarHandler.registerItemFertilizer(new ItemFertilizerHandler(){
            final ItemStack bonemeal = new ItemStack(Items.field_151100_aR, 1, 15);

            @Override
            public boolean isValid(@Nullable ItemStack fertilizer) {
                return !fertilizer.func_190926_b() && OreDictionary.itemMatches((ItemStack)this.bonemeal, (ItemStack)fertilizer, (boolean)true);
            }

            @Override
            public float getGrowthMultiplier(ItemStack fertilizer, ItemStack seed, ItemStack soil, TileEntity tile) {
                return 1.25f;
            }
        });
    }

    public static abstract class DefaultPlantHandler
    implements IPlantHandler {
        protected abstract HashSet<ComparableItemStack> getSeedSet();

        @Override
        public boolean isValid(ItemStack seed) {
            return seed != null && this.getSeedSet().contains(new ComparableItemStack(seed, false));
        }

        @Override
        public boolean isCorrectSoil(ItemStack seed, ItemStack soil) {
            IngredientStack reqSoil = (IngredientStack)seedSoilMap.get(new ComparableItemStack(seed, false));
            return reqSoil.matchesItemStack(soil);
        }

        @Override
        public float getGrowthStep(ItemStack seed, ItemStack soil, float growth, TileEntity tile, float fertilizer, boolean render) {
            return 0.00625f * fertilizer;
        }

        @Override
        public ItemStack[] getOutput(ItemStack seed, ItemStack soil, TileEntity tile) {
            return (ItemStack[])seedOutputMap.get(new ComparableItemStack(seed, false));
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public IBlockState[] getRenderedPlant(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
            IBlockState[] states = (IBlockState[])seedRenderMap.get(new ComparableItemStack(seed, false));
            if (states != null) {
                return states;
            }
            return null;
        }

        public void register(ItemStack seed, ItemStack[] output, Object soil, IBlockState ... render) {
            this.register(seed, output, ApiUtils.createIngredientStack(soil), render);
        }

        public void register(ItemStack seed, ItemStack[] output, IngredientStack soil, IBlockState ... render) {
            ComparableItemStack comp = new ComparableItemStack(seed, false);
            this.getSeedSet().add(comp);
            seedSoilMap.put(comp, soil);
            seedOutputMap.put(comp, output);
            seedRenderMap.put(comp, render);
        }
    }

    public static interface ItemFertilizerHandler {
        public boolean isValid(@Nullable ItemStack var1);

        public float getGrowthMultiplier(ItemStack var1, ItemStack var2, ItemStack var3, TileEntity var4);
    }

    public static interface FluidFertilizerHandler {
        public boolean isValid(@Nullable FluidStack var1);

        public float getGrowthMultiplier(FluidStack var1, ItemStack var2, ItemStack var3, TileEntity var4);
    }

    public static interface IPlantRenderer {
        public boolean isValid(ItemStack var1);

        @SideOnly(value=Side.CLIENT)
        public IBlockState[] getRenderedPlant(ItemStack var1, ItemStack var2, float var3, TileEntity var4);

        @SideOnly(value=Side.CLIENT)
        default public boolean overrideRender(ItemStack seed, ItemStack soil, float growth, TileEntity tile, BlockRendererDispatcher blockRenderer) {
            return false;
        }

        @SideOnly(value=Side.CLIENT)
        default public float getRenderSize(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
            return 0.875f;
        }
    }

    public static interface IPlantHandler
    extends IPlantRenderer {
        public boolean isCorrectSoil(ItemStack var1, ItemStack var2);

        public float getGrowthStep(ItemStack var1, ItemStack var2, float var3, TileEntity var4, float var5, boolean var6);

        public ItemStack[] getOutput(ItemStack var1, ItemStack var2, TileEntity var3);

        default public float resetGrowth(ItemStack seed, ItemStack soil, float growth, TileEntity tile, boolean render) {
            return 0.0f;
        }

        default public ResourceLocation getSoilTexture(ItemStack seed, ItemStack soil, TileEntity tile) {
            return null;
        }
    }
}

