/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.oredict.OreDictionary;

public class IngredientStack {
    public ItemStack stack = ItemStack.field_190927_a;
    public List<ItemStack> stackList;
    public String oreName;
    public FluidStack fluid;
    public int inputSize = 1;
    public boolean useNBT;

    public IngredientStack(ItemStack stack) {
        this.stack = stack;
        this.inputSize = stack.func_190916_E();
    }

    public IngredientStack(String oreName, int inputSize) {
        this.oreName = oreName;
        this.inputSize = inputSize;
    }

    public IngredientStack(String oreName) {
        this(oreName, 1);
    }

    public IngredientStack(List<ItemStack> stackList, int inputSize) {
        this.stackList = stackList;
        this.inputSize = inputSize;
    }

    public IngredientStack(List<ItemStack> stackList) {
        this(stackList, 1);
    }

    public IngredientStack(FluidStack fluid) {
        this.fluid = fluid;
    }

    public IngredientStack(IngredientStack ingr) {
        this.stack = ingr.stack;
        this.stackList = ingr.stackList;
        this.oreName = ingr.oreName;
        this.fluid = ingr.fluid;
        this.inputSize = ingr.inputSize;
        this.useNBT = ingr.useNBT;
    }

    public IngredientStack setUseNBT(boolean useNBT) {
        this.useNBT = useNBT;
        return this;
    }

    public boolean matches(Object input) {
        if (input == null) {
            return false;
        }
        if (input instanceof IngredientStack) {
            return this.equals(input) && this.inputSize <= ((IngredientStack)input).inputSize;
        }
        if (input instanceof ItemStack) {
            return this.matchesItemStack((ItemStack)input);
        }
        if (input instanceof ItemStack[]) {
            for (ItemStack iStack : (ItemStack[])input) {
                if (!this.matchesItemStack(iStack)) continue;
                return true;
            }
        } else if (input instanceof List) {
            for (Object io : (List)input) {
                if (!this.matches(io)) continue;
                return true;
            }
        } else if (input instanceof String) {
            if (this.oreName != null) {
                return this.oreName.equals(input);
            }
            return ApiUtils.compareToOreName(this.stack, (String)input);
        }
        return false;
    }

    public IngredientStack copyWithSize(int size) {
        IngredientStack is = new IngredientStack(this);
        is.inputSize = size;
        return is;
    }

    public IngredientStack copyWithMultipliedSize(double multiplier) {
        return this.copyWithSize((int)Math.floor((double)this.inputSize * multiplier));
    }

    public List<ItemStack> getStackList() {
        if (this.stackList != null) {
            return this.stackList;
        }
        if (this.oreName != null) {
            return OreDictionary.getOres((String)this.oreName);
        }
        if (this.fluid != null && ForgeModContainer.getInstance().universalBucket != null) {
            return Collections.singletonList(UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)this.fluid.getFluid()));
        }
        return Collections.singletonList(this.stack);
    }

    public ItemStack getRandomizedExampleStack(long rand) {
        NonNullList ores;
        ItemStack ret = this.stack;
        if (ret.func_190926_b() && this.stackList != null && this.stackList.size() > 0) {
            ret = this.stackList.get((int)(rand / 20L % (long)this.stackList.size()));
        }
        if (ret.func_190926_b() && this.oreName != null && (ores = OreDictionary.getOres((String)this.oreName)) != null && ores.size() > 0) {
            ret = (ItemStack)ores.get((int)(rand / 20L % (long)ores.size()));
        }
        if (ret.func_190926_b() && this.fluid != null && ForgeModContainer.getInstance().universalBucket != null) {
            ret = UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)this.fluid.getFluid());
        }
        return ret;
    }

    public ItemStack getExampleStack() {
        NonNullList ores;
        ItemStack ret = this.stack;
        if (ret.func_190926_b() && this.stackList != null && this.stackList.size() > 0) {
            ret = this.stackList.get(0);
        }
        if (ret.func_190926_b() && this.oreName != null && (ores = OreDictionary.getOres((String)this.oreName)) != null && ores.size() > 0) {
            ret = (ItemStack)ores.get(0);
        }
        if (ret.func_190926_b() && this.fluid != null && ForgeModContainer.getInstance().universalBucket != null) {
            ret = UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)this.fluid.getFluid());
        }
        return ret;
    }

    public Object getShapedRecipeInput() {
        Object ret = this.stack;
        if (ret == ItemStack.field_190927_a && this.stackList != null && this.stackList.size() > 0) {
            ret = this.stackList;
        }
        if (ret == ItemStack.field_190927_a && this.oreName != null) {
            ret = OreDictionary.getOres((String)this.oreName);
        }
        if (ret == ItemStack.field_190927_a && this.fluid != null && ForgeModContainer.getInstance().universalBucket != null) {
            ret = UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)this.fluid.getFluid());
        }
        return ret;
    }

    public boolean matchesItemStack(ItemStack input) {
        FluidStack fs;
        if (input.func_190926_b()) {
            return false;
        }
        if (this.fluid != null && (fs = FluidUtil.getFluidContained((ItemStack)input)) != null && fs.containsFluid(this.fluid)) {
            return true;
        }
        if (this.oreName != null) {
            return ApiUtils.compareToOreName(input, this.oreName) && this.inputSize <= input.func_190916_E();
        }
        if (this.stackList != null) {
            for (ItemStack iStack : this.stackList) {
                if (!OreDictionary.itemMatches((ItemStack)iStack, (ItemStack)input, (boolean)false) || this.inputSize > input.func_190916_E()) continue;
                return true;
            }
        }
        if (!OreDictionary.itemMatches((ItemStack)this.stack, (ItemStack)input, (boolean)false) || this.inputSize > input.func_190916_E()) {
            return false;
        }
        if (this.useNBT) {
            if (this.stack.func_77942_o() != input.func_77942_o()) {
                return false;
            }
            if (!this.stack.func_77942_o() && !input.func_77942_o()) {
                return true;
            }
            if (!this.stack.func_77978_p().equals((Object)input.func_77978_p())) {
                return false;
            }
        }
        return true;
    }

    public boolean matchesItemStackIgnoringSize(ItemStack input) {
        FluidStack fs;
        if (input.func_190926_b()) {
            return false;
        }
        if (this.fluid != null && (fs = FluidUtil.getFluidContained((ItemStack)input)) != null && fs.containsFluid(this.fluid)) {
            return true;
        }
        if (this.oreName != null) {
            return ApiUtils.compareToOreName(input, this.oreName);
        }
        if (this.stackList != null) {
            for (ItemStack iStack : this.stackList) {
                if (!OreDictionary.itemMatches((ItemStack)iStack, (ItemStack)input, (boolean)false)) continue;
                return true;
            }
        }
        if (!OreDictionary.itemMatches((ItemStack)this.stack, (ItemStack)input, (boolean)false)) {
            return false;
        }
        if (this.useNBT) {
            if (this.stack.func_77942_o() != input.func_77942_o()) {
                return false;
            }
            if (!this.stack.func_77942_o() && !input.func_77942_o()) {
                return true;
            }
            if (!this.stack.func_77978_p().equals((Object)input.func_77978_p())) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IngredientStack)) {
            return false;
        }
        if (this.fluid != null && ((IngredientStack)object).fluid != null) {
            return this.fluid.equals((Object)((IngredientStack)object).fluid);
        }
        if (this.oreName != null && ((IngredientStack)object).oreName != null) {
            return this.oreName.equals(((IngredientStack)object).oreName);
        }
        if (this.stackList != null && ((IngredientStack)object).stackList != null) {
            for (ItemStack iStack : this.stackList) {
                for (ItemStack iStack2 : ((IngredientStack)object).stackList) {
                    if (!OreDictionary.itemMatches((ItemStack)iStack, (ItemStack)iStack2, (boolean)false)) continue;
                    return true;
                }
            }
            return false;
        }
        if (!this.stack.func_190926_b() && !((IngredientStack)object).stack.func_190926_b()) {
            ItemStack otherStack = ((IngredientStack)object).stack;
            if (!OreDictionary.itemMatches((ItemStack)this.stack, (ItemStack)otherStack, (boolean)false)) {
                return false;
            }
            if (this.useNBT) {
                if (this.stack.func_77942_o() != otherStack.func_77942_o()) {
                    return false;
                }
                if (!this.stack.func_77942_o() && !otherStack.func_77942_o()) {
                    return true;
                }
                if (!this.stack.func_77978_p().equals((Object)otherStack.func_77978_p())) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.fluid != null) {
            nbt.func_74778_a("fluid", FluidRegistry.getFluidName((FluidStack)this.fluid));
            nbt.func_74768_a("fluidAmount", this.fluid.amount);
            nbt.func_74768_a("nbtType", 3);
        } else if (this.oreName != null) {
            nbt.func_74778_a("oreName", this.oreName);
            nbt.func_74768_a("nbtType", 2);
        } else if (this.stackList != null) {
            NBTTagList list = new NBTTagList();
            for (ItemStack stack : this.stackList) {
                if (stack.func_190926_b()) continue;
                list.func_74742_a((NBTBase)stack.func_77955_b(new NBTTagCompound()));
            }
            nbt.func_74782_a("stackList", (NBTBase)list);
            nbt.func_74768_a("nbtType", 1);
        } else {
            nbt.func_74782_a("stack", (NBTBase)this.stack.func_77955_b(new NBTTagCompound()));
            nbt.func_74768_a("nbtType", 0);
            nbt.func_74757_a("useNBT", this.useNBT);
        }
        nbt.func_74768_a("inputSize", this.inputSize);
        return nbt;
    }

    public static IngredientStack readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("nbtType")) {
            switch (nbt.func_74762_e("nbtType")) {
                case 0: {
                    ItemStack stack = new ItemStack(nbt.func_74775_l("stack"));
                    stack.func_190920_e(nbt.func_74762_e("inputSize"));
                    IngredientStack ingr = new IngredientStack(stack);
                    ingr.useNBT = nbt.func_74767_n("useNBT");
                    return ingr;
                }
                case 1: {
                    NBTTagList list = nbt.func_150295_c("stackList", 10);
                    ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        stackList.add(new ItemStack(list.func_150305_b(i)));
                    }
                    return new IngredientStack(stackList, nbt.func_74762_e("inputSize"));
                }
                case 2: {
                    return new IngredientStack(nbt.func_74779_i("oreName"), nbt.func_74762_e("inputSize"));
                }
                case 3: {
                    FluidStack fs = new FluidStack(FluidRegistry.getFluid((String)nbt.func_74779_i("fluid")), nbt.func_74762_e("fluidAmount"));
                    return new IngredientStack(fs);
                }
            }
        }
        return null;
    }
}

