/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.fabric;

import at.petrak.paucal.PaucalConfig;
import at.petrak.paucal.api.PaucalAPI;
import io.github.fablabsmc.fablabs.api.fiber.v1.builder.ConfigTreeBuilder;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public class FabricPaucalConfig {
    private static Common COMMON = new Common();

    private static void writeDefaultConfig(ConfigTree config, Path path, JanksonValueSerializer serializer) {
        try (BufferedOutputStream s2 = new BufferedOutputStream(Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW));){
            FiberSerialization.serialize((ConfigTree)config, (OutputStream)s2, (ValueSerializer)serializer);
        }
        catch (FileAlreadyExistsException s2) {
        }
        catch (IOException e) {
            PaucalAPI.LOGGER.error("Error writing default config", (Throwable)e);
        }
    }

    private static void setupConfig(ConfigTree config, Path p, JanksonValueSerializer serializer) {
        FabricPaucalConfig.writeDefaultConfig(config, p, serializer);
        try (BufferedInputStream s = new BufferedInputStream(Files.newInputStream(p, StandardOpenOption.READ, StandardOpenOption.CREATE));){
            FiberSerialization.deserialize((ConfigTree)config, (InputStream)s, (ValueSerializer)serializer);
        }
        catch (ValueDeserializationException | IOException e) {
            PaucalAPI.LOGGER.error("Error loading config from {}", (Object)p, (Object)e);
        }
    }

    public static void setup() {
        try {
            Files.createDirectory(Paths.get("config", new String[0]), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            PaucalAPI.LOGGER.warn("Failed to make config dir", (Throwable)e);
        }
        JanksonValueSerializer serializer = new JanksonValueSerializer(false);
        ConfigTree common = COMMON.configure(ConfigTree.builder());
        FabricPaucalConfig.setupConfig(common, Paths.get("config", "paucal-common.json5"), serializer);
        PaucalConfig.setCommon(COMMON);
    }

    private static final class Common
    implements PaucalConfig.ConfigAccess {
        private final PropertyMirror<Boolean> allowPats = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        private final PropertyMirror<Boolean> loadContributors = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);

        private Common() {
        }

        public ConfigTree configure(ConfigTreeBuilder bob) {
            bob.beginValue("allowPats", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Whether to allow patting players with a shift-right-click.").finishValue(arg_0 -> this.allowPats.mirror(arg_0)).beginValue("loadContributors", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Whether to load contributor info from the internet.\nIf false, no one will appear as a contributor.").finishValue(arg_0 -> this.loadContributors.mirror(arg_0));
            return bob.build();
        }

        @Override
        public boolean allowPats() {
            return (Boolean)this.allowPats.getValue();
        }

        @Override
        public boolean loadContributors() {
            return (Boolean)this.loadContributors.getValue();
        }
    }
}

