/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.common.misc;

import at.petrak.paucal.PaucalConfig;
import at.petrak.paucal.api.contrib.Contributor;
import at.petrak.paucal.common.Contributors;
import at.petrak.paucal.xplat.IXplatAbstractions;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PatPat {
    public static InteractionResult onPat(Player player, Level world, InteractionHand hand, Entity entity, @Nullable EntityHitResult hitResult) {
        if (!PaucalConfig.common().allowPats()) {
            return InteractionResult.PASS;
        }
        if (player.getItemInHand(hand).isEmpty() && player.isDiscrete() && hand == InteractionHand.MAIN_HAND && entity instanceof Player) {
            ResourceLocation soundKey;
            SoundEvent sound;
            String soundKeyStr;
            Player target = (Player)entity;
            Level level = player.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel sworld = (ServerLevel)level;
                Vec3 pos = target.getEyePosition();
                sworld.sendParticles((ParticleOptions)ParticleTypes.HEART, pos.x, pos.y + 0.5, pos.z, 1, 0.0, 0.0, 0.0, 0.1);
            } else {
                player.swing(hand);
            }
            Contributor contributor = Contributors.getContributor(target.getUUID());
            if (contributor != null && (soundKeyStr = contributor.getString("paucal:patSound")) != null && (sound = IXplatAbstractions.INSTANCE.getSoundByID(soundKey = new ResourceLocation(soundKeyStr))) != null) {
                Float pitchCenter = Objects.requireNonNullElse(contributor.getFloat("paucal:patPitchCenter"), Float.valueOf(1.0f));
                target.getLevel().playSound(player, target.getX(), target.getEyeY(), target.getZ(), sound, SoundSource.PLAYERS, 1.0f, pitchCenter.floatValue() + (float)(Math.random() - 0.5) * 0.5f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

