/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.common.command;

import at.petrak.paucal.api.contrib.Contributor;
import at.petrak.paucal.api.contrib.ContributorType;
import at.petrak.paucal.common.Contributors;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;

public class CommandGetContributorInfo {
    public static void add(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.literal((String)"getInfo").then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(ctx -> CommandGetContributorInfo.info((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"target"), false))).then(Commands.literal((String)"getAll").executes(ctx -> CommandGetContributorInfo.info((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"target"), true)))));
    }

    private static int info(CommandContext<CommandSourceStack> ctx, ServerPlayer target, boolean allKVs) {
        Contributor contrib = Contributors.getContributor(target.getUUID());
        if (contrib == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)new TranslatableComponent("command.paucal.contributor.not_contributor", new Object[]{target.getDisplayName()}));
            return 0;
        }
        ContributorType type = contrib.getContributorType();
        Set<String> keySet = contrib.allKeys();
        TranslatableComponent out = new TranslatableComponent("command.paucal.contributor", new Object[]{target.getDisplayName(), type.level(), type.isDev(), type.isCool(), keySet.size()});
        if (allKVs) {
            List keys = keySet.stream().sorted().toList();
            for (String key : keys) {
                out.append("\n- ");
                out.append((Component)new TextComponent(key).withStyle(ChatFormatting.GOLD));
                out.append((Component)new TextComponent(": "));
                out.append((Component)new TextComponent(String.valueOf(contrib.get(key))).withStyle(ChatFormatting.LIGHT_PURPLE));
            }
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess((Component)out, true);
        return keySet.size();
    }
}

