/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.xplat;

import at.petrak.paucal.api.PaucalAPI;
import at.petrak.paucal.api.msg.PaucalMessage;
import at.petrak.paucal.xplat.Platform;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface IXplatAbstractions {
    public static final IXplatAbstractions INSTANCE = IXplatAbstractions.find();

    public Platform platform();

    @Nullable
    public SoundEvent getSoundByID(ResourceLocation var1);

    public void saveRecipeAdvancement(DataGenerator var1, CachedOutput var2, JsonObject var3, Path var4);

    public void sendPacketToPlayerS2C(ServerPlayer var1, PaucalMessage var2);

    public void sendPacketNearS2C(Vec3 var1, double var2, ServerLevel var4, PaucalMessage var5);

    default public void init() {
        PaucalAPI.LOGGER.info("Hello PAUCAL! This is {}!", (Object)this.platform());
    }

    private static IXplatAbstractions find() {
        List<ServiceLoader.Provider<IXplatAbstractions>> providers = ServiceLoader.load(IXplatAbstractions.class).stream().toList();
        if (providers.size() != 1) {
            String names = providers.stream().map(p -> p.type().getName()).collect(Collectors.joining(",", "[", "]"));
            throw new IllegalStateException("There should be exactly one IXplatAbstractions implementation on the classpath. Found: " + names);
        }
        ServiceLoader.Provider<IXplatAbstractions> provider = providers.get(0);
        PaucalAPI.LOGGER.debug("Instantiating xplat impl: " + provider.type().getName());
        return provider.get();
    }
}

