/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.common.sounds;

import com.mojang.blaze3d.audio.OggAudioStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.sounds.AudioStream;

public class ImmediateAudioStream
implements AudioStream {
    protected final OggAudioStream backing;
    protected ByteBuffer lazyRead;

    public ImmediateAudioStream(OggAudioStream backing) {
        this.backing = backing;
        this.lazyRead = null;
    }

    public AudioFormat getFormat() {
        return this.backing.getFormat();
    }

    public ByteBuffer read(int size) throws IOException {
        if (this.lazyRead == null) {
            this.lazyRead = this.backing.readAll();
            this.backing.close();
        }
        int maxSize = Math.min(size, this.lazyRead.remaining());
        ByteBuffer out = this.lazyRead.slice(0, maxSize);
        this.lazyRead.position(this.lazyRead.position() + maxSize);
        return out;
    }

    public void close() throws IOException {
        this.lazyRead.clear();
    }
}

