/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.common.advancement;

import at.petrak.paucal.api.contrib.Contributor;
import at.petrak.paucal.common.ContributorsManifest;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.UUID;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.Nullable;

public class BeContributorTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("paucal", "login_as_patron");
    private static final String TAG_PATRON_LEVEL = "patron_level";
    private static final String TAG_IS_DEV = "is_dev";

    protected Instance createInstance(JsonObject json, EntityPredicate.Composite predicate, DeserializationContext ctx) {
        Boolean isDev = json.has(TAG_IS_DEV) ? Boolean.valueOf(GsonHelper.getAsBoolean((JsonObject)json, (String)TAG_IS_DEV)) : null;
        return new Instance(predicate, MinMaxBounds.Ints.fromJson((JsonElement)json.get(TAG_PATRON_LEVEL)), isDev);
    }

    public ResourceLocation getId() {
        return ID;
    }

    public void trigger(ServerPlayer player) {
        super.trigger(player, inst -> {
            UUID uuid = player.getUUID();
            Contributor profile = ContributorsManifest.getContributor(uuid);
            if (profile == null) {
                return false;
            }
            return inst.patronLevel.matches(profile.getLevel()) && (inst.isDev == null || inst.isDev.booleanValue() == profile.isDev());
        });
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        protected final MinMaxBounds.Ints patronLevel;
        @Nullable
        protected final Boolean isDev;

        public Instance(EntityPredicate.Composite predicate, MinMaxBounds.Ints patronLevel, @Nullable Boolean isDev) {
            super(ID, predicate);
            this.patronLevel = patronLevel;
            this.isDev = isDev;
        }

        public JsonObject serializeToJson(SerializationContext ctx) {
            JsonObject json = super.serializeToJson(ctx);
            if (!this.patronLevel.isAny()) {
                json.add(BeContributorTrigger.TAG_PATRON_LEVEL, this.patronLevel.serializeToJson());
            }
            if (this.isDev != null) {
                json.addProperty(BeContributorTrigger.TAG_IS_DEV, this.isDev);
            }
            return json;
        }
    }
}

