/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.api.datagen;

import at.petrak.paucal.api.mixin.AccessorRecipeProvider;
import at.petrak.paucal.xplat.IXplatAbstractions;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public abstract class PaucalRecipeProvider
extends RecipeProvider {
    public final DataGenerator generator;
    protected final String modid;

    public PaucalRecipeProvider(DataGenerator gen, String modid) {
        super(gen);
        this.generator = gen;
        this.modid = modid;
    }

    public void run(CachedOutput cache) {
        Path path = this.generator.getOutputFolder();
        HashSet set = Sets.newHashSet();
        this.makeRecipes(recipeJsonProvider -> {
            if (!set.add(recipeJsonProvider.getId())) {
                throw new IllegalStateException("Duplicate recipe " + recipeJsonProvider.getId());
            }
            AccessorRecipeProvider.paucal$SaveRecipe(cache, recipeJsonProvider.serializeRecipe(), path.resolve("data/" + recipeJsonProvider.getId().getNamespace() + "/recipes/" + recipeJsonProvider.getId().getPath() + ".json"));
            JsonObject jsonObject = recipeJsonProvider.serializeAdvancement();
            if (jsonObject != null) {
                IXplatAbstractions.INSTANCE.saveRecipeAdvancement(this.generator, cache, jsonObject, path.resolve("data/" + recipeJsonProvider.getId().getNamespace() + "/advancements/" + recipeJsonProvider.getAdvancementId().getPath() + ".json"));
            }
        });
    }

    protected abstract void makeRecipes(Consumer<FinishedRecipe> var1);

    protected ShapedRecipeBuilder ring(ItemLike out, int count, Ingredient outer, @Nullable Ingredient inner) {
        return this.ringCornered(out, count, outer, outer, inner);
    }

    protected ShapedRecipeBuilder ring(ItemLike out, int count, ItemLike outer, @Nullable ItemLike inner) {
        return this.ring(out, count, Ingredient.of((ItemLike[])new ItemLike[]{outer}), this.ingredientOf(inner));
    }

    protected ShapedRecipeBuilder ring(ItemLike out, int count, TagKey<Item> outer, @Nullable TagKey<Item> inner) {
        return this.ring(out, count, Ingredient.of(outer), this.ingredientOf(inner));
    }

    protected ShapedRecipeBuilder ringCornerless(ItemLike out, int count, Ingredient outer, @Nullable Ingredient inner) {
        return this.ringCornered(out, count, outer, null, inner);
    }

    protected ShapedRecipeBuilder ringCornerless(ItemLike out, int count, ItemLike outer, @Nullable ItemLike inner) {
        return this.ringCornerless(out, count, Ingredient.of((ItemLike[])new ItemLike[]{outer}), this.ingredientOf(inner));
    }

    protected ShapedRecipeBuilder ringCornerless(ItemLike out, int count, TagKey<Item> outer, @Nullable TagKey<Item> inner) {
        return this.ringCornerless(out, count, Ingredient.of(outer), this.ingredientOf(inner));
    }

    protected ShapedRecipeBuilder ringAll(ItemLike out, int count, Ingredient outer, @Nullable Ingredient inner) {
        return this.ringCornered(out, count, outer, outer, inner);
    }

    protected ShapedRecipeBuilder ringAll(ItemLike out, int count, ItemLike outer, @Nullable ItemLike inner) {
        return this.ringAll(out, count, Ingredient.of((ItemLike[])new ItemLike[]{outer}), this.ingredientOf(inner));
    }

    protected ShapedRecipeBuilder ringAll(ItemLike out, int count, TagKey<Item> outer, @Nullable TagKey<Item> inner) {
        return this.ringAll(out, count, Ingredient.of(outer), this.ingredientOf(inner));
    }

    protected ShapedRecipeBuilder ringCornered(ItemLike out, int count, @Nullable Ingredient cardinal, @Nullable Ingredient diagonal, @Nullable Ingredient inner) {
        if (cardinal == null && diagonal == null && inner == null) {
            throw new IllegalArgumentException("at least one ingredient must be non-null");
        }
        if (inner != null && cardinal == null && diagonal == null) {
            throw new IllegalArgumentException("if inner is non-null, either cardinal or diagonal must not be");
        }
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((ItemLike)out, (int)count);
        char C = ' ';
        if (cardinal != null) {
            builder.define(Character.valueOf('C'), cardinal);
            C = 'C';
        }
        char D = ' ';
        if (diagonal != null) {
            builder.define(Character.valueOf('D'), diagonal);
            D = 'D';
        }
        char I = ' ';
        if (inner != null) {
            builder.define(Character.valueOf('I'), inner);
            I = 'I';
        }
        builder.pattern(String.format("%c%c%c", Character.valueOf(D), Character.valueOf(C), Character.valueOf(D))).pattern(String.format("%c%c%c", Character.valueOf(C), Character.valueOf(I), Character.valueOf(C))).pattern(String.format("%c%c%c", Character.valueOf(D), Character.valueOf(C), Character.valueOf(D)));
        return builder;
    }

    protected ShapedRecipeBuilder ringCornered(ItemLike out, int count, @Nullable ItemLike cardinal, @Nullable ItemLike diagonal, @Nullable ItemLike inner) {
        return this.ringCornered(out, count, this.ingredientOf(cardinal), this.ingredientOf(diagonal), this.ingredientOf(inner));
    }

    protected ShapedRecipeBuilder ringCornered(ItemLike out, int count, @Nullable TagKey<Item> cardinal, @Nullable TagKey<Item> diagonal, @Nullable TagKey<Item> inner) {
        return this.ringCornered(out, count, this.ingredientOf(cardinal), this.ingredientOf(diagonal), this.ingredientOf(inner));
    }

    protected ShapedRecipeBuilder stack(ItemLike out, int count, Ingredient top, Ingredient bottom) {
        return ShapedRecipeBuilder.shaped((ItemLike)out, (int)count).define(Character.valueOf('T'), top).define(Character.valueOf('B'), bottom).pattern("T").pattern("B");
    }

    protected ShapedRecipeBuilder stack(ItemLike out, int count, ItemLike top, ItemLike bottom) {
        return this.stack(out, count, Ingredient.of((ItemLike[])new ItemLike[]{top}), Ingredient.of((ItemLike[])new ItemLike[]{bottom}));
    }

    protected ShapedRecipeBuilder stack(ItemLike out, int count, TagKey<Item> top, TagKey<Item> bottom) {
        return this.stack(out, count, Ingredient.of(top), Ingredient.of(bottom));
    }

    protected ShapedRecipeBuilder stick(ItemLike out, int count, Ingredient input) {
        return this.stack(out, count, input, input);
    }

    protected ShapedRecipeBuilder stick(ItemLike out, int count, ItemLike input) {
        return this.stick(out, count, Ingredient.of((ItemLike[])new ItemLike[]{input}));
    }

    protected ShapedRecipeBuilder stick(ItemLike out, int count, TagKey<Item> input) {
        return this.stick(out, count, Ingredient.of(input));
    }

    protected void packing(ItemLike free, ItemLike compressed, String freeName, boolean largeSize, Consumer<FinishedRecipe> recipes) {
        ShapedRecipeBuilder pack = ShapedRecipeBuilder.shaped((ItemLike)compressed).define(Character.valueOf('X'), free);
        if (largeSize) {
            pack.pattern("XXX").pattern("XXX").pattern("XXX");
        } else {
            pack.pattern("XX").pattern("XX");
        }
        pack.unlockedBy("has_item", (CriterionTriggerInstance)PaucalRecipeProvider.hasItem(free)).save(recipes, this.modLoc(freeName + "_packing"));
        ShapelessRecipeBuilder.shapeless((ItemLike)free, (int)(largeSize ? 9 : 4)).requires(compressed).unlockedBy("has_item", (CriterionTriggerInstance)PaucalRecipeProvider.hasItem(free)).save(recipes, this.modLoc(freeName + "_unpacking"));
    }

    protected ResourceLocation modLoc(String path) {
        return new ResourceLocation(this.modid, path);
    }

    @Nullable
    protected Ingredient ingredientOf(@Nullable ItemLike item) {
        return item == null ? null : Ingredient.of((ItemLike[])new ItemLike[]{item});
    }

    @Nullable
    protected Ingredient ingredientOf(@Nullable TagKey<Item> item) {
        return item == null ? null : Ingredient.of(item);
    }

    protected static InventoryChangeTrigger.TriggerInstance hasItem(MinMaxBounds.Ints p_176521_, ItemLike p_176522_) {
        return PaucalRecipeProvider.paucalInventoryTrigger(ItemPredicate.Builder.item().of(new ItemLike[]{p_176522_}).withCount(p_176521_).build());
    }

    protected static InventoryChangeTrigger.TriggerInstance hasItem(ItemLike p_125978_) {
        return PaucalRecipeProvider.paucalInventoryTrigger(ItemPredicate.Builder.item().of(new ItemLike[]{p_125978_}).build());
    }

    protected static InventoryChangeTrigger.TriggerInstance hasItem(TagKey<Item> p_206407_) {
        return PaucalRecipeProvider.paucalInventoryTrigger(ItemPredicate.Builder.item().of(p_206407_).build());
    }

    protected static InventoryChangeTrigger.TriggerInstance paucalInventoryTrigger(ItemPredicate ... $$0) {
        return new InventoryChangeTrigger.TriggerInstance(EntityPredicate.Composite.ANY, MinMaxBounds.Ints.ANY, MinMaxBounds.Ints.ANY, MinMaxBounds.Ints.ANY, $$0);
    }
}

