/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.api.datagen;

import at.petrak.paucal.api.PaucalAPI;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public abstract class PaucalLootTableProvider
extends LootTableProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected final DataGenerator generator;

    public PaucalLootTableProvider(DataGenerator pGenerator) {
        super(pGenerator);
        this.generator = pGenerator;
    }

    protected abstract void makeLootTables(Map<Block, LootTable.Builder> var1, Map<ResourceLocation, LootTable.Builder> var2);

    protected LootPool.Builder dropThisPool(ItemLike item, int count) {
        return this.dropThisPool(item, (NumberProvider)ConstantValue.exactly((float)count));
    }

    protected LootPool.Builder dropThisPool(ItemLike item, NumberProvider count) {
        return LootPool.lootPool().setRolls(count).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item));
    }

    @SafeVarargs
    protected final void dropSelf(Map<Block, LootTable.Builder> lootTables, Supplier<? extends Block> ... blocks) {
        for (Supplier<? extends Block> blockSupp : blocks) {
            Block block = blockSupp.get();
            this.dropSelf(block, lootTables);
        }
    }

    protected void dropSelf(Map<Block, LootTable.Builder> lootTables, Block ... blocks) {
        for (Block block : blocks) {
            this.dropSelf(block, lootTables);
        }
    }

    protected void dropSelf(Block block, Map<Block, LootTable.Builder> lootTables) {
        LootTable.Builder table = LootTable.lootTable().withPool(this.dropThisPool((ItemLike)block, 1));
        lootTables.put(block, table);
    }

    protected void dropThis(Block block, ItemLike drop, Map<Block, LootTable.Builder> lootTables) {
        LootTable.Builder table = LootTable.lootTable().withPool(this.dropThisPool(drop, 1));
        lootTables.put(block, table);
    }

    protected void dropThis(Block block, ItemLike drop, NumberProvider count, Map<Block, LootTable.Builder> lootTables) {
        LootTable.Builder table = LootTable.lootTable().withPool(this.dropThisPool(drop, count));
        lootTables.put(block, table);
    }

    public void run(CachedOutput cache) {
        HashMap<Block, LootTable.Builder> blockTables = new HashMap<Block, LootTable.Builder>();
        HashMap<ResourceLocation, LootTable.Builder> lootTables = new HashMap<ResourceLocation, LootTable.Builder>();
        this.makeLootTables(blockTables, lootTables);
        for (Map.Entry<Block, LootTable.Builder> entry : blockTables.entrySet()) {
            LootTable.Builder old = lootTables.put(entry.getKey().getLootTable(), entry.getValue().setParamSet(LootContextParamSets.BLOCK));
            if (old == null) continue;
            PaucalAPI.LOGGER.warn("Whoopsy, {} clobbered a loot table '{}': {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), entry.getKey(), old});
        }
        Path outputFolder = this.generator.getOutputFolder();
        lootTables.forEach((key, lootTable) -> {
            Path path = outputFolder.resolve("data/" + key.getNamespace() + "/loot_tables/" + key.getPath() + ".json");
            try {
                DataProvider.saveStable((CachedOutput)cache, (JsonElement)LootTables.serialize((LootTable)lootTable.build()), (Path)path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }
}

